--[[-----------------------------------------------------------------------------------------------------------------------------
Profile Functions
These functions save and load configurations, which include button spells and spell options. This is useful for multiple specs, or Raid/PvP settings.
---------------------------------------------------------------------------------------------------------------------------------]]
local addonName, L = ...; 
local function defaultFunc(L, key) 
return key; 
end 
setmetatable(L, {__index=defaultFunc});


function HUI_Profiles_Init()
	for p=1,3 do
		HUI_Profile[p] = {}
		HUI_Profile[p].NumButtons = 4
				
		HUI_Profile[p].HUI_Spell_Button={}
		for b = 1, HUI_Max_Buttons do -- Buttons. Can have up to HUI_Max_Buttons buttons per bar.
			HUI_Profile[p].HUI_Spell_Button[b]={}
			HUI_Profile[p].HUI_Spell_Button[b].SpellName = nil
			HUI_Profile[p].HUI_Spell_Button[b].isMacro = nil
			HUI_Profile[p].HUI_Spell_Button[b].MacroSpell = nil
			
			HUI_Profile[p].HUI_Spell_Button[b].CheckIfActive = nil;
			HUI_Profile[p].HUI_Spell_Button[b].IsMine = nil;
			HUI_Profile[p].HUI_Spell_Button[b].CheckDebuff = nil;
			HUI_Profile[p].HUI_Spell_Button[b].DebuffDisease = nil;
			HUI_Profile[p].HUI_Spell_Button[b].DebuffMagic = nil;
			HUI_Profile[p].HUI_Spell_Button[b].DebuffPoison = nil;
			HUI_Profile[p].HUI_Spell_Button[b].DebuffCurse = nil;
			HUI_Profile[p].HUI_Spell_Button[b].DebuffWeakenedSoul = nil;
			
			HUI_Profile[p].HUI_Spell_Button[b].hasProc = nil
			HUI_Profile[p].HUI_Spell_Button[b].ProcName = nil

			HUI_Profile[p].HUI_Spell_Button[b].CastOnDead = nil;
			HUI_Profile[p].HUI_Spell_Button[b].IfAggro = nil;
		end
	end
end

function HUI_Profile_Save(pSlot)
	if not (pSlot) or (pSlot<1) or (pSlot>3) then return; end
	local pName = "";
	local eBox = getglobal("HUI_Menu_Profile_Name_EditBox"..pSlot);
	if (eBox) then
		pName = eBox:GetText()
	end
	HUI_Chat(L["Saving " .. pName .. " Profile "]..pSlot)
	
	HUI_Profile[pSlot].Name = pName;
	for b = 1, HUI_Max_Buttons do
		HUI_Profile[pSlot].HUI_Spell_Button[b].SpellName = HUI_Spell_Button[b].SpellName
		HUI_Profile[pSlot].HUI_Spell_Button[b].isMacro = HUI_Spell_Button[b].isMacro;
		HUI_Profile[pSlot].HUI_Spell_Button[b].MacroSpell = HUI_Spell_Button[b].MacroSpell;
		
		HUI_Profile[pSlot].HUI_Spell_Button[b].CheckIfActive = HUI_Spell_Button[b].CheckIfActive;
		HUI_Profile[pSlot].HUI_Spell_Button[b].IsMine = HUI_Spell_Button[b].IsMine;
		HUI_Profile[pSlot].HUI_Spell_Button[b].CheckDebuff = HUI_Spell_Button[b].CheckDebuff;
		HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffDisease = HUI_Spell_Button[b].DebuffDisease;
		HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffMagic = HUI_Spell_Button[b].DebuffMagic;
		HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffPoison = HUI_Spell_Button[b].DebuffPoison;
		HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffCurse = HUI_Spell_Button[b].DebuffCurse;
		HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffWeakenedSoul = HUI_Spell_Button[b].DebuffWeakenedSoul;
		
		HUI_Profile[pSlot].HUI_Spell_Button[b].hasProc = HUI_Spell_Button[b].hasProc;
		HUI_Profile[pSlot].HUI_Spell_Button[b].ProcName = HUI_Spell_Button[b].ProcName;

		HUI_Profile[pSlot].HUI_Spell_Button[b].CastOnDead = HUI_Spell_Button[b].CastOnDead;
		HUI_Profile[pSlot].HUI_Spell_Button[b].IfAggro = HUI_Spell_Button[b].IfAggro;
	end
	HUI_Profile[pSlot].NumButtons = HUI_Settings.NumberButtons
end

function HUI_Profile_Load(pSlot)
	if not (pSlot) or (pSlot<1) or (pSlot>3) then return; end
	HUI_Chat(L["Loading Profile "]..pSlot)
	for b=1, 12 do
		HUI_Spell_Button[b].SpellName = HUI_Profile[pSlot].HUI_Spell_Button[b].SpellName
		HUI_Spell_Button[b].isMacro = HUI_Profile[pSlot].HUI_Spell_Button[b].isMacro;
		HUI_Spell_Button[b].MacroSpell = HUI_Profile[pSlot].HUI_Spell_Button[b].MacroSpell;
				
		HUI_Spell_Button[b].CheckIfActive = HUI_Profile[pSlot].HUI_Spell_Button[b].CheckIfActive;
		HUI_Spell_Button[b].IsMine = HUI_Profile[pSlot].HUI_Spell_Button[b].IsMine;
		HUI_Spell_Button[b].CheckDebuff = HUI_Profile[pSlot].HUI_Spell_Button[b].CheckDebuff;
		HUI_Spell_Button[b].DebuffDisease = HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffDisease;
		HUI_Spell_Button[b].DebuffMagic = HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffMagic;
		HUI_Spell_Button[b].DebuffPoison = HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffPoison;
		HUI_Spell_Button[b].DebuffCurse = HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffCurse;
		HUI_Spell_Button[b].DebuffWeakenedSoul = HUI_Profile[pSlot].HUI_Spell_Button[b].DebuffWeakenedSoul;
		
		HUI_Spell_Button[b].hasProc = HUI_Profile[pSlot].HUI_Spell_Button[b].hasProc;
		HUI_Spell_Button[b].ProcName = HUI_Profile[pSlot].HUI_Spell_Button[b].ProcName;

		HUI_Spell_Button[b].CastOnDead = HUI_Profile[pSlot].HUI_Spell_Button[b].CastOnDead;
		HUI_Spell_Button[b].IfAggro = HUI_Profile[pSlot].HUI_Spell_Button[b].IfAggro;
	end
	HUI_Settings.NumberButtons = HUI_Profile[pSlot].NumButtons
	HUI_SpellChange = true;
end


function HUI_Menu_ShowProfileNames()
	if (not HUI_Profile) then HUI_Profiles_Init(); end
	for p=1,3 do
		if (not HUI_Profile[p]) then HUI_Profiles_Init(); end
		local eBox = getglobal("HUI_Menu_Profile_Name_EditBox"..p);
		if (eBox) then
			if (HUI_Profile[p].Name) then
				eBox:SetText(HUI_Profile[p].Name);
			else
				--if (HUI_Profile[p].HUI_Spell_Button[1].SpellName) then
					eBox:SetText("unknown");
				--else
					--eBox:SetText("unused");
				--end
			end
		end
	end
end






--[[-----------------------------------------------------------------------------------------------------------------------------
Stored Raid Positions Functions
These functions save and load current raid positions, so they can be loaded again for the next raid. Saves time repositioning everytime.
---------------------------------------------------------------------------------------------------------------------------------]]

function HUI_StoredRaidPositions_Init()
	for s=1,3 do
		HUI_StoredRaidPositions_Clear(s)
	end
end

function HUI_StoredRaidPositions_Clear(sSlot)
	if not (sSlot) or (sSlot<1) or (sSlot>3) then return; end
	if (not	HUI_StoredPositions) then
		HUI_StoredPositions = {}
	end
	HUI_StoredPositions[sSlot] = nil
	HUI_StoredPositions[sSlot] = {}
	HUI_StoredPositions[sSlot].Desc = nil;
	HUI_StoredPositions[sSlot].ByName = nil;
	HUI_StoredPositions[sSlot].ByName = {}
end


function HUI_StoredRaidPositions_Save(pSlot)
	if not (pSlot) or (pSlot<1) or (pSlot>3) then return; end
	local pName = "";
	local eBox = getglobal("HUI_Menu_StoredRaidPositions_Name_EditBox"..pSlot);
	if (eBox) then
		pName = eBox:GetText()
	end
	HUI_Chat("Saving " .. pName .. " Raid Positions "..pSlot)
	HUI_StoredRaidPositions_Clear(pSlot); -- Clear any old saved spots, otherwise people not in current raid may still have saved spots.
	HUI_StoredPositions[pSlot].Desc = pName;
	for i = 1, HUI_Num_Favs do
		HUI_StoredPositions[pSlot].ByName[HUI_Fav_List[i]] = i;
	end
end

function HUI_StoredRaidPositions_Load(pSlot)
	if not (pSlot) or (pSlot<1) or (pSlot>3) then return; end
	HUI_Chat(L["Loading Stored Raid Positions "]..pSlot)
	--Bubble Sort by saved positions
	for x=1, HUI_Num_Favs do
		for y=1, HUI_Num_Favs-1 do
			if (HUI_StoredPositions[pSlot].ByName[HUI_Fav_List[y]]) and (HUI_StoredPositions[pSlot].ByName[HUI_Fav_List[y+1]]) then
				if (HUI_StoredPositions[pSlot].ByName[HUI_Fav_List[y]]<HUI_StoredPositions[pSlot].ByName[HUI_Fav_List[y+1]]) then
					-- Swap Positions (The lower position has a higher saved spot than the higher position)
					HUI_Fav_List[y], HUI_Fav_List[y+1] = HUI_Fav_List[y+1], HUI_Fav_List[y];
				end
			elseif (HUI_StoredPositions[pSlot].ByName[HUI_Fav_List[y+1]]) then
				-- Swap Positions (The higher position doesn't have saved spot, but lower does)
				HUI_Fav_List[y], HUI_Fav_List[y+1] = HUI_Fav_List[y+1], HUI_Fav_List[y];
			end
		end
	end
	
	-- Show new positions
	HUI_PartyChange = true;
end


function HUI_Menu_StoredRaidPositions_ShowNames()
	if (not HUI_StoredPositions) then HUI_StoredRaidPositions_Init(); end
	for p=1,3 do
		if (not HUI_StoredPositions[p]) then HUI_StoredRaidPositions_Init(); end
		local eBox = getglobal("HUI_Menu_StoredRaidPositions_Name_EditBox"..p);
		if (eBox) then
			if (HUI_StoredPositions[p].Desc) then
				eBox:SetText(HUI_StoredPositions[p].Desc);
			else
				eBox:SetText("");
			end
		end
	end
end




