--[[ ===========================================================================================================================
					Slash Command Handling Functions
=================================================================================================================================]]
local HUI_Menu_Select_Button = nil

local addonName, L = ...; 
local function defaultFunc(L, key) 
return key; 
end 
setmetatable(L, {__index=defaultFunc});

function HUI_Init_Slash()
-- Set up slash command hanler
	SLASH_HUIH1 = "/healui3";
	SLASH_HUIH2 = "/hui";
	SlashCmdList["HUIH"] = function (msg)
		HUI_SlashCmd(msg);
	end
end

function HUI_SlashCmd(arg, arg2)
		
	-- Show PartyTargets Config Menu
	if ( arg == "menu" ) then
		HUI_Menu_Load();
	end
		
	-- Initialize saved variables
	if ( arg == "init" ) then
		HUI_Init_Settings();
		DEFAULT_CHAT_FRAME:AddMessage(L["HealUI: Initializing saved variables"]);
	end
	
	if ( arg == "saveprofile1" ) then
		HUI_Profile_Save(1)
	end
	if ( arg == "saveprofile2" ) then
		HUI_Profile_Save(2)
	end
	if ( arg == "saveprofile3" ) then
		HUI_Profile_Save(3)
	end
	if ( arg == "loadprofile1" ) then
		HUI_Profile_Load(1)
	end
	if ( arg == "loadprofile2" ) then
		HUI_Profile_Load(2)
	end
	if ( arg == "loadprofile3" ) then
		HUI_Profile_Load(3)
	end
	if ( arg == "initprofiles" ) then
		HUI_Chat("Wiping saved profiles")
		HUI_Profiles_Init()
	end
	
	if ( arg == "reset" ) then
		HUI_SpellChange = true;
	end
	
	if ( arg == "width" ) then
		HUI_Set_Width()
	end
	
	
	if ( arg == "rui" ) then
		ReloadUI()
	end
	
	
	-- Enable Debug Mode
	if ( arg == "debugon" ) then
		HUI_Settings.Debug = 1
		HUI_Chat(L["Debug Mode is now On"])
	end
	
	-- Disable Debug Mode
	if ( arg == "debugoff" ) then
		HUI_Settings.Debug = nil
		HUI_Chat("Debug Mode is now Off")
	end
		
	if (arg=="") or ( arg == "help" ) then
		HUI_Chat(L["Available /hui Commands"])
		HUI_Chat(L["menu - Loads HealUI Menu"])
		HUI_Chat(L["init - Initialize HealUI Settings"])
		HUI_Chat(L["loadprofile1 - Load Profile from slot (1-3)"])
		HUI_Chat(L["saveprofile1 - Save Profile to slot (1-3)"])
		HUI_Chat(L["initprofiles - Wipes saved profiles"])
		HUI_Chat(L["rui - ReloadUI"])
	end
end



--[[ ============================================================================
					Menu Handling Functions
=================================================================================]]

HUI_Menu_FriendBar=1;

HUI_SO_BarInfo = {}
HUI_SO_BarInfo.Button = nil

function HUI_Menu_ResetPosition_Click()
	local mFrame = getglobal("HUI_Header_Frame")
	if (mFrame) then
		mFrame:SetPoint("CENTER")
	end
	
	local fFrame = getglobal("HUI_Fav_Header_Frame")
	if (fFrame) then
		fFrame:SetPoint("CENTER")
	end
	
end

--================================== MENU TAB TOOlTIP FUNCTIONS ==============================================================================
function HUI_Menu_Tab1_Panel_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["General Settings for HealUI"])
	GameTooltip:Show();
end
function HUI_Menu_Tab2_Panel_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["HealUI Panel appearance"])
	GameTooltip:Show();
end
function HUI_Menu_Tab3_Panel_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Set what Units to show"])
	GameTooltip:Show();
end


function HUI_Menu_CheckActive_CheckButton_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Check if spell is active on unit."])
	GameTooltip:Show();
end

function HUI_Menu_isMine_CheckButton_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Only show my spell."])
	GameTooltip:Show();
end

function HUI_Menu_CureDebuff_CheckButton_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Red highlight button if unit has a debuff this spell can cure."])
	GameTooltip:Show();
end
	
function HUI_Menu_DebuffCurse_CheckButton_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Check if unit is cursed."])
	GameTooltip:Show();
end

function HUI_Menu_DebuffDisease_CheckButton_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Check if unit is diseased."])
	GameTooltip:Show();
end

function HUI_Menu_DebuffMagic_CheckButton_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Check if unit has magic debuff."])
	GameTooltip:Show();
end

function HUI_Menu_DebuffPoison_CheckButton_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Check if unit is poisoned."])
	GameTooltip:Show();
end

function HUI_Menu_hasProc_CheckButton_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Alert if spell benefits from a Proc"])
	GameTooltip:Show();
end

function HUI_Menu_ProcName_EditBox_ShowTooltip(self)
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetText(L["Enter name of Proc as shown in buffs."])
	GameTooltip:Show();
end

--================================== MENU SPELL BUTTON FUNCTIONS ==============================================================================

function HUI_Menu_Scale_Slider_OnLoad()
	HUI_Menu_Scale_Slider:SetMinMaxValues(0.5,1.5);
	HUI_Menu_Scale_Slider:SetValueStep(0.01);
end
function HUI_Menu_Scale_Slider_OnValueChanged()
	HUI_MenuSettings.Scale = HUI_Menu_Scale_Slider:GetValue();
	HUI_Menu_Scale_EditBox:SetText(HUI_MenuSettings.Scale)
end

function HUI_Menu_Scale_EditBox_OnValueChanged()
	local tScale = tonumber(HUI_Menu_Scale_EditBox:GetText())
	if (tScale) and (tScale>=0.5) and (tScale<=1.5) then
		HUI_MenuSettings.Scale = tScale
		HUI_Menu_Scale_Slider:SetValue(HUI_MenuSettings.Scale)
	else
		HUI_Menu_Scale_EditBox:SetText(HUI_MenuSettings.Scale)
	end
end

function HUI_Menu_UpdateInterval_EditBox_OnValueChanged()
	local tInterval = HUI_Menu_UpdateInterval_EditBox:GetNumber();
	if (tInterval) and (tInterval>=0) and (tInterval<=10000) then
		HUI_MenuSettings.UpdateInterval = tInterval
	else
		HUI_Menu_UpdateInterval_EditBox:SetText(HUI_MenuSettings.UpdateInterval)
	end
end
function HUI_Menu_UpdateInterval_EditBox_ClearValue()
	HUI_Menu_UpdateInterval_EditBox:SetText(HUI_MenuSettings.UpdateInterval)
end



--================================== NUMBER OF BUTTONS FUNCTIONS ==============================================================================
function HUI_Menu_NumButtons_Slider_OnLoad()
	HUI_Menu_NumButtons_Slider:SetMinMaxValues(1,HUI_Max_Buttons);
	HUI_Menu_NumButtons_Slider:SetValueStep(1);
end
function HUI_Menu_NumButtons_Slider_OnValueChanged()
	HUI_MenuSettings.NumberButtons=HUI_Menu_NumButtons_Slider:GetValue();
	--HUI_Chat("Number Buttons="..HUI_MenuSettings.NumberButtons)
	HUI_Menu_NumButtons_EditBox:SetText(HUI_MenuSettings.NumberButtons)
	HUI_Show_Menu()
end
function HUI_Menu_NumButtons_EditBox_OnValueChanged()
	local tSize = tonumber(HUI_Menu_NumButtons_EditBox:GetText())
	
	if (tSize) and (tSize>=1) and (tSize<=HUI_Max_Buttons) then
		--HUI_Chat("Entered Number Buttons="..tSize)
		HUI_MenuSettings.NumberButtons= tSize
		HUI_Menu_NumButtons_Slider:SetValue(HUI_MenuSettings.NumberButtons)
		HUI_Show_Menu()
	else
		HUI_Menu_NumButtons_EditBox:SetText(HUI_MenuSettings.NumberButtons)
	end
end


--================================== Max Raid UFrame Slider FUNCTIONS ==============================================================================
function HUI_Menu_MaxRaidUFrames_Slider_OnLoad()
	HUI_Menu_MaxRaidUFrames_Slider:SetMinMaxValues(5,40);
	HUI_Menu_MaxRaidUFrames_Slider:SetValueStep(1);
end
function HUI_Menu_MaxRaidUFrames_Slider_OnValueChanged()
	HUI_MenuSettings.MaxRaidFrames=HUI_Menu_MaxRaidUFrames_Slider:GetValue();
	HUI_Menu_MaxRaidUFrames_EditBox:SetText(HUI_MenuSettings.MaxRaidFrames)
end

function HUI_Menu_MaxRaidUFrames_EditBox_OnValueChanged()
	local tMaxFrames = tonumber(HUI_Menu_MaxRaidUFrames_EditBox:GetText())
	if (tMaxFrames) and (tMaxFrames>=5) and (tMaxFrames<=40) then
		HUI_MenuSettings.MaxRaidFrames= tMaxFrames
		HUI_Menu_MaxRaidUFrames_EditBox:SetValue(HUI_MenuSettings.MaxRaidFrames)
	else
		HUI_Menu_MaxRaidUFrames_EditBox:SetText(HUI_MenuSettings.MaxRaidFrames)
	end
end


--================================== Max Rows Slider FUNCTIONS ==============================================================================
function HUI_Menu_MaxRows_Slider_OnLoad()
	HUI_Menu_MaxRows_Slider:SetMinMaxValues(5,25);
	HUI_Menu_MaxRows_Slider:SetValueStep(1);
end
function HUI_Menu_MaxRows_Slider_OnValueChanged()
	HUI_MenuSettings.MaxRows=HUI_Menu_MaxRows_Slider:GetValue();
	HUI_Menu_MaxRows_EditBox:SetText(HUI_MenuSettings.MaxRows)
end

function HUI_Menu_MaxRows_EditBox_OnValueChanged()
	local tMaxRows = tonumber(HUI_Menu_MaxRows_EditBox:GetText())
	if (tMaxRows) and (tMaxRows>=5) and (tMaxRows<=40) then
		HUI_MenuSettings.MaxRows = tMaxRows
		HUI_Menu_MaxRows_EditBox:SetValue(HUI_MenuSettings.MaxRows)
	else
		HUI_Menu_MaxRows_EditBox:SetText(HUI_MenuSettings.MaxRows)
	end
end



function HUI_Menu_CheckActive_Click(self)
	local tButton = HUI_Tools_Menu_Button_GetNumber(self:GetName());
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	local bfName = "HUI_Menu_Button";
	if (tButton<10) then bfName = bfName .. "0"; end
	bfName = bfName .. tButton;
	HUI_MenuSpell_Button[tButton].CheckIfActive = getglobal(bfName .. "_CheckActive_CheckButton"):GetChecked();
	HUI_Show_Menu();
end

function HUI_Menu_CheckDebuff_Click(self)
	local tButton = HUI_Tools_Menu_Button_GetNumber(self:GetName());
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	local bfName = "HUI_Menu_Button";
	if (tButton<10) then bfName = bfName .. "0"; end
	bfName = bfName .. tButton;
	HUI_MenuSpell_Button[tButton].CheckDebuff = getglobal(bfName .. "_CheckDebuff_CheckButton"):GetChecked();
	HUI_Show_Menu();
end

function HUI_Menu_hasProc_Click(self)
	local tButton = HUI_Tools_Menu_Button_GetNumber(self:GetName());
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	local bfName = "HUI_Menu_Button";
	if (tButton<10) then bfName = bfName .. "0"; end
	bfName = bfName .. tButton;
	HUI_MenuSpell_Button[tButton].hasProc = getglobal(bfName .. "_hasProc_CheckButton"):GetChecked();
	HUI_Show_Menu();
end

--================================== SHOW MENU ==============================================================================


function HUI_Show_Menu()
	HUI_Menu_Version:SetText("Version: "..HUI_Version)
		
	if not (HUI_Settings.MenuTab) or (HUI_Settings.MenuTab<1) or (HUI_Settings.MenuTab>5) then 
		-- Menu Tab Value Out of Range, set default
		HUI_Settings.MenuTab = 1
	end
		
	if not(HUI_Settings.MenuTab==1) then -- Menu not General, Hide all General settings
		HUI_Tab_Frame1_Texture:SetAlpha(0.6);
		HUI_Tab_Frame1_Text:SetTextColor(0.5, 0.5, 0.5)
		HUI_Menu_Version_Lab:Hide();
		HUI_Menu_UpdateInterval_Frame:Hide();
		HUI_Menu_CheckRange_CheckButton:Hide();
		HUI_Menu_Scale_Frame:Hide();
		HUI_Menu_ResetPosition_CheckButton:Hide();
		HUI_Menu_StoredRaidPositions_Frame:Hide();
	end
	if not(HUI_Settings.MenuTab==2) then -- Menu not Layout, Hide all Panel settings
		HUI_Tab_Frame2_Texture:SetAlpha(0.6);
		HUI_Tab_Frame2_Text:SetTextColor(0.5, 0.5, 0.5)
		HUI_Menu_MaxRaidUFrames_Frame:Hide();
		HUI_Menu_MaxRows_Frame:Hide();
		HUI_Menu_Profile_Frame:Hide()
	end
	if not(HUI_Settings.MenuTab==3) then -- Menu not Unit Menu, Hide all Menu settings
		HUI_Tab_Frame3_Texture:SetAlpha(0.6);
		HUI_Tab_Frame3_Text:SetTextColor(0.5, 0.5, 0.5)
		HUI_BM_Background:Hide();
		HUI_Menu_NumButtons_Frame:Hide();
		for b=1, HUI_Max_Buttons do
			if (b<10) then
				getglobal("HUI_Menu_Button0"..b):Hide();
			else
				getglobal("HUI_Menu_Button"..b):Hide();
			end
		end		
	end
	
	---------------- SHOW GENRAL TAB -------------------------------------------------
	if (HUI_Settings.MenuTab==1) then
		-- Menu is General, Show and set all General settings
		HUI_Menu_Version_Lab:SetText("HealUI Version: ".. HUI_Version);
		HUI_Menu_Version_Lab:Show();
		-- Load Menu Tab Enabled Texture
		HUI_Tab_Frame1_Texture:SetAlpha(1);
		HUI_Tab_Frame1_Text:SetTextColor(1, 1, 0)
		-- Set Update Interval Timer
		HUI_Menu_UpdateInterval_Frame:Show();
		HUI_Menu_UpdateInterval_EditBox:SetText(HUI_MenuSettings.UpdateInterval)
		HUI_Menu_CheckRange_CheckButton:Show();
		if ( HUI_MenuSettings.CheckRange ) then
			getglobal("HUI_Menu_CheckRange_CheckButton"):SetChecked( 1 );
		else
			getglobal("HUI_Menu_CheckRange_CheckButton"):SetChecked( nil );
		end
		-- Set slider psoitions on all sliders
		HUI_Menu_Scale_Frame:Show()
		HUI_Menu_Scale_Slider:SetValue(HUI_MenuSettings.Scale)
		HUI_Menu_Scale_EditBox:SetText(HUI_MenuSettings.Scale)
		HUI_Menu_ResetPosition_CheckButton:Show();
		
		HUI_Menu_StoredRaidPositions_Frame:Show();
		HUI_Menu_StoredRaidPositions_ShowNames();
	end
	------------------ SHOW LAYOUT TAB ----------------------------------------------------------
	if (HUI_Settings.MenuTab==2) then
		-- Menu is Panel, Show and set all Panel settings
		-- Load Menu Tab Enabled Texture
		HUI_Tab_Frame2_Texture:SetAlpha(1);
		HUI_Tab_Frame2_Text:SetTextColor(1, 1, 0)
		HUI_Menu_MaxRaidUFrames_Frame:Show();
		HUI_Menu_MaxRaidUFrames_Lab:Show();
		HUI_Menu_MaxRaidUFrames_Slider:Show();
		HUI_Menu_MaxRaidUFrames_EditBox:Show();
		HUI_Menu_MaxRaidUFrames_Slider:SetValue(HUI_MenuSettings.MaxRaidFrames)
		HUI_Menu_MaxRaidUFrames_EditBox:SetText(HUI_MenuSettings.MaxRaidFrames)
		HUI_Menu_MaxRows_Frame:Show();
		HUI_Menu_MaxRows_Slider:SetValue(HUI_MenuSettings.MaxRows)
		HUI_Menu_MaxRows_EditBox:SetText(HUI_MenuSettings.MaxRows)
		HUI_Menu_Profile_Frame:Show()
		HUI_Menu_ShowProfileNames();
	end
	---------------------- SHOW BUTTONS TAB ----------------------------------
	if (HUI_Settings.MenuTab==3) then
		-- Menu is Menu, Show and set all Menu settings
		-- Load Menu Tab Enabled Texture
		HUI_Tab_Frame3_Texture:SetAlpha(1);
		HUI_Tab_Frame3_Text:SetTextColor(1, 1, 0)
		-- Show Buttons Menu background and Tabs
		HUI_BM_Background:Show();
		-- Show and set number of buttons slider		
		HUI_Menu_NumButtons_Frame:Show();
		HUI_Menu_NumButtons_Slider:SetValue(HUI_MenuSettings.NumberButtons)
		HUI_Menu_NumButtons_EditBox:SetText(HUI_MenuSettings.NumberButtons)
		-- Show and set button options
		for b=1, HUI_Max_Buttons do
			HUI_Menu_ShowButton(b);
		end
	end
end


function HUI_Menu_ShowButton(b)
	-- Get button options frame name
	local bfName = "HUI_Menu_Button";
	if (b<10) then bfName = bfName .. "0"; end
	bfName = bfName .. b;
	if not (getglobal(bfName)) then return; end
	-- Hide disabled buttons
	if (b>HUI_MenuSettings.NumberButtons) then
		getglobal(bfName):Hide();
		return;
	end
	-- Show button
	getglobal(bfName):Show();
	
	-- If no spell then disable all options
	if not (HUI_MenuSpell_Button[b].SpellName) then -- Spell Name
		getglobal(bfName .. "_Action_ButtonIcon"):SetTexture( nil );
		getglobal(bfName .. "_Action_ButtonIcon"):Hide();
		getglobal(bfName .. "_Action_Button"):SetNormalTexture("Interface\\Buttons\\UI-Quickslot");
		-- Clear button spell options
		getglobal(bfName .. "_CheckActive_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_isMine_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_CheckDebuff_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_DebuffCurse_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_DebuffDisease_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_DebuffMagic_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_DebuffPoison_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_CheckActive_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_isMine_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_CheckDebuff_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_DebuffCurse_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_DebuffDisease_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_DebuffMagic_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_DebuffPoison_CheckButton"):SetAlpha(0.3);
		
		getglobal(bfName .. "_hasProc_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_hasProc_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_ProcName_EditBox"):SetAlpha(0.3);
		
		getglobal(bfName .. "_MacroSpell"):Hide();
		return;
	end
	-- Show and Set Button Action's spell texture
	local name, icon, body, isLocal = nil;
	if not (HUI_MenuSpell_Button[b].isMacro) then
		icon = GetSpellTexture(HUI_MenuSpell_Button[b].SpellName);
	else
		name, icon, body, isLocal = GetMacroInfo(HUI_MenuSpell_Button[b].SpellName);
	end
	if (icon) then
		getglobal(bfName .. "_Action_ButtonIcon"):SetTexture(icon);
	else
		HUI_Chat(L["Unable to find texture for "].. HUI_MenuSpell_Button[b].SpellName);
	end
	getglobal(bfName .. "_Action_ButtonIcon"):Show();
	getglobal(bfName .. "_Action_Button"):SetNormalTexture("Interface\\Buttons\\UI-Quickslot2");
					
	if (HUI_MenuSpell_Button[b].isMacro) then
		-- Show macro spell button
		getglobal(bfName .. "_MacroSpell"):Show();
		if (HUI_MenuSpell_Button[b].MacroSpell) then
			-- Set button icon
			local mIcon = GetSpellTexture(HUI_MenuSpell_Button[b].MacroSpell);
			if (mIcon) then
				getglobal(bfName .. "_MacroSpell_ButtonIcon"):SetTexture(mIcon);
			end
		else
			-- Clear button icon
			getglobal(bfName .. "_MacroSpell_ButtonIcon"):SetTexture( nil );
			getglobal(bfName .. "_MacroSpell_ButtonIcon"):Hide();
			getglobal(bfName .. "_MacroSpell_Button"):SetNormalTexture("Interface\\Buttons\\UI-Quickslot");
			-- Clear button spell options
			getglobal(bfName .. "_CheckActive_CheckButton"):SetChecked( nil );
			getglobal(bfName .. "_isMine_CheckButton"):SetChecked( nil );
			getglobal(bfName .. "_CheckDebuff_CheckButton"):SetChecked( nil );
			getglobal(bfName .. "_DebuffCurse_CheckButton"):SetChecked( nil );
			getglobal(bfName .. "_DebuffDisease_CheckButton"):SetChecked( nil );
			getglobal(bfName .. "_DebuffMagic_CheckButton"):SetChecked( nil );
			getglobal(bfName .. "_DebuffPoison_CheckButton"):SetChecked( nil );
			getglobal(bfName .. "_CheckActive_CheckButton"):SetAlpha(0.3);
			getglobal(bfName .. "_isMine_CheckButton"):SetAlpha(0.3);
			getglobal(bfName .. "_CheckDebuff_CheckButton"):SetAlpha(0.3);
			getglobal(bfName .. "_DebuffCurse_CheckButton"):SetAlpha(0.3);
			getglobal(bfName .. "_DebuffDisease_CheckButton"):SetAlpha(0.3);
			getglobal(bfName .. "_DebuffMagic_CheckButton"):SetAlpha(0.3);
			getglobal(bfName .. "_DebuffPoison_CheckButton"):SetAlpha(0.3);
			
			getglobal(bfName .. "_hasProc_CheckButton"):SetChecked( nil );
			getglobal(bfName .. "_hasProc_CheckButton"):SetAlpha(0.3);
			getglobal(bfName .. "_ProcName_EditBox"):SetAlpha(0.3);
			
			return;
		end
	else
		getglobal(bfName .. "_MacroSpell"):Hide(); -- Hide Macro Spell Button
	end
		
	getglobal(bfName .. "_CheckActive_CheckButton"):SetAlpha(1);
	getglobal(bfName .. "_CheckDebuff_CheckButton"):SetAlpha(1);
	getglobal(bfName .. "_hasProc_CheckButton"):SetAlpha(1);

	if (HUI_MenuSpell_Button[b].CheckIfActive) then
		getglobal(bfName .. "_CheckActive_CheckButton"):SetChecked( 1 ); -- check HUI_Menu_Button01_CheckActive_CheckButton
		getglobal(bfName .. "_isMine_CheckButton"):SetAlpha(1); -- undim HUI_Menu_Button01_isMine_CheckButton
	else
		getglobal(bfName .. "_CheckActive_CheckButton"):SetChecked( nil ); -- uncheck HUI_Menu_Button01_CheckActive_CheckButton
		getglobal(bfName .. "_isMine_CheckButton"):SetAlpha(0.3); -- dim HUI_Menu_Button01_isMine_CheckButton
	end
	if (HUI_MenuSpell_Button[b].IsMine) then
		getglobal(bfName .. "_isMine_CheckButton"):SetChecked( 1 ); -- Check HUI_Menu_Button01_isMine_CheckButton
	else
		getglobal(bfName .. "_isMine_CheckButton"):SetChecked( nil ); -- uncheck HUI_Menu_Button01_isMine_CheckButton
	end
		
	if (HUI_MenuSpell_Button[b].CheckDebuff) then
		getglobal(bfName .. "_CheckDebuff_CheckButton"):SetChecked( 1 );
		getglobal(bfName .. "_DebuffCurse_CheckButton"):SetAlpha(1);
		getglobal(bfName .. "_DebuffDisease_CheckButton"):SetAlpha(1);
		getglobal(bfName .. "_DebuffMagic_CheckButton"):SetAlpha(1);
		getglobal(bfName .. "_DebuffPoison_CheckButton"):SetAlpha(1);
	else
		getglobal(bfName .. "_CheckDebuff_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_DebuffCurse_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_DebuffDisease_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_DebuffMagic_CheckButton"):SetAlpha(0.3);
		getglobal(bfName .. "_DebuffPoison_CheckButton"):SetAlpha(0.3);
	end
	if (HUI_MenuSpell_Button[b].DebuffCurse) then 
		getglobal(bfName .. "_DebuffCurse_CheckButton"):SetChecked( 1 );
	else
		getglobal(bfName .. "_DebuffCurse_CheckButton"):SetChecked( nil );
	end
	if (HUI_MenuSpell_Button[b].DebuffDisease) then
		getglobal(bfName .. "_DebuffDisease_CheckButton"):SetChecked( 1 );
	else
		getglobal(bfName .. "_DebuffDisease_CheckButton"):SetChecked( nil );
	end
	if (HUI_MenuSpell_Button[b].DebuffMagic) then
		getglobal(bfName .. "_DebuffMagic_CheckButton"):SetChecked( 1 );
	else
		getglobal(bfName .. "_DebuffMagic_CheckButton"):SetChecked( nil );
	end
	if (HUI_MenuSpell_Button[b].DebuffPoison) then
		getglobal(bfName .. "_DebuffPoison_CheckButton"):SetChecked( 1 );
	else
		getglobal(bfName .. "_DebuffPoison_CheckButton"):SetChecked( nil );
	end
	
	if (HUI_MenuSpell_Button[b].hasProc) then
		getglobal(bfName .. "_hasProc_CheckButton"):SetChecked( 1 );
		getglobal(bfName .. "_ProcName_EditBox"):SetAlpha(1);
	else
		getglobal(bfName .. "_hasProc_CheckButton"):SetChecked( nil );
		getglobal(bfName .. "_ProcName_EditBox"):SetAlpha(0.3);
	end
	if (HUI_MenuSpell_Button[b].ProcName) then
		getglobal(bfName .. "_ProcName_EditBox"):SetText(HUI_MenuSpell_Button[b].ProcName);
	else
		getglobal(bfName .. "_ProcName_EditBox"):SetText("");
	end
	
end

--================================== STORE MENU ==============================================================================
function HUI_Store_Menu()
	if not (HUI_Settings.MenuTab) or (HUI_Settings.MenuTab<1) or (HUI_Settings.MenuTab>3) then return; end
	
	if (HUI_Settings.MenuTab==3) then 
		for b=1, HUI_Max_Buttons do
			local bfName = "HUI_Menu_Button";
			if (b<10) then bfName = bfName .. "0"; end
			bfName = bfName .. b;
			if (b<=HUI_MenuSettings.NumberButtons) and (HUI_MenuSpell_Button[b].SpellName) then 
				HUI_MenuSpell_Button[b].CheckIfActive = getglobal(bfName .. "_CheckActive_CheckButton"):GetChecked();
				HUI_MenuSpell_Button[b].IsMine = getglobal(bfName .. "_isMine_CheckButton"):GetChecked();
				HUI_MenuSpell_Button[b].CheckDebuff = getglobal(bfName .. "_CheckDebuff_CheckButton"):GetChecked();
				HUI_MenuSpell_Button[b].DebuffCurse = getglobal(bfName .. "_DebuffCurse_CheckButton"):GetChecked();
				HUI_MenuSpell_Button[b].DebuffDisease = getglobal(bfName .. "_DebuffDisease_CheckButton"):GetChecked();
				HUI_MenuSpell_Button[b].DebuffMagic = getglobal(bfName .. "_DebuffMagic_CheckButton"):GetChecked();
				HUI_MenuSpell_Button[b].DebuffPoison = getglobal(bfName .. "_DebuffPoison_CheckButton"):GetChecked();
				
				HUI_MenuSpell_Button[b].ProcName = getglobal(bfName .. "_ProcName_EditBox"):GetText();
			end
		end
	end
end

--================================== MENU SPELL BAR TYPE BUTTONS ==============================================================================
function HUI_Menu_Update_Page()
	HUI_Store_Menu()
	HUI_Show_Menu()
end

function HUI_Tab_Frame1_Click()
	if (HUI_Settings.MenuTab==1) then return; end
	HUI_Store_Menu()
	HUI_Settings.MenuTab = 1
	HUI_Show_Menu()
end
function HUI_Tab_Frame2_Click()
	if (HUI_Settings.MenuTab==2) then return; end
	HUI_Store_Menu()
	HUI_Settings.MenuTab = 2
	HUI_Show_Menu()
end
function HUI_Tab_Frame3_Click()
	if (HUI_Settings.MenuTab==3) then return; end
	HUI_Store_Menu()
	HUI_Settings.MenuTab = 3
	HUI_Show_Menu()
end


--================================== MENU OPEN AND CLOSE FUNCTION ==============================================================================
function HUI_Menu_Ok()
	-- Store current menu
	HUI_Store_Menu()
	-- Save changes to Player 
	HUI_Menu_SaveToPlayer()
	-- Hide Menu
	if ( HUI_Menu_Frame:IsVisible() ) then 
		PlaySound("igMainMenuClose");
		HUI_Menu_Frame:Hide();
	end
	-- Set pending change so next available chance, the buttons will update
	HUI_SpellChange = true;
	HUI_FrameOnEvent()
	
	if (HUI_Settings.UpdateInterval) then
		local tInterval = HUI_Settings.UpdateInterval/1000
		HUI_Set_Update_Timer(tInterval)
	end
end

function HUI_Menu_Cancel()
	-- Hide Menu and ignore changes
	if ( HUI_Menu_Frame:IsVisible() ) then 
		PlaySound("igMainMenuClose");
		HUI_Menu_Frame:Hide();
	end
end

function HUI_Menu_Load()
	DEFAULT_CHAT_FRAME:AddMessage("HealUI: Loadeding Menu");
	-- Load current player settings to a menu temp variable
	HUI_Menu_LoadFromPlayer()
	if ( not HUI_Menu_Frame:IsVisible() ) then 
		PlaySound("igMainMenuOpen");
		HUI_Menu_Frame:SetScale(0.8);
		HUI_Menu_Frame:Show();
	end
	HUI_Show_Menu()
end

--================================== MENU SAVE AND LOAD FUNCTIONS ==============================================================================
function HUI_Menu_SaveToPlayer()
	HUI_Settings.UpdateInterval = HUI_MenuSettings.UpdateInterval
	HUI_Settings.Scale = HUI_MenuSettings.Scale
	HUI_Settings.NumberButtons = HUI_MenuSettings.NumberButtons
	HUI_Settings.MaxRaidFrames = HUI_MenuSettings.MaxRaidFrames
	HUI_Settings.MaxRows = HUI_MenuSettings.MaxRows
	HUI_Settings.CheckRange = HUI_MenuSettings.CheckRange
		
	for b = 1, HUI_Max_Buttons do
		HUI_Spell_Button[b].SpellName = HUI_MenuSpell_Button[b].SpellName
		HUI_Spell_Button[b].isMacro = HUI_MenuSpell_Button[b].isMacro
		HUI_Spell_Button[b].MacroSpell = HUI_MenuSpell_Button[b].MacroSpell
		
		HUI_Spell_Button[b].CheckIfActive = HUI_MenuSpell_Button[b].CheckIfActive;
		HUI_Spell_Button[b].IsMine = HUI_MenuSpell_Button[b].IsMine;
		HUI_Spell_Button[b].CheckDebuff = HUI_MenuSpell_Button[b].CheckDebuff;
		HUI_Spell_Button[b].DebuffDisease = HUI_MenuSpell_Button[b].DebuffDisease;
		HUI_Spell_Button[b].DebuffMagic = HUI_MenuSpell_Button[b].DebuffMagic;
		HUI_Spell_Button[b].DebuffPoison = HUI_MenuSpell_Button[b].DebuffPoison;
		HUI_Spell_Button[b].DebuffCurse = HUI_MenuSpell_Button[b].DebuffCurse;
		HUI_Spell_Button[b].DebuffWeakenedSoul = HUI_MenuSpell_Button[b].DebuffWeakenedSoul;
		
		HUI_Spell_Button[b].hasProc = HUI_MenuSpell_Button[b].hasProc;
		HUI_Spell_Button[b].ProcName = HUI_MenuSpell_Button[b].ProcName;

		HUI_Spell_Button[b].CastOnDead = HUI_MenuSpell_Button[b].CastOnDead;
		HUI_Spell_Button[b].IfAggro = HUI_MenuSpell_Button[b].IfAggro;
	end
end

function HUI_Menu_LoadFromPlayer()
	HUI_MenuSettings.UpdateInterval = HUI_Settings.UpdateInterval
	HUI_MenuSettings.Scale = HUI_Settings.Scale
	HUI_MenuSettings.NumberButtons = HUI_Settings.NumberButtons
	HUI_MenuSettings.MaxRaidFrames = HUI_Settings.MaxRaidFrames
	HUI_MenuSettings.MaxRows = HUI_Settings.MaxRows
	HUI_MenuSettings.CheckRange = HUI_Settings.CheckRange
		
	for b = 1, HUI_Max_Buttons do
		HUI_MenuSpell_Button[b].SpellName = HUI_Spell_Button[b].SpellName
		HUI_MenuSpell_Button[b].isMacro = HUI_Spell_Button[b].isMacro
		HUI_MenuSpell_Button[b].MacroSpell = HUI_Spell_Button[b].MacroSpell
		
		HUI_MenuSpell_Button[b].CheckIfActive = HUI_Spell_Button[b].CheckIfActive;
		HUI_MenuSpell_Button[b].IsMine = HUI_Spell_Button[b].IsMine;
		HUI_MenuSpell_Button[b].CheckDebuff = HUI_Spell_Button[b].CheckDebuff;
		HUI_MenuSpell_Button[b].DebuffDisease = HUI_Spell_Button[b].DebuffDisease;
		HUI_MenuSpell_Button[b].DebuffMagic = HUI_Spell_Button[b].DebuffMagic;
		HUI_MenuSpell_Button[b].DebuffPoison = HUI_Spell_Button[b].DebuffPoison;
		HUI_MenuSpell_Button[b].DebuffCurse = HUI_Spell_Button[b].DebuffCurse;
		HUI_MenuSpell_Button[b].DebuffWeakenedSoul = HUI_Spell_Button[b].DebuffWeakenedSoul;
		
		HUI_MenuSpell_Button[b].hasProc = HUI_Spell_Button[b].hasProc;
		HUI_MenuSpell_Button[b].ProcName = HUI_Spell_Button[b].ProcName;

		HUI_MenuSpell_Button[b].CastOnDead = HUI_Spell_Button[b].CastOnDead;
		HUI_MenuSpell_Button[b].IfAggro = HUI_Spell_Button[b].IfAggro;
	end	
end

function HUI_Menu_SetPosition_Click()
	HUI_Reset_All_HeaderPositions();
end


--[[ ===========================================================================================================================
					Profile Functions
=================================================================================================================================]]

function HUI_Menu_Profile_Save_Button1_Click()
	HUI_Store_Menu()
	HUI_Menu_SaveToPlayer()
	HUI_SpellChange = true;
	HUI_Profile_Save(1)
end
function HUI_Menu_Profile_Load_Button1_Click()
	HUI_Profile_Load(1)
	--HUI_Config_Panels();
	--HUI_Update_Buttons()
	HUI_Fav_Config_Panel()
	HUI_Fav_Update_Buttons()
	HUI_Menu_LoadFromPlayer()
	HUI_Show_Menu()
end
function HUI_Menu_Profile_Save_Button2_Click()
	HUI_Store_Menu()
	HUI_Menu_SaveToPlayer()
	HUI_SpellChange = true;
	HUI_Profile_Save(2)
end
function HUI_Menu_Profile_Load_Button2_Click()
	HUI_Profile_Load(2)
	--HUI_Config_Panels();
	--HUI_Update_Buttons()
	HUI_Fav_Config_Panel()
	HUI_Fav_Update_Buttons()
	HUI_Menu_LoadFromPlayer()
	HUI_Menu_LoadFromPlayer()
	HUI_Show_Menu()
end
function HUI_Menu_Profile_Save_Button3_Click()
	HUI_Store_Menu()
	HUI_Menu_SaveToPlayer()
	HUI_SpellChange = true;
	HUI_Profile_Save(3)
end
function HUI_Menu_Profile_Load_Button3_Click()
	HUI_Profile_Load(3)
	--HUI_Config_Panels();
	--HUI_Update_Buttons()
	HUI_Fav_Config_Panel()
	HUI_Fav_Update_Buttons()
	HUI_Menu_LoadFromPlayer()
	HUI_Menu_LoadFromPlayer()
	HUI_Show_Menu()
end


--[[ ===========================================================================================================================
					Stored Raid Positiona Functions
=================================================================================================================================]]

function HUI_Menu_StoredRaidPositions_Save_Button1_Click()
	HUI_StoredRaidPositions_Save(1)
end
function HUI_Menu_StoredRaidPositions_Load_Button1_Click()
	HUI_StoredRaidPositions_Load(1)
	-- Show changes
end

function HUI_Menu_StoredRaidPositions_Save_Button2_Click()
	HUI_StoredRaidPositions_Save(2)
end
function HUI_Menu_StoredRaidPositions_Load_Button2_Click()
	HUI_StoredRaidPositions_Load(2)
	-- Show changes
end

function HUI_Menu_StoredRaidPositions_Save_Button3_Click()
	HUI_StoredRaidPositions_Save(3)
end
function HUI_Menu_StoredRaidPositions_Load_Button3_Click()
	HUI_StoredRaidPositions_Load(3)
	-- Show changes
end
