local addonName, L = ...; 
local function defaultFunc(L, key) 
return key; 
end 
setmetatable(L, {__index=defaultFunc});

function HUI_Init_Menu_Values()
	-- Initialize Menu Variables. These are same as game variables. They are used to store values while editing menu. Then can be copied to game settings on OK or ignored on Cancel.
	HUI_MenuSettings.Enable = 1
	HUI_MenuSettings.UpdateInterval = 400
	HUI_MenuSettings.Scale = 0.60
	HUI_MenuSettings.TooltipEnable = nil
	HUI_MenuSettings.SimpleTooltip = 1
	HUI_MenuSettings.NumberButtons = 4
	HUI_MenuSettings.Raid = nil
	HUI_MenuSettings.MaxRaidFrames = 25
	HUI_MenuSettings.MaxRows = 15
	HUI_MenuSettings.CheckRange = 1
	
	HUI_MenuSpell_Button={}
	for b = 1, HUI_Max_Buttons do -- Buttons. Can have up to HUI_Max_Buttons buttons per bar.
		HUI_MenuSpell_Button[b] = {}
		HUI_MenuSpell_Button[b].SpellName = nil
		HUI_MenuSpell_Button[b].isMacro = nil
		HUI_MenuSpell_Button[b].MacroSpell = nil
		
		HUI_MenuSpell_Button[b].CheckIfActive = nil;
		HUI_MenuSpell_Button[b].IsMine = nil;
		HUI_MenuSpell_Button[b].CheckDebuff = nil;
		HUI_MenuSpell_Button[b].DebuffDisease = nil;
		HUI_MenuSpell_Button[b].DebuffMagic = nil;
		HUI_MenuSpell_Button[b].DebuffPoison = nil;
		HUI_MenuSpell_Button[b].DebuffCurse = nil;
		HUI_MenuSpell_Button[b].DebuffWeakenedSoul = nil;
		
		HUI_MenuSpell_Button[b].hasProc = nil;
		HUI_MenuSpell_Button[b].ProcName = nil;
		
		HUI_MenuSpell_Button[b].CastOnDead = nil;
		HUI_MenuSpell_Button[b].IfAggro = nil;
		
		
	end
	
		
	HUI_CursorSpellOptions.SpellName = nil
	HUI_CursorSpellOptions.isMacro = nil
	HUI_CursorSpellOptions.MacroSpell = nil
	HUI_CursorSpellOptions.CheckIfActive = nil;
	HUI_CursorSpellOptions.IsMine = nil;
	HUI_CursorSpellOptions.CheckDebuff = nil;
	HUI_CursorSpellOptions.DebuffDisease = nil;
	HUI_CursorSpellOptions.DebuffMagic = nil;
	HUI_CursorSpellOptions.DebuffPoison = nil;
	HUI_CursorSpellOptions.DebuffCurse = nil;
	HUI_CursorSpellOptions.DebuffWeakenedSoul = nil;
	HUI_CursorSpellOptions.CastOnDead = nil;
	HUI_CursorSpellOptions.IfAggro = nil;
	HUI_CursorSpellOptions.hasProc = nil;
	HUI_CursorSpellOptions.ProcName = nil;
	
end


function HUI_Init_Unit_Values()
-- Create and Init panel settings
	for s=0, HUI_Max_Units do
		HUI_Unit[s] = {}
		HUI_Unit[s].Enable = nil -- Whether the unit should be shown, if present
		HUI_Unit[s].Unit = "none" -- The unit the spells will target
		HUI_Unit[s].Name = "" 
	end
	-- The unit each panel will target it's spell on
	HUI_Unit[0].Unit = "Player"
	HUI_Unit[1].Unit = "Party1"
	HUI_Unit[2].Unit = "Party2"
	HUI_Unit[3].Unit = "Party3"
	HUI_Unit[4].Unit = "Party4"
	HUI_Unit[5].Unit = "pet"  --'pet', 'partypet1', 'partypet2', 'partypet3', 'partypet4'
	HUI_Unit[6].Unit = "partypet1"
	HUI_Unit[7].Unit = "partypet2"
	HUI_Unit[8].Unit = "partypet3"
	HUI_Unit[9].Unit = "partypet4"
	
end


-- This function intializes all non-saved data.
function HUI_Init_Nonsaved()
	HUI_PANEL.Header = nil -- Stores the header frame created
	HUI_PANEL.AttachToUnit = "UIParent" -- The frame the bar will be attached to (such as playerframe)
	
	HUI_Init_Unit_Values();
	HUI_Init_Fav_Values();
	HUI_Init_Menu_Values();
		
	-- Check if the last saved setting's config version is out of date.
	if (HUI_Settings.ConfigVersion) then 
		HUI_Chat("Config Version="..HUI_Settings.ConfigVersion)
		-- Saved config version is old, try to update without losing data.
		if (HUI_Settings.ConfigVersion~=HUI_ConfigVersion) then
			if (HUI_Settings.ConfigVersion=="3.01.00") then
				HUI_Chat(L["Saved configuration is outdated. Updating configuration, no saved values will be lost."]);
				HUI_Update_Settings301()
			elseif (HUI_Settings.ConfigVersion=="3.02.00") then
				HUI_Chat(L["Saved configuration is outdated. Updating configuration, no saved values will be lost."]);
				HUI_Update_Settings302() 
			else
				-- Unable to update settings, have to re-initialize settings and lose saved data.
				HUI_Chat(L["Saved configuration version Outdated. Initializing saved values."]);
				HUI_Init_Settings()
			end
		end
	else
		-- No saved config version. Have to re-initialize settings and lose saved data.
		HUI_Chat(L["Saved configure version corrupted. Initializing saved values."]);
		HUI_Init_Settings()
	end
	-- Create Update Timer frame to prepare the Update Timer.
	HUI_Create_Update_Timer_Frame();
		
	local tClass = (select(2,UnitClass("player")))
	if (tClass) then
		if (tClass == "PALADIN") then
			HUI_Paladin_SetDefaultSpellOptions()
		elseif (tClass == "PRIEST") then
			HUI_Priest_SetDefaultSpellsOptions()
		elseif (tClass == "DRUID") then
			HUI_Druid_SetDefaultSpellOptions()
		elseif (tClass == "SHAMAN") then
			HUI_Shaman_SetDefaultSpellOptions()
		elseif (tClass == "MONK") then
			HUI_Monk_SetDefaultSpellOptions()
		else
			
		end
	end
		
	--HUI_Settings.SettingsLoaded = 1
	--HUI_Settings.SettingsLoaded = 0

	--HUI_StoredRaidPositions_Init()
	--HUI_Init_Settings()
	--HUI_Profiles_Init()
end

-- This function initializes all saved vairiables. All spells and settings are wiped.
function HUI_Init_Settings()
	HUI_Settings.LoadedBefore = 1
	HUI_Settings.Version = HUI_Version
	HUI_Settings.ConfigVersion = HUI_ConfigVersion
	HUI_Settings.UpdateInterval = 200
	HUI_Settings.Scale = 0.60
	
	HUI_Settings.TooltipEnable = nil
	HUI_Settings.SimpleTooltip = 1
	HUI_Settings.NumberButtons = 4
	HUI_Settings.Raid = 1
	HUI_Settings.MaxRaidFrames = 25
	HUI_Settings.MaxRows = 15
	HUI_Settings.CheckRange = 1
		
	HUI_Settings.HideFavPanel = nil
		
	HUI_Settings.MenuUnit = 1
	HUI_Settings.MenuTab = 1
			
	HUI_Settings.Debug = nil

	HUI_Spell_Button={}
	--HUI_Spell_Button.NumButtons = 0
	for b = 1, HUI_Max_Buttons do -- Buttons. Can have up to HUI_Max_Buttons buttons per bar.
		HUI_Spell_Button[b]={}
		HUI_Spell_Button[b].SpellName = nil
		HUI_Spell_Button[b].isMacro = nil
		HUI_Spell_Button[b].MacroSpell = nil
		
		HUI_Spell_Button[b].CheckIfActive = nil;
		HUI_Spell_Button[b].IsMine = nil;
		HUI_Spell_Button[b].CheckDebuff = nil;
		HUI_Spell_Button[b].DebuffDisease = nil;
		HUI_Spell_Button[b].DebuffMagic = nil;
		HUI_Spell_Button[b].DebuffPoison = nil;
		HUI_Spell_Button[b].DebuffCurse = nil;
		HUI_Spell_Button[b].DebuffWeakenedSoul = nil;
		
		HUI_Spell_Button[b].hasProc = nil;
		HUI_Spell_Button[b].ProcName = nil;

		HUI_Spell_Button[b].CastOnDead = nil;
		HUI_Spell_Button[b].IfAggro = nil;
	end
	
	local tClass = (select(2,UnitClass("player")))
	if (tClass) then
		if (tClass == "PALADIN") then HUI_Paladin_SetDefaultSpellOptions();
		elseif (tClass == "PRIEST") then HUI_Priest_SetDefaultSpellsOptions();
		elseif (tClass == "DRUID") then	HUI_Druid_SetDefaultSpellOptions();
		elseif (tClass == "SHAMAN") then HUI_Shaman_SetDefaultSpellOptions();
		elseif (tClass == "MONK") then HUI_Monk_SetDefaultSpellOptions(); end
	end
		
	HUI_Profiles_Init();
	HUI_StoredRaidPositions_Init();
end

-- Update Settings Functions will update older version of HealUI without loosing any saved data. 
-- Each function updates to the next version, and the verision update functions are chained to update mods that are more than one version behind.
--updates config to version 0.02
function HUI_Update_Settings301() 
	HUI_Settings.Version = HUI_Version
	HUI_Settings.ConfigVersion = HUI_ConfigVersion
	-- insert setting updates to go from config version 1 to 2.
	
	--HUI_Spell_Button[b].SpellName
	if not (HUI_Spell_Button[b]) then
		HUI_Spell_Button[b] = {{{}}};
	end
	
	-- Initialize new spell options
	for b = 1, HUI_Max_Buttons do -- Buttons. Can have up to HUI_Max_Buttons buttons per bar.
		HUI_Spell_Button[b].CheckIfActive = nil;
		HUI_Spell_Button[b].IsMine = nil;
		HUI_Spell_Button[b].CheckDebuff = nil;
		HUI_Spell_Button[b].DebuffDisease = nil;
		HUI_Spell_Button[b].DebuffMagic = nil;
		HUI_Spell_Button[b].DebuffPoison = nil;
		HUI_Spell_Button[b].DebuffCurse = nil;
		HUI_Spell_Button[b].DebuffWeakenedSoul = nil;
		HUI_Spell_Button[b].hasProc = nil;
		HUI_Spell_Button[b].ProcName = nil;
		HUI_Spell_Button[b].CastOnDead = nil;
		HUI_Spell_Button[b].IfAggro = nil;
	end
	-- Copy old spell options to new
	for b = 1, HUI_Max_Buttons do
		if (HUI_Spell_Button[b].Name) then
			local sName = HUI_Spell_Button[b].SpellName;
			if (HUI_SpellOptions) and  (HUI_SpellOptions[sName]) then
				HUI_Spell_Button[b].CheckIfActive = HUI_SpellOptions[sName].CheckIfActive;
				HUI_Spell_Button[b].IsMine = HUI_SpellOptions[sName].IsMine;
				HUI_Spell_Button[b].CheckDebuff = HUI_SpellOptions[sName].CheckDebuff;
				HUI_Spell_Button[b].DebuffDisease = HUI_SpellOptions[sName].DebuffDisease;
				HUI_Spell_Button[b].DebuffMagic = HUI_SpellOptions[sName].DebuffMagic;
				HUI_Spell_Button[b].DebuffPoison = HUI_SpellOptions[sName].DebuffPoison;
				HUI_Spell_Button[b].DebuffCurse = HUI_SpellOptions[sName].DebuffCurse;
				HUI_Spell_Button[b].DebuffWeakenedSoul = HUI_SpellOptions[sName].DebuffWeakenedSoul;
				HUI_Spell_Button[b].CastOnDead = HUI_SpellOptions[sName].CastOnDead;
				HUI_Spell_Button[b].IfAggro = HUI_SpellOptions[sName].IfAggro;
			end
		end
	end
		
	HUI_Update_Settings302()
end

function HUI_Update_Settings302() 
	HUI_Settings.Version = HUI_Version
	HUI_Settings.ConfigVersion = HUI_ConfigVersion
	HUI_StoredRaidPositions_Init()
end


