local addonName, L = ...; 
local function defaultFunc(L, key) 
return key; 
end 
setmetatable(L, {__index=defaultFunc});

function HUI_Fav_Min_Click()
	HUI_Fav_Hide_Panel()
	HUI_Settings.HideFavPanel = 1
end

function HUI_Fav_Max_Click()
	HUI_Fav_Show_Panel()
	HUI_Settings.HideFavPanel = nil
end

function HUI_Fav_Hide_Header()
	HUI_Fav_Header_Frame:Hide()
end

function HUI_Fav_Show_Header()
	HUI_Fav_Header_Frame:Show()
end

--[[ ===========================================================================================================================

					HealUI FAVORITE FRAME AND BUTTON REFRESH FUNCTIONS
					
					
=================================================================================================================================]]

--[[ ===========================================================================================================================
					UFRAME CLICK FUNCTIONS 
=================================================================================================================================]]

function HUI_Fav_Get_UFrame_ID(fName)
	if not (fName) then return; end
	--"HUI_UFav_Header"
	local fNum = string.sub(fName, 16,17)
	if (fNum) then
		if (string.sub(fNum, 2,2)=="_") then
			fNum = string.sub(fNum, 1,1)
		end
		return tonumber(fNum)
	else
		return
	end
end

function HUI_Fav_Overlay_Click(self)
	if not (IsShiftKeyDown()) then return; end
	local FrameID = HUI_Fav_Get_UFrame_ID(self:GetName())
	if not (FrameID) then
		HUI_Chat(L["Error! Can't find Frame ID"])
		return
	end
	
	if (not InCombatLockdown()) then
		local tName = HUI_Fav_List[FrameID] 
		if (tName) then
			HUI_Chat(L["Removing "]..tName..L[" from Favorites"])
			HUI_Fav_List_Remove(tName)
		end
	else
		HUI_Chat(L["Can't Modify Favorites in Combat"])
	end
end



function HUI_Fav_Up_Click(self)
	if (InCombatLockdown()) then
		HUI_Chat(L["Can't Modify Favorites in Combat"])
		return;
	end
	
	local FrameID = HUI_Fav_Get_UFrame_ID(self:GetName())
	if not (FrameID) then
		HUI_Chat(L["Error! Can't find Frame ID"])
		return
	end
	if (FrameID<=1) then return; end
	
	if not (IsShiftKeyDown()) then
		HUI_Fav_Swap(FrameID, FrameID-1)
	else
		HUI_Fav_MoveToTop(FrameID)
	end
end

function HUI_Fav_Down_Click(self)
	
	if (InCombatLockdown()) then
		HUI_Chat(L["Can't Modify Favorites in Combat"])
		return;
	end
	local FrameID = HUI_Fav_Get_UFrame_ID(self:GetName())
	if not (FrameID) then
		HUI_Chat(L["Error! Can't find Frame ID"])
		return
	end
	if (FrameID>=HUI_Num_Favs) then return; end
	if not (IsShiftKeyDown()) then
		HUI_Fav_Swap(FrameID, FrameID+1)
	else
		HUI_Fav_MoveToBottom(FrameID)
	end
end



--[[ ===========================================================================================================================
					UFRAME UPDATE FUNCTIONS 
=================================================================================================================================]]


function HUI_Refresh_Favs()
	if (HUI_Num_Favs<1) then return; end
	
	for f = 1, HUI_Num_Favs do
		if (HUI_Fav[f].Show) then
			HUI_Fav_Update_Health_Bar_Lite(f)
			if (HUI_FlipFlop) then
				-- If CheckRange and out of range Set UnDim Alpha to 0.5 if OOM
				if (HUI_Settings.CheckRange) then
					-- Check if unit is in range of spell
					local tInRange, tCheckedRange = UnitInRange(HUI_Fav_List[f])
					if (HUI_Fav[f].Header) then
						if  (tInRange) then
							HUI_Fav[f].Header:SetAlpha(1)
						elseif (UnitIsUnit(HUI_Fav_List[f], "player")) then
							HUI_Fav[f].Header:SetAlpha(1)
						else
							HUI_Fav[f].Header:SetAlpha(0.3)
						end
					end
				end
				if (RIU3_Debuff_isNeeded) then HUI_Fav_Set_Debuffs(f); end
			end
		end
	end 
	if (HUI_FlipFlop) then
		HUI_Fav_Update_Buttons()
	end
end



--[[ ===========================================================================================================================
								HEALTH BAR AND MANA BAR FUNTIONS
=================================================================================================================================]]

--====================================== UPDATE HEALTH BARS ======================================================================
function HUI_Fav_Update_Health_Bar_Lite(tUFrame)
	local tHealth = nil
	if not (tUFrame) then return; end
	if not (HUI_Fav[tUFrame].Header) then return; end
	
	local HUI_tBarText = getglobal(HUI_Fav[tUFrame].Header:GetName().."_HealthBar_Text2")
	local HUI_tBar = getglobal(HUI_Fav[tUFrame].Header:GetName().."_HealthBar")
	if not (HUI_tBarText) or not (HUI_tBar) then return; end
	
	tUnit = HUI_Fav_List[tUFrame]
	if (tUnit) and ( UnitExists(tUnit) ) then
		tHealth = UnitHealth(tUnit)
		local tHealthPercent = nil
		
		if not (tHealth) then
			HUI_Chat("Error: No health for "..tUnit);
			HUI_tBar:SetValue(0);
			HUI_tBarText:SetText("");
			return;
		end
		
		if not (HUI_Fav[tUFrame].LastHealth) or (tHealth ~= HUI_Fav[tUFrame].LastHealth) then
			HUI_Fav[tUFrame].LastHealth = tHealth
			HUI_tBar:Show()
			if ( UnitIsCorpse(tUnit) or UnitIsDeadOrGhost(tUnit) ) then -- Target is dead, set bar to zero
				HUI_tBarText:SetText(L["Dead"]);
				HUI_tBar:SetValue(0);
				HUI_Fav_UFav_ClearStatus(tUFrame)
				HUI_Fav[tUFrame].LastHealth = tHealth
				HUI_Fav[tUFrame].IsDead = 1
			else -- Target is alive
				HUI_Fav[tUFrame].IsDead = nil
				HUI_tBarText:SetText("");
				local tMaxHealth = UnitHealthMax(tUnit)
				-- Calculate target's health percentage
				if (tMaxHealth == 100) then	-- Target's health already in percentages
					tHealthPercent = tHealth
				elseif (tMaxHealth > 0) then -- Target's health not in percentages
					local thingy = tHealth / tMaxHealth;
					thingy = thingy * 100;
					tHealthPercent = thingy;
				end
	
				if (tHealthPercent) then
					HUI_tBar:SetValue(tHealthPercent);
				end
				if (tHealthPercent) and (tHealthPercent>90) then
					HUI_tBar:SetStatusBarColor("0","1","0") -- Target is friendly set bar to green
				elseif (tHealthPercent) and (tHealthPercent>20) then
					HUI_tBar:SetStatusBarColor("1","1","0")
				else	
					HUI_tBar:SetStatusBarColor("1","0","0")
				end
			end -- else is alive
		end -- if health changed
	else -- else no unit
		HUI_tBar:SetValue(0);
		HUI_tBarText:SetText("");
	end
end




function HUI_Fav_SetFrame(tFavID)
	if not (tFavID) then return; end
	if not (HUI_Fav[tFavID].Header) then return; end
	-- Set HealthBar Values
	HUI_Fav[tFavID].LastHealth = 0 -- Last checked Health value, used to decide whether to update healthbar.	
	local tHB_Name_Text = getglobal(HUI_Fav[tFavID].Header:GetName() .. "_HealthBar_Text1");
	if (tHB_Name_Text) then 
		local tName = HUI_Fav_List[tFavID]
		if (tName) then
			tHB_Name_Text:SetText(tName)
			tHB_Name_Text:Show();
		else -- Don't show name test. Set it to blank and hide it.
			tHB_Name_Text:SetText("")
		end
	end
	HUI_Fav_Update_Health_Bar_Lite(tFavID)
	--SetAlpha
	
	if (HUI_Settings.CheckRange) then
		-- Check if unit is in range of spell
		local tInRange, tCheckedRange = UnitInRange(HUI_Fav_List[tFavID])
		if (HUI_Fav[tFavID].Header) then
			if  (tInRange) then
				HUI_Fav[tFavID].Header:SetAlpha(1)
			elseif (UnitIsUnit(HUI_Fav_List[tFavID], "player") or UnitIsUnit(HUI_Fav_List[tFavID], "pet")) then
				HUI_Fav[f].Header:SetAlpha(1)
			else
				HUI_Fav[tFavID].Header:SetAlpha(0.3)
			end
		end
	end
end


function HUI_Fav_SetFavoritesFrame()
	HUI_Unit_Frame_Height = 36 + 4 -- Calculate Unit Frame Height
	local tParent = getglobal("HUI_Favorites_Frame");
	tParent:SetHeight(HUI_Unit_Frame_Height * (HUI_Num_Favs) + 10)
	
	for f = 1, HUI_Max_Favs do
		if (f<=HUI_Num_Favs) then
			HUI_Fav[f].Show = 1 -- Whether the UFrame should be shown
			if (HUI_Fav[f].Header) then HUI_Fav[f].Header:Show(); end
		else
			HUI_Fav[f].Show = nil
			if (HUI_Fav[f].Header) then HUI_Fav[f].Header:Hide(); end
		end
	end
end


function HUI_Fav_UFav_ClearStatus(tUFrame)
	if not (tUFrame) then return; end
		
	HUI_Fav_ClearUFavButtons(tUFrame)
	
	HUI_Fav[tUFrame].HasCurse = nil
	HUI_Fav[tUFrame].HasDisease = nil
	HUI_Fav[tUFrame].HasPoison = nil
	HUI_Fav[tUFrame].HasMagic = nil
	HUI_Fav[tUFrame].HasWS = nil
	HUI_Fav[tUFrame].LastHealth = 0
end


--[[ ===========================================================================================================================
					Button and Header Functions
=================================================================================================================================]]
local HUI_Unit_Frame_Width = 100
local HUI_Unit_Frame_Height = 36

function HUI_Fav_Hide_Panel()
	if (HUI_Favorites_Frame) then -- Check if the header exist, if it exists then hide it.
		HUI_Favorites_Frame:SetAlpha(0);
	end
end

function HUI_Fav_Show_Panel()
	if (HUI_Favorites_Frame) then -- Check if the header exist, if it exists then hide it.
		HUI_Favorites_Frame:SetAlpha(1);
		HUI_Favorites_Frame:Show();
	end
end

--[[ ===========================================================================================================================

					CREATE FRAME AND BUTTON FUNCTIONS
					
					
=================================================================================================================================]]

--[[ ===========================================================================================================================
					Create Main Panel Functions
=================================================================================================================================]]


--=================================== CONFIGURE BUTTONS =========================================================================
function HUI_Fav_Config_Panel()
	-------- Set Panel Settings -----------------------
	HUI_Fav_Header_Frame:Show();
	HUI_Fav_Header_Frame:SetToplevel(1)
	local tPBackdrop = getglobal(HUI_Favorites_Frame:GetName() .. "Backdrop");
	if (tPBackdrop) then
		tPBackdrop:SetAlpha(0.75);
	end
		
	local tPadding = 186 -- Space for health bar
	HUI_Unit_Frame_Width = ((36 + 5)*HUI_Settings.NumberButtons)+tPadding + 4  -- Calculate Width of UFrames
	HUI_Unit_Frame_Height = 36 + 4 -- Calculate Unit Frame Height
	local tParent = getglobal("HUI_Favorites_Frame");
	tParent:SetScale(1);
	tParent:SetWidth(HUI_Unit_Frame_Width)
	tParent:SetScale(HUI_Settings.Scale);
	
	HUI_Fav_List_Update()
	
	for f = 1, HUI_Max_Favs do
		HUI_Fav_Config_UFrame(f)
		HUI_Fav[f].LastHealth = 0 -- Last checked Health value, used to decide whether to update healthbar.	
		if (f<=HUI_Num_Favs) then
			HUI_Fav[f].Show = 1 -- Whether the UFrame should be shown
			if (HUI_Fav[f].Header) then HUI_Fav[f].Header:Show(); end
		else
			HUI_Fav[f].Show = nil
			if (HUI_Fav[f].Header) then HUI_Fav[f].Header:Hide(); end
		end
	end
		
	if (HUI_Num_Favs<HUI_Settings.MaxRows) then
		tParent:SetHeight(HUI_Unit_Frame_Height * (HUI_Num_Favs) + 10)
		--tParent:SetHeight(HUI_Unit_Frame_Height * (HUI_Num_Favs+1) + 10)
	else
		tParent:SetHeight(HUI_Unit_Frame_Height * HUI_Settings.MaxRows + 30)
	end	
	local tColumns = (floor((HUI_Num_Favs-1)/HUI_Settings.MaxRows)) + 1
	tParent:SetWidth(HUI_Unit_Frame_Width * tColumns + 10)
	--tParent:SetWidth(HUI_Unit_Frame_Width + 10)
		
	if (HUI_Settings.HideFavPanel) then
		HUI_Fav_Hide_Panel()
	else
		HUI_Fav_Show_Panel()
	end
end

--[[ ===========================================================================================================================
					Create UFrame Functions
=================================================================================================================================]]

--------------------------------CONFIG UNIT FRAME--------------------------------------------------------
function HUI_Fav_Config_UFrame(tUFrame)
	if not (tUFrame) then return; end
	
	local tParent = getglobal("HUI_Favorites_Frame");
	if not (tParent) then 
		HUI_Chat("Parent not found");
		return;
	end
	local tButton_Size = 36
	local tButton_Spacing = 5
	------ CONFIGURE HEADER --------------
	local hdr = HUI_Fav[tUFrame].Header; -- Fetch header handle
	if (not hdr) then -- Check if the header exist, if not create the header
		-- Create frame based on secure header template declared in HealUI.xml
		hdr = CreateFrame("Frame", "HUI_UFav_Header"..tUFrame, tParent, "HUI_Fav_Unit_Template"); 
		hndlr = CreateFrame("Frame", hdr:GetName().."_SucHdr", hdr, "SecureHandlerStateTemplate")
		HUI_Fav[tUFrame].Header = hdr;
		HUI_Fav[tUFrame].Handler = hndlr;
	end
	
	local tVoffset = 0
	local tLabel = getglobal(hdr:GetName() .. "_Label");
	if (tLabel) then
		tLabel:Hide();
	end
	--hdr:SetScale(HUI_Settings.Scale);
	hdr:SetFrameLevel(tParent:GetFrameLevel() + 3);
	hdr:IsToplevel();
	hdr:Raise();
	hdr:SetFrameStrata("DIALOG");

		
	--local tRow = tUFrame-1 -- - (tColumn * HUI_Settings.MaxRows)
	--hdr:SetPoint("TOPLEFT", tParent, "TOPLEFT", 0, (-1*tRow*HUI_Unit_Frame_Height)-5);
		
	local tColumn = floor((tUFrame-1)/HUI_Settings.MaxRows)
	local tRow = tUFrame - (tColumn * HUI_Settings.MaxRows) - 1
	hdr:SetPoint("TOPLEFT", tParent, "TOPLEFT", (tColumn * HUI_Unit_Frame_Width), (-1*tRow*HUI_Unit_Frame_Height)-5);
		
	-- Set frame's height and width to fit number of buttons and name label
	hdr:SetWidth(HUI_Unit_Frame_Width);
	hdr:SetHeight(HUI_Unit_Frame_Height);
	
	local cOverlay = getglobal(hdr:GetName() .. "_HealthBar_ClickOverlay");
	--local fString = getglobal(hdr:GetName() .. "_HealthBar_Text1");
	--local hBar = getglobal(hdr:GetName() .. "_HealthBar");
	--hBar:SetToplevel(0)
	cOverlay:SetFrameLevel(hdr:GetFrameLevel() + 5);
	--cOverlay:SetToplevel(1)
	cOverlay:SetFrameStrata("TOOLTIP")
	cOverlay:RegisterForClicks("AnyUp");
	cOverlay:SetAttribute("type1", "target")
	cOverlay:SetAttribute("type2", "assist")
	--cOverlay:SetAttribute("unit", "player")
	if (HUI_Fav_List[tUFrame]) then cOverlay:SetAttribute("unit", HUI_Fav_List[tUFrame]); end
		
	--if (HUI_Fav[tUFrame].UnitNumber) then
		--cOverlay:SetAttribute("unit", HUI_Unit[HUI_Fav[tUFrame].UnitNumber].Unit)
	--end
	
	local tHB_XPos = 10
	-- Set the Name text on healthbar
	local tHB_Name_Text = getglobal(hdr:GetName() .. "_HealthBar_Text1");
	if (tHB_Name_Text) then 
		-- Set the frame label to target unit's full name
		local tName = HUI_Fav_List[tUFrame] --UnitName(HUI_Unit[HUI_Fav[tUFrame].UnitNumber].Unit)
		if (tName) then
			tHB_Name_Text:SetText(tName)
			tHB_Name_Text:Show();
		else -- Don't show name test. Set it to blank and hide it.
			tHB_Name_Text:SetText("")
			tHB_Name_Text:Hide();
		end
		
		local HB = getglobal(hdr:GetName() .. "_HealthBar");			
		HB:Show();
		HB:SetFrameLevel(hdr:GetFrameLevel() + 1);
		HB:SetValue(0)
		HUI_Fav[tUFrame].LastHealth = 0
		local HUI_HB_Height = tButton_Size - 4 -- padding above HB(2) and below HB(2)
		HB:SetHeight(HUI_HB_Height)
		HB:SetPoint("LEFT", hdr, "LEFT", tHB_XPos, tVoffset);
	end
	ClearOverrideBindings(hdr); -- Clear any key bindings to buttons
		
	-- CONFIGURE SPELL BUTTONS ---------------
	local HUI_Button_Anchor = HB
	for i = 1, HUI_Max_Buttons do -- Cycle through all HUI_Max_Buttons possible buttons
		HUI_Fav_Config_Button(tUFrame, i, HUI_Button_Anchor)
		HUI_Button_Anchor = HUI_Fav[tUFrame].Button[i]
	end -- End for i loop (cycle through buttons)
	
	if (HUI_Fav[tUFrame].Show) then 
		hdr:Show();
	else
		hdr:Hide();
	end
	hndlr:SetAttribute("state", 0); -- Force a state refresh to update everthing
end

