﻿--[[-----------------------------------------------------------------------------------------------------------------------------
Class Spells
These functions list the useable spells for each class and sets whether they are enabled.
---------------------------------------------------------------------------------------------------------------------------------]]
local addonName, L = ...; 
local function defaultFunc(L, key) 
return key; 
end 
setmetatable(L, {__index=defaultFunc});


function HUI_Priest_SetDefaultSpellsOptions()
	
	HUI_Chat(L["Loading Priest Spell Options"])
	local i=1
	HUI_SpellList[i] = "Renew"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].IsMine = 1
	i=i+1 --2
	HUI_SpellList[i] = "Flash Heal"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --3
	HUI_SpellList[i] = "Greater Heal"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions["Greater Heal"].CheckRange = 1
	i=i+1 --4
	HUI_SpellList[i] = "Prayer of Mending"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --5
	HUI_SpellList[i] = "Power Word: Shield"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffWeakenedSoul = 1
	i=i+1 --6
	HUI_SpellList[i] = "Desperate Prayer"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --7
	HUI_SpellList[i] = "Dispel Magic"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffMagic = 1
	i=i+1 --8
	HUI_SpellList[i] = "Abolish Disease"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffDisease = 1
	i=i+1 --9
	HUI_SpellList[i] = "Divine Spirit"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --10
	HUI_SpellList[i] = "Prayer of Spirit"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --11
	HUI_SpellList[i] = "Power Word: Fortitude"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --12
	HUI_SpellList[i] = "Shadow Protection"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --13
	HUI_SpellList[i] = "Prayer of Shadow Protection"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --14
	HUI_SpellList[i] = "Prayer of Fortitude"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --15
	HUI_SpellList[i] = "Inner Fire"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --16
	HUI_SpellList[i] = "Inner Focus"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --17
	HUI_SpellList[i] = "Pain Suppression"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --18
	HUI_SpellList[i] = "Power Infusion"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --19
	HUI_SpellList[i] = "Penance"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --20
	HUI_SpellList[i] = "Circle of Healing"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --21
	HUI_SpellList[i] = "Guardian Spirit"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --22
	HUI_SpellList[i] = "Binding Heal"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --23
	HUI_SpellList[i] = "Lesser Heal"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --24
	HUI_SpellList[i] = "Heal"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --25
	HUI_SpellList[i] = "Fade"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --26
	HUI_SpellList[i] = "Fear Ward"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --27
	HUI_SpellList[i] = "Levitate"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --28
	HUI_SpellList[i] = "Prayer of Healing"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --29
	HUI_SpellList[i] = "Divine Hymn"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --30
	HUI_SpellList[i] = "Hymn of Hope"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
end



function HUI_Paladin_SetDefaultSpellOptions()
	HUI_Chat(L["Setting Paladin Spell Option Defaults"])
	local i=1
	HUI_SpellList[i] = "Flash of Light"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --2
	HUI_SpellList[i] = "Holy Light"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --3
	HUI_SpellList[i] = "Cleanse"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffDisease = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffMagic = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffPoison = 1
	
	i=i+1 --4
	HUI_SpellList[i] = "Hand of Protection"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --2
	HUI_SpellList[i] = "Hand of Freedom"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --6
	HUI_SpellList[i] = "Hand of Salvation"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --7
	HUI_SpellList[i] = "Blessing of Might"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --8
	HUI_SpellList[i] = "Blessing of Wisdom"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --9
	HUI_SpellList[i] = "Blessing of Kings"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	
	i=i+1 --10
	HUI_SpellList[i] = "Greater Blessing of Might"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --11
	HUI_SpellList[i] = "Greater Blessing of Wisdom"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --12
	HUI_SpellList[i] = "Greater Blessing of Kings"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
		
	i=i+1 --13
	HUI_SpellList[i] = "Sacred Shield"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
		
	i=i+1 --14
	HUI_SpellList[i] = "Beacon of Light"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --15
	HUI_SpellList[i] = "Lay on Hands"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --16
	HUI_SpellList[i] = "Divine Shield"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --17
	HUI_SpellList[i] = "Righteous Defense"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --18
	HUI_SpellList[i] = "Avenging Wrath"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --19
	HUI_SpellList[i] = "Hand of Sacrifice"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --20
	HUI_SpellList[i] = "Holy Shock"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --21
	HUI_SpellList[i] = "Divine Favor"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --22
	HUI_SpellList[i] = "Seal of Wisdom"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --23
	HUI_SpellList[i] = "Seal of Life"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --24
	HUI_SpellList[i] = "Holy Light (Rank 5)"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --25
	HUI_SpellList[i] = "Divine Protection"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --26
	HUI_SpellList[i] = "Divine Intervention"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --27
	HUI_SpellList[i] = "Divine Light"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
		
	
end





function HUI_Druid_SetDefaultSpellOptions()
	HUI_Chat(L["Setting Druid Spell Option Defaults"])
	local i=1
	HUI_SpellList[i] = "Rejuvenation"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].IsMine = 1
	
	i=2
	HUI_SpellList[i] = "Regrowth"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].IsMine = 1
	
	i=3
	HUI_SpellList[i] = "Healing Touch"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=4
	HUI_SpellList[i] = "Abolish Poison"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffPoison = 1
	
	i=5
	HUI_SpellList[i] = "Remove Curse"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffCurse = 1
	
	i=6
	HUI_SpellList[i] = "Mark of the Wild"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	
	i=7
	HUI_SpellList[i] = "Gift of the Wild"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
		
	i=8
	HUI_SpellList[i] = "Thorns"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
		
	i=9
	HUI_SpellList[i] = "Nature's Grasp"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
		
	i=10
	HUI_SpellList[i] = "Lifebloom"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].IsMine = 1
		
	i=11
	HUI_SpellList[i] = "Rebirth"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CastOnDead = 1
	
	i=12
	HUI_SpellList[i] = "Innervate"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
		
	i=13
	HUI_SpellList[i] = "Nourish"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=14
	HUI_SpellList[i] = "Swiftmend"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=15
	HUI_SpellList[i] = "Nature's Swiftness"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=16
	HUI_SpellList[i] = "Tranquility"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=17
	HUI_SpellList[i] = "Wild Growth"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].IsMine = 1
	
	i=18
	HUI_SpellList[i] = "Remove Corruption"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffPoison = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffMagic = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffCurse = 1
end





function HUI_Shaman_SetDefaultSpellOptions()
	HUI_Chat(L["Setting Shaman Spell Option Defaults"])
	
	local i=1
	HUI_SpellList[i] = "Lesser Healing Wave"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --2
	HUI_SpellList[i] = "Healing Wave"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --3
	HUI_SpellList[i] = "Chain Heal"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --4
	HUI_SpellList[i] = "Cleanse Spirit"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffDisease = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffCurse = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffPoison = 1
	
	i=i+1 --5
	HUI_SpellList[i] = "Earth Shield"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --6
	HUI_SpellList[i] = "Tidal Force"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --7
	HUI_SpellList[i] = "Riptide"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	--HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --8
	HUI_SpellList[i] = "Bloodlust"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --9
	HUI_SpellList[i] = "Water Shield"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --10
	HUI_SpellList[i] = "Lightning Shield"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --11
	HUI_SpellList[i] = "Shamanistic Rage"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --12
	HUI_SpellList[i] = "Water Walking"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --13
	HUI_SpellList[i] = "Rockbiter Weapon"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].WeaponBuff = 1
	
	i=i+1 --14
	HUI_SpellList[i] = "Flametongue Weapon"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].WeaponBuff = 1
	
	i=i+1 --15
	HUI_SpellList[i] = "Frostbrand Weapon"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].WeaponBuff = 1
	
	i=i+1 --16
	HUI_SpellList[i] = "Earthliving Weapon"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].WeaponBuff = 1
		
	i=i+1 --17
	HUI_SpellList[i] = "Windfury Weapon"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].WeaponBuff = 1
	
	i=i+1 --18
	HUI_SpellList[i] = "Nature's Swiftness"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --19
	HUI_SpellList[i] = "Ancestral Spirit"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --20
	HUI_SpellList[i] = "Reincarnation"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --21
	HUI_SpellList[i] = "Astral Recall"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --22
	HUI_SpellList[i] = "Water Breathing"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --23
	HUI_SpellList[i] = "Cure Disease"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffDisease = 1
	
	i=i+1 --24
	HUI_SpellList[i] = "Cure Poison"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffPoison = 1
	
	i=i+1 --25
	HUI_SpellList[i] = "Ghost Wolf"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --26
	HUI_SpellList[i] = "Heroism"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --27
	HUI_SpellList[i] = "Lifeblood"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --28
	HUI_SpellList[i] = "Gift of the Naaru"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	
	i=i+1 --29
	HUI_SpellList[i] = "Call of Fire"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --30
	HUI_SpellList[i] = "Call of Earth"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --31
	HUI_SpellList[i] = "Cure Toxins"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffDisease = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffPoison = 1
	
	i=i+1 --32
	HUI_SpellList[i] = "Greater Healing Wave"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	
	i=i+1 --33
	HUI_SpellList[i] = "Healing Surge"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
		
end


function HUI_MonkDefault()
	HUI_Chat(L["Setting Monk Defaults"])
	HUI_Settings.RangeSpellName = "Soothing Mist"
		
	-- (No Modifier)
	HUI_SpellState[0].Button[1].SpellName = "Soothing Mist"
	HUI_SpellState[0].Button[2].SpellName = "Enveloping Mist"
	HUI_SpellState[0].Button[3].SpellName = "Surging Mist"
	HUI_SpellState[0].Button[4].SpellName = "Zen Sphere"
	HUI_SpellState[0].Button[4].SpellName = "Detox"
	-- (Alt)
	--HUI_SpellState[1].Button[1].SpellName = ""
	
	-- (Ctrl)
	--HUI_SpellState[2].Button[1].SpellName = ""
	
	-- (Shift)
	--HUI_SpellState[3].Button[1].SpellName = ""
	
end

function HUI_Monk_SetDefaultSpellOptions()
	
	HUI_Chat(L["Loading Monk Spell Options"])
	local i=1
	HUI_SpellList[i] = "Soothing Mist"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --2
	HUI_SpellList[i] = "Enveloping Mist"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --3
	HUI_SpellList[i] = "Surging Mist"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --4
	HUI_SpellList[i] = "Renewing Mist"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --5
	HUI_SpellList[i] = "Life Cocoon"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --6
	HUI_SpellList[i] = "Uplift"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --7
	HUI_SpellList[i] = "Expel Harm"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --8
	HUI_SpellList[i] = "Healing Sphere"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --9
	HUI_SpellList[i] = "Detox"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffDisease = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffPoison = 1
	i=i+1 --10
	HUI_SpellList[i] = "Internal Medicine"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	HUI_SpellOptions[HUI_SpellList[i]].CheckDebuff = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffMagic = 1
	HUI_SpellOptions[HUI_SpellList[i]].DebuffPoison = 1
	i=i+1 --11
	HUI_SpellList[i] = "Tiger's Lust"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --12
	HUI_SpellList[i] = "Chi Wave"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --13
	HUI_SpellList[i] = "Zen Sphere"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --14
	HUI_SpellList[i] = "Chi Burst"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --15
	HUI_SpellList[i] = "Chi Brew"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --16
	HUI_SpellList[i] = "Rushing Jade Wind"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --17
	HUI_SpellList[i] = "Chi Torpedo"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1	
	i=i+1 --18
	HUI_SpellList[i] = "Legacy of the Emperor"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --19
	HUI_SpellList[i] = "Fortifying Brew"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --20
	HUI_SpellList[i] = "Mana Tea"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --21
	HUI_SpellList[i] = "Thunder Focus Tea"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
	i=i+1 --22
	HUI_SpellList[i] = "Summon Jade Serpent Statue"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --23
	HUI_SpellList[i] = "Energizing Brew"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	i=i+1 --24
	HUI_SpellList[i] = "Tiger Eye Brew"
	HUI_SpellOptions[HUI_SpellList[i]] = {}
	HUI_SpellOptions[HUI_SpellList[i]].SpellName = HUI_SpellList[i]
	HUI_SpellOptions[HUI_SpellList[i]].CheckIfActive = 1
end



