
--[[ ===========================================================================================================================


							UPDATE BUTTOON FUNCTION

					
=================================================================================================================================]]

function HUI_Fav_ClearUFavButtons(tFavID)
	if not (tFavID) then return; end
	for b = 1, HUI_Max_Buttons do
		HUI_Fav[tFavID].IsActive[b] = nil
		HUI_Fav[tFavID].HasDebuff[b] = nil
		HUI_Fav[tFavID].LastExpTime[b] = nil
		if (HUI_Fav[tFavID].Button[b]) then
			if (HUI_Fav[tFavID].Button[b].icon) then
				HUI_Fav[tFavID].Button[b].icon:SetVertexColor(1, 1, 1, 1)
			end
			if (HUI_Fav[tFavID].Button[b].cooldown) then
				CooldownFrame_SetTimer( HUI_Fav[tFavID].Button[b].cooldown, 0, 0, 0)
			end
			if (HUI_Fav[tFavID].Button[b].Text) then
				HUI_Fav[tFavID].Button[b].Text:SetText("")
			end
			UIFrameFlashStop(HUI_Fav[tFavID].Button[b].border)
			HUI_Fav[tFavID].Button[b].ProcOn = nil;
			HUI_Fav[tFavID].Button[b].border:Hide();
		end
	end
end
function HUI_Fav_ClearButtons()
	for f = 1, HUI_Max_Favs do
		if (HUI_Fav[f].Show) then
			HUI_Fav_ClearUFavButtons(f)
		end
	end
end





function HUI_Fav_Button_Update(tUFrame, b)
	if (not tUFrame) or (not b) then return; end
	if not (HUI_Fav[tUFrame].Show) then return; end
	if not (HUI_Fav[tUFrame].Button[b]) or not (HUI_Fav[tUFrame].Button[b].cooldown) or not (HUI_Fav[tUFrame].Button[b].Text) then return; end
		
	local tSpellName = HUI_Spell_Button[b].SpellName
	if not (tSpellName) then
		HUI_Fav[tUFrame].Button[b]:SetAlpha(0);
		return;
	end
	HUI_Fav[tUFrame].Button[b]:SetAlpha(1);
		
	if (HUI_Spell_Button[b].isMacro) then
		if not (HUI_Spell_Button[b].MacroSpell) then return; end
		tSpellName = HUI_Spell_Button[b].MacroSpell;
	end
		
	if (HUI_Spell_Button[b].CastOnDead) then
		if (HUI_Fav[tUFrame].IsDead) then
			HUI_Fav[tUFrame].Button[b]:SetAlpha(1)
		else
			HUI_Fav[tUFrame].Button[b]:SetAlpha(0.3)
		end
	end
	
	-- If CheckActive and spell NOT active then UnDim
	if (HUI_Spell_Button[b].CheckIfActive) then
		local exptime, duration, count, active = HUI_Get_Buff_Times(HUI_Fav_List[tUFrame], tSpellName, HUI_Spell_Button[b].IsMine) 
		if (active) then -- Buff is Active, set cooldown to show buff duration
			if (count) and (tonumber(count)>0) then
				HUI_Fav[tUFrame].Button[b].Text:SetText(count)
			else
				HUI_Fav[tUFrame].Button[b].Text:SetText("")
			end
			if (duration) and (exptime) then
				if not (HUI_Fav[tUFrame].LastExpTime[b]) or not (exptime==HUI_Fav[tUFrame].LastExpTime[b]) then
					HUI_Fav[tUFrame].LastExpTime[b] = exptime
					local start = GetTime() - (duration - (exptime - GetTime()))
					CooldownFrame_SetTimer(HUI_Fav[tUFrame].Button[b].cooldown, start, duration, 1)
					HUI_Fav[tUFrame].IsActive[b] = 1
				end
			end
			HUI_Fav[tUFrame].Button[b].icon:SetVertexColor(0, 1, 0, 0.7)
			HUI_Fav[tUFrame].Button[b]:SetAlpha(1)
			return
		else -- Check if button thinks it's active and clear cooldown if it isn't 
			if (HUI_Fav[tUFrame].IsActive[b]) then
				--HUI_Fav[tUFrame].Button[b].cooldown:SetBackdropColor(0.3, 0.3, 0.3)
				HUI_Fav[tUFrame].Button[b].icon:SetVertexColor(1, 1, 1, 1)
				local start, duration, enable = GetSpellCooldown(tSpellName);
				if (start) and (duration) then
					CooldownFrame_SetTimer( HUI_Fav[tUFrame].Button[b].cooldown, start, duration, enable)
				else
					CooldownFrame_SetTimer( HUI_Fav[tUFrame].Button[b].cooldown, 0, 0, 0)
				end
				HUI_Fav[tUFrame].IsActive[b] = nil
				HUI_Fav[tUFrame].Button[b].Text:SetText("")
			end
		end
	end
	
	if (HUI_Spell_Button[b].hasProc) and (HUI_Spell_Button[b].ProcName) then
		if (HUI_Check_for_Buff("player", HUI_Spell_Button[b].ProcName)) then
			if not (HUI_Fav[tUFrame].Button[b].ProcOn) then
				HUI_Fav[tUFrame].Button[b].border:SetVertexColor(0, 1.0, 0, 1.0)
				HUI_Fav[tUFrame].Button[b].border:Show();
				UIFrameFlash(HUI_Fav[tUFrame].Button[b].border, 0.25, 0.25, 30, true, 0.25, 0)
				HUI_Fav[tUFrame].Button[b].ProcOn = 1;
			end
		else
			if (HUI_Fav[tUFrame].Button[b].ProcOn) then
				UIFrameFlashStop(HUI_Fav[tUFrame].Button[b].border)
				HUI_Fav[tUFrame].Button[b].border:Hide();
				HUI_Fav[tUFrame].Button[b].ProcOn = nil;
			end
		end
		--HUI_Chat("Setting border green");
	end
			
	-- If CheckDebuff and has debuff UnDim
	if ( HUI_Spell_Button[b].CheckDebuff) then
		local found = nil
		if (HUI_Spell_Button[b].DebuffMagic) and (HUI_Fav[tUFrame].HasMagic) then found=1; -- Check for Magic Debuff
		elseif (HUI_Spell_Button[b].DebuffCurse) and (HUI_Fav[tUFrame].HasCurse) then found=1; -- Check for Curse Debuff
		elseif (HUI_Spell_Button[b].DebuffPoison) and (HUI_Fav[tUFrame].HasPoison) then found=1; -- Check for Poison Debuff
		elseif (HUI_Spell_Button[b].DebuffDisease) and (HUI_Fav[tUFrame].HasDisease) then found=1; -- Check for Disease Debuff
		elseif (HUI_Spell_Button[b].DebuffWeakenedSoul) and (HUI_Fav[tUFrame].HasWS) then found=1;	end -- Weakened soul has the oposite effect, if the debuff is there gray out button 
		if (found) then
			if not (HUI_Fav[tUFrame].HasDebuff[b]) then
				HUI_Fav[tUFrame].Button[b].icon:SetVertexColor(1, 0, 0, 0.7)
				HUI_Fav[tUFrame].Button[b]:SetAlpha(1)
				HUI_Fav[tUFrame].HasDebuff[b] = 1;
			end
		else -- If no debuff found stop cooldown and dim button
			if (HUI_Fav[tUFrame].HasDebuff[b]) then
				HUI_Fav[tUFrame].Button[b].icon:SetVertexColor(1, 1, 1, 1)
				HUI_Fav[tUFrame].HasDebuff[b] = nil
			end
			HUI_Fav[tUFrame].Button[b]:SetAlpha(0.3)
		end
	end
	
	--[[
	if (1) then --IsUseableSpell(tSpellName)) then
		HUI_Fav[tUFrame].Button[b].icon:SetVertexColor(1, 1, 1, 1)
	else
		HUI_Fav[tUFrame].Button[b].icon:SetVertexColor(0, 0, 1, 0.7)
		HUI_Fav[tUFrame].Button[b]:SetAlpha(0.3)	
	end]]
	
end



function HUI_Fav_Update_Buttons()
	if (HUI_Num_Favs<1) then return; end
	
	for f = 1, HUI_Num_Favs do
		if (HUI_Fav[f].Show) then
			for b = 1, HUI_Max_Buttons do
				HUI_Fav_Button_Update(f, b)
			end
		end
	end
end


function HUI_FavFrame_Buttons_UpdateUnit(tUFrame)
	if not (tUFrame) then return; end
	
	for b = 1, HUI_Max_Buttons do
		local button = HUI_Fav[tUFrame].Button[b]
		if (button) then
			button:SetAttribute("unit", HUI_Fav_List[tUFrame]) 
		end
	end
end


--[[ ===========================================================================================================================


							CONFIG BUTTOON FUNCTION

					
=================================================================================================================================]]





--[[ ===========================================================================================================================
					ToolTip Functions
=================================================================================================================================]]
-- OnLeave function.  Added to a button to allow calling it via control:CallMethod("TooltipHide")
local function TooltipHide()
        GameTooltip:Hide()
end

-- Generic Tooltip function
local function TooltipShow(button)
	if not (HUI_Settings.TooltipEnable) then return; end
	local SpellName = button:GetAttribute("spell");
	if not (SpellName) then return; end
	--GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	GameTooltip:SetOwner(button, "ANCHOR_RIGHT");
	--GameTooltip:SetPoint("TOPLEFT", self , "TOPRIGHT", 0, 0);
	GameTooltip:SetText(SpellName);
    --GameTooltip:AddLine(SpellName, 0.2, 0.8, 0.8)
    GameTooltip:Show();
	button.UpdateTooltip = TooltipShow;
end

local function TooltipApply(button)
        button.TooltipShow = TooltipShow
        button.TooltipHide = TooltipHide
        SecureHandlerWrapScript(button, "OnEnter", button, [[ control:CallMethod("TooltipShow", self) ]])
        SecureHandlerWrapScript(button, "OnLeave", button, [[ control:CallMethod("TooltipHide") ]])
end

--[[ ===========================================================================================================================
					Cool Down Functions
=================================================================================================================================]]
function HUI_Fav_UpdateCooldown(arg1)
	if not (arg1) then return; end
	-- Check if Cooldown is being used by an Active Buff or Debuff to show duration
	local tUFrame = arg1:GetAttribute("UFrame")
	local b = arg1:GetAttribute("ButtonNum")
	if not (tUFrame) or not (b) then return; end
	HUI_Fav_Button_Update(tUFrame, b)
	if (HUI_Fav[tUFrame].IsActive[b]) then return; end
	
	--local tSpellName = arg1:GetAttribute("spell")
	local tSpellName = arg1:GetAttribute("CDSpell")
	if not (tSpellName) then return; end
	
	local start, duration, enable = GetSpellCooldown(tSpellName);
	if not (arg1.cooldown) or not (start) or not (duration) then
		return
	end
	if not (enable) then
		enable = 1
	end

	CooldownFrame_SetTimer( arg1.cooldown, start, duration, enable)
end


--[[ ===========================================================================================================================
					Create Button Functions
=================================================================================================================================]]

function HUI_Fav_Config_Button(tUFrame, tButton, tAnchorTo)
	if not (HUI_Spell_Button[tButton]) then return; end
	local tButton_Size = 36 
	local tButton_Spacing = 5 
	local hdr = HUI_Fav[tUFrame].Header:GetName();
	local hndlr = HUI_Fav[tUFrame].Handler;
	local button = HUI_Fav[tUFrame].Button[tButton]
	-- Create Button if doesn't exist
	local buttonName = "HUI_Favs" .. tUFrame .. "_B" .. tButton
	if (not button) then	
		button = CreateFrame("Button", buttonName, hndlr, "ActionButtonTemplate SecureActionButtonTemplate SecureHandlerStateTemplate")		
		button.icon = _G[buttonName.."Icon"]
		button.cooldown = _G[buttonName.."Cooldown"]
		button.border = _G[buttonName.."Border"]
		
		hndlr:SetAttribute("_adopt", button)
		button:RegisterForClicks("AnyUp");
		button.Text = button:CreateFontString(buttonName.."_Text", "ARTWORK", "GameFontHighlightLarge")
		button.Text:SetPoint("CENTER")
		button.Text:SetTextColor(1,1,1)
	end
	-- Clear count text on button
	button.Text:SetText("")
	-- Clear any tint
	button.icon:SetVertexColor(1, 1, 1, 1)
	-- Clear any border tint or flashing
	--UIFrameFlash(button.border, 0, 0, 0, false, 0, 0)
	--if (UIFrameIsFading(button.border)) then
	UIFrameFlashStop(button.border)
	button.ProcOn = nil;
	--end
	button.border:Hide();
	-- Show icon
	button.icon:Show()
	-- Register and associate update cooldown function
	button.HUI_Fav_UpdateCooldown = HUI_Fav_UpdateCooldown
	button:RegisterEvent('SPELL_UPDATE_COOLDOWN');
	button:SetScript("OnEvent", HUI_Fav_UpdateCooldown)
	-- Configure action for button	
	local tSpellName = HUI_Spell_Button[tButton].SpellName
	if not (HUI_Spell_Button[tButton].isMacro) then
		-- Is Spell
		button:SetAttribute("type", "spell")
		button:SetAttribute("spell", tSpellName)
		button:SetAttribute("unit", HUI_Fav_List[tUFrame]) 
		if (tSpellName) and (GetSpellTexture(tSpellName)) then
			button.icon:SetTexture(GetSpellTexture(tSpellName))
		end
	else
		-- Is Macro
		local name, icon, body, isLocal = GetMacroInfo(tSpellName);
		button:SetAttribute("type", "macro")
		button:SetAttribute("macrotext", body)
		if (icon) then	button.icon:SetTexture(icon); end
	end
	-- Set button attribute to be used by cooldown function 
	button:SetAttribute("UFrame", tUFrame)
	button:SetAttribute("ButtonNum", tButton)
	if (HUI_Spell_Button[tButton].isMacro) and (HUI_Spell_Button[tButton].MacroSpell) then
		button:SetAttribute("CDSpell", HUI_Spell_Button[tButton].MacroSpell); -- Tells cooldown function what spell to use for cooldown.
	else
		button:SetAttribute("CDSpell", tSpellName); -- Tells cooldown function what spell to use for cooldown.
	end
	-- Set Button Size
	button:ClearAllPoints()
	button:SetHeight(36) 
    button:SetWidth(36) 
    button:Show()
	-- Position Button
	button:SetPoint("RIGHT", hdr , "RIGHT", (-40*(HUI_Settings.NumberButtons-tButton+1))+38, 0)
	if (tButton<=HUI_Settings.NumberButtons) then
		button:Show()
	else
		button:Hide()
	end
	-- Save the button frame info in HUI_BUTTONS for later use
	HUI_Fav[tUFrame].Button[tButton] = button
end
