﻿local addonName, L = ...; 
local function defaultFunc(L, key) 
return key; 
end 
setmetatable(L, {__index=defaultFunc});

HUI_Version = "1.00.01"
HUI_ConfigVersion = "1.00.00"
HUI_ModName = "HealUI"
--[[ Creates several heal and buff buttons for each member, similar to Benecast without overhealing options and the buttons can't disappear.

-----------------------------------------------------------------------------------------------------------]]

HUI_SpellOptionsDone = nil

HUI_Max_Units = 40 -- Max Number of Units to check if present.
HUI_Max_Buttons = 12 -- Max Number of buttons per UFrame
HUI_Max_UFrames = 40 -- Max Number of UFrames (Unit Frames) that can be shown

HUI_Max_Favs = 40
HUI_Num_Favs = 0
HUI_Fav_List = {}
HUI_Fav = {{{}}}

HUI_Num_Units = 1

-- Saved general settings
HUI_Settings = {}
HUI_PANEL = {{{}}}
HUI_Unit = {{{}}}

HUI_Spell_Button = {{}}
HUI_Profile = {{{}}}
HUI_StoredPositions = {{{}}}

HUI_SpellOptions = {{}}
HUI_CursorSpellOptions = {{}}
HUI_OldSpellOptions = {{}}
HUI_hasOldSpellOptions = nil


HUI_Menu_SpellOption = {}
HUI_SpellList = {}
HUI_MenuSpellOptions = {{}}
HUI_MenuSpellList = {}

-- Pending change flag. Since changes can't be made in combat a flag is needed to indicate make changes after combat.
HUI_SpellChange = false;
HUI_PartyChange = false;
HUI_InRaid = nil
local HUI_AuraChange = 1
local HUI_LastAura = GetTime()
local HUI_UNIT_AURA_Counter = 0
local HUI_UNIT_AURA_Counter_Expire = GetTime() + 60

HUI_FlipFlop = 1


-- MiniMap Button Settings
HUI_MMButton_Entry = {}
HUI_MMButton_NumEntries = 0

HUI_AddOn_Loaded = nil
-- Create Update timer variables
local HUI_Update_Timer_Repeating = nil
local HUI_Update_Timer_Duration = nil
local HUI_Update_Timer_StartTime = nil
local HUI_Update_Timer_EndTime = nil
local HUI_Update_Timer_Button = nil

local HUI_Update_Delay = GetTime()

-- Temp copy of general settings for menus.
HUI_MenuSettings = {}
-- Temp menu settings that are a duplicate of game settings.
HUI_Menu_ModeNames = {}


--[[ ===========================================================================================================================
					Event Handling Functions
=================================================================================================================================]]

-- Create a frame to register and receive events
local evFrame = CreateFrame("Frame");
-- Register Events
evFrame:RegisterEvent("SPELLS_CHANGED");
evFrame:RegisterEvent("ADDON_LOADED");
evFrame:RegisterEvent("PLAYER_REGEN_ENABLED");
evFrame:RegisterEvent('GROUP_ROSTER_UPDATE');
evFrame:RegisterEvent("PLAYER_LOGIN");

function HUI_FrameOnEvent(self, event, arg1)
	
	--[[	
	if (arg1) then
		HUI_Chat("Event: event="..event..", arg1=" .. arg1);
	else
		HUI_Chat("Event: event="..event..", arg1=nil");
	end
	]]
	
	if (event == "ADDON_LOADED" and arg1 == HUI_ModName) then
		if not (HUI_Settings.SettingsLoaded) then
			HUI_Chat(L["SETTINGS NOT LOADED!!"])
		else
			HUI_Chat(L["Settings were loaded"])
		end
		HUI_Init_Nonsaved();
		if not (HUI_Settings.LoadedBefore) then
			HUI_Init_Settings();
			HUI_Chat(L["First time loaded. Setting Default Settings..."]);
		else
			HUI_Chat(L["Settings loaded..."]);
		end
		HUI_Chat(L["type /rui menu to configure Settings."]);
		HUI_Init_Slash()
		HUI_Create_Update_Timer_Frame();
	end
		
	
	if (HUI_Update_Timer_Button) and (not HUI_Update_Timer_Button:IsVisible()) then
		HUI_Set_Update_Timer(tInterval)
	end
	
	
	if (event == "PLAYER_LOGIN") then
		HUI_SpellChange = true;
		if (HUI_Settings.UpdateInterval) then
			local tInterval = HUI_Settings.UpdateInterval/1000
			HUI_Set_Update_Timer(tInterval)
		end
    end
		
	if (event == "SPELLS_CHANGED") then
		HUI_SpellChange = true;
	elseif ( event == "GROUP_ROSTER_UPDATE") then
		HUI_PartyChange = true;
	end
end

evFrame:SetScript("OnEvent", HUI_FrameOnEvent);

--[[ ===========================================================================================================================
					Update Timer Functions
	The update timer uses the OnUpdate of a dummy frame to check for elapsed time. OnUpdate for a frame is 
	called whenever the screen is redrawn. So I calculate what the time will be for the next update and then
	check if the current time is past that when ever onupdate is called. Once the elapse time is reach the
	status (grayouts, OOM, range) of each button is updated and the next update time is re-calculated.
=================================================================================================================================]]

function HUI_Create_Update_Timer_Frame()
	HUI_Update_Timer_Button = CreateFrame("Frame"); -- Create a dummy frame
	HUI_Update_Timer_Button:SetScript("OnUpdate", HUI_Update_Timer_OnUpdate) -- Set script so that HUI_Update_Timer_OnUpdate is called when ever there is an update on the frame.
end

function HUI_Set_Update_Timer(tInterval)
	if (not tInterval) or (tInterval<0) then return; end -- Verify a valid interval time was sent
	HUI_Update_Timer_Duration = tInterval -- Set the update timer values
	HUI_Update_Timer_StartTime = GetTime() -- GetTime returns time in seconds, so for example 100ms = 0.100 seconds.
	HUI_Update_Timer_EndTime = GetTime() + HUI_Update_Timer_Duration -- Calculate the time of next update
	HUI_Update_Timer_Button:Show(); -- Show frame so that is will start updating. The frame has no graphics so it will not be visible
end

function HUI_Update_Timer_OnUpdate()
	-- Check if the current time is past the calculated next update time
	if (not HUI_Update_Timer_EndTime) or (GetTime()<HUI_Update_Timer_EndTime) then return; end
	
	if (HUI_FlipFlop) then 
		HUI_FlipFlop = nil
	else
		HUI_FlipFlop = 1
	end
		
	if (HUI_Favorites_Frame:IsShown()) then
		HUI_Refresh_Favs()
	end
	
	-- There is a change pending, if not in combat then configure buttons
    if (not InCombatLockdown()) then
		if (HUI_SpellChange) or (HUI_PartyChange) then 
			if (GetTime()>HUI_Update_Delay) then
				HUI_UpdateUnits()
				HUI_Fav_Config_Panel()
				HUI_Debuff_SetIsNeeded()
				HUI_Fav_Update_Buttons()
				
				HUI_Fav_Header_Frame:Show()
								
				HUI_SpellChange = false;
				HUI_PartyChange = false;
				HUI_Fav_Change = nil
				HUI_Update_Delay = GetTime() + 5
				--Reset the update timer with possible interval changes
				if (HUI_Settings.UpdateInterval) then
					-- Update Interval is entered as ms, but the timer function uses seconds so ms must be converted to seconds.
					local tInterval = HUI_Settings.UpdateInterval/1000
					HUI_Set_Update_Timer(tInterval)
				end
			end
		else
			if (HUI_Fav_Change) then
				HUI_Fav_Config_Panel()
				HUI_Fav_Update_Buttons()
				HUI_Fav_Change = nil
			end
		end
		
    end
		
	-- Re-calculate the next update time. The timer will continuelly run until the dummy frame is hidden.
	HUI_Update_Timer_EndTime = GetTime() + HUI_Update_Timer_Duration
	HUI_Update_Timer_StartTime = GetTime()
end
