/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.xml.apx;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Vector;
import org.catacombae.xml.Attribute;
import org.catacombae.xml.DebugXMLContentHandler;
import org.catacombae.xml.NullXMLContentHandler;
import org.catacombae.xml.XMLContentHandler;
import org.catacombae.xml.apx.APXParserConstants;
import org.catacombae.xml.apx.APXParserTokenManager;
import org.catacombae.xml.apx.ParseException;
import org.catacombae.xml.apx.SimpleCharStream;
import org.catacombae.xml.apx.Token;

public class APXParser
implements APXParserConstants {
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private XMLContentHandler contentHandler;
    public APXParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[34];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new RuntimeException("The only valid argument is the name of the input file!");
        }
        APXParser encodingParser = APXParser.create(new InputStreamReader((InputStream)new FileInputStream(args[0]), DEFAULT_ENCODING), new NullXMLContentHandler(Charset.forName(DEFAULT_ENCODING)));
        String encoding = null;
        try {
            encoding = encodingParser.xmlDecl();
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        encodingParser = null;
        InputStreamReader usedReader = new InputStreamReader((InputStream)new FileInputStream(args[0]), encoding);
        APXParser a = APXParser.create(usedReader, new DebugXMLContentHandler(Charset.forName(encoding)));
        a.xmlDocument();
    }

    public static APXParser create(Reader misr, XMLContentHandler xch) {
        APXParser a = new APXParser(misr);
        a.contentHandler = xch;
        return a;
    }

    public final void xmlDocument() throws ParseException {
        this.prolog();
        this.element();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.misc();
        }
        this.jj_consume_token(0);
    }

    public final void prolog() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.xmlDecl();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block12;
                }
            }
            this.misc();
        }
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.doctypeDecl();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: 
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.misc();
                }
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
    }

    public final String xmlDecl() throws ParseException {
        String encoding = null;
        Boolean standalone = null;
        this.jj_consume_token(19);
        String version = this.versionInfo();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                encoding = this.encodingDecl();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                standalone = this.sdDecl();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(25);
        this.contentHandler.xmlDecl(version, encoding, standalone);
        return encoding;
    }

    public final String versionInfo() throws ParseException {
        Token versionString;
        this.jj_consume_token(29);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                versionString = this.jj_consume_token(41);
                this.jj_consume_token(38);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                versionString = this.jj_consume_token(41);
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return versionString.image;
    }

    public final String encodingDecl() throws ParseException {
        Token encoding;
        this.jj_consume_token(30);
        this.jj_consume_token(26);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                encoding = this.jj_consume_token(35);
                this.jj_consume_token(36);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                encoding = this.jj_consume_token(33);
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return encoding.image;
    }

    public final boolean sdDecl() throws ParseException {
        boolean b;
        this.jj_consume_token(31);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 46: {
                        this.jj_consume_token(46);
                        b = true;
                        break;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        b = false;
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(43);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 46: {
                        this.jj_consume_token(46);
                        b = true;
                        break;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        b = false;
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(45);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return b;
    }

    public final void doctypeDecl() throws ParseException {
        this.jj_consume_token(20);
        Token name = this.jj_consume_token(48);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                this.jj_consume_token(54);
                this.intSubset();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(49);
        this.contentHandler.doctype(name.image, null);
    }

    public final void intSubset() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        this.jj_consume_token(56);
    }

    public final void misc() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.comment();
                break;
            }
            case 18: {
                this.pi();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void comment() throws ParseException {
        StringBuilder sb = new StringBuilder();
        this.jj_consume_token(21);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 60: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            Token t = this.jj_consume_token(60);
            sb.append(t.image);
        }
        this.jj_consume_token(58);
        this.contentHandler.comment(sb.toString());
    }

    public final void pi() throws ParseException {
        StringBuilder content = null;
        this.jj_consume_token(18);
        Token target = this.jj_consume_token(63);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                content = this.piContent();
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.contentHandler.pi(target.image, content.toString());
    }

    public final StringBuilder piContent() throws ParseException {
        StringBuilder sb = new StringBuilder();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 61: {
                    this.jj_consume_token(61);
                    break;
                }
                case 65: {
                    Token t = this.jj_consume_token(65);
                    sb.append(t.image);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 61: 
                case 65: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[19] = this.jj_gen;
        return sb;
    }

    public final void element() throws ParseException {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        this.jj_consume_token(16);
        String name = this.elementname();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block7;
                }
            }
            Attribute currentAttribute = this.attribute();
            attributes.add(currentAttribute);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: {
                this.jj_consume_token(70);
                this.contentHandler.emptyElement(name, attributes);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                this.contentHandler.startElement(name, attributes);
                this.content();
                this.etag(name);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String elementname() throws ParseException {
        Token t = this.jj_consume_token(67);
        return t.image;
    }

    /*
     * Unable to fully structure code
     */
    public final Attribute attribute() throws ParseException {
        value = new LinkedList<Attribute.ValueComponent>();
        name = this.elementname();
        this.jj_consume_token(66);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 75: 
                        case 77: {
                            break;
                        }
                        default: {
                            this.jj_la1[22] = this.jj_gen;
                            ** GOTO lbl31
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 75: {
                            t = this.jj_consume_token(75);
                            value.add(new Attribute.StringComponent(t.image));
                            continue block18;
                        }
                        case 77: {
                            t = this.jj_consume_token(77);
                            value.add(new Attribute.ReferenceComponent(t.image));
                            continue block18;
                        }
                    }
                    break;
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
lbl31:
                // 1 sources

                this.jj_consume_token(73);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 76: 
                        case 77: {
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            ** GOTO lbl59
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 76: {
                            t = this.jj_consume_token(76);
                            value.add(new Attribute.StringComponent(t.image));
                            continue block19;
                        }
                        case 77: {
                            t = this.jj_consume_token(77);
                            value.add(new Attribute.ReferenceComponent(t.image));
                            continue block19;
                        }
                    }
                    break;
                }
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
lbl59:
                // 1 sources

                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new Attribute(name, new Attribute.Value(value));
    }

    public final void etag(String startName) throws ParseException {
        this.jj_consume_token(17);
        String name = this.elementname();
        this.jj_consume_token(71);
        if (!startName.equals(name)) {
            throw new ParseException("Expected \"</" + startName + "\" but got \"</" + name + "\".");
        }
        this.contentHandler.endElement(name);
    }

    public final void content() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.charData();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block16;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    this.element();
                    break;
                }
                case 24: {
                    Token t = this.jj_consume_token(24);
                    break;
                }
                case 22: {
                    this.cdSect();
                    break;
                }
                case 18: {
                    this.pi();
                    break;
                }
                case 21: {
                    this.comment();
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    this.charData();
                    continue block16;
                }
            }
            this.jj_la1[30] = this.jj_gen;
        }
    }

    public final void charData() throws ParseException {
        Token t;
        int beginLine = -1;
        int beginColumn = -1;
        block3: while (true) {
            t = this.jj_consume_token(23);
            if (beginLine == -1) {
                beginLine = t.beginLine;
                beginColumn = t.beginColumn;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[31] = this.jj_gen;
        this.contentHandler.chardata(beginLine, beginColumn, t.endLine, t.endColumn);
    }

    public final void cdSect() throws ParseException {
        StringBuilder cdata;
        block8: {
            cdata = new StringBuilder();
            this.jj_consume_token(22);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 78: 
                    case 79: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 78: {
                        this.jj_consume_token(78);
                        continue block7;
                    }
                    case 79: {
                        Token t = this.jj_consume_token(79);
                        cdata.append(t.image);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[33] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.contentHandler.cdata(cdata.toString());
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x240000, 524288, 0x240000, 0x240000, 0x100000, 0x40000000, Integer.MIN_VALUE, 0, 0x18000000, 0, 0, 0, 0, 0, 0, 0x240000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 23396352, 23396352, 0x800000, 0x800000, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 160, 0, 49152, 49152, 5120, 262144, 0x400000, 0x2000000, 0, 0x10000000, 0x20000000, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 2, 8, 192, 10240, 10240, 12288, 12288, 48, 0, 0, 0, 0, 0, 49152, 49152};
    }

    public APXParser(InputStream stream) {
        this(stream, null);
    }

    public APXParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new APXParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public APXParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new APXParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public APXParser(APXParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(APXParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[80];
        for (i = 0; i < 80; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 34; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 80; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        APXParser.jj_la1_0();
        APXParser.jj_la1_1();
        APXParser.jj_la1_2();
    }
}

