/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.xml;

import java.io.PrintStream;
import java.util.LinkedList;
import org.catacombae.xml.Attribute2;
import org.catacombae.xml.XMLElement;

public class XMLNode
extends XMLElement {
    public final String namespaceURI;
    public final String sName;
    public final String qName;
    public final Attribute2[] attrs;
    public final XMLNode parent;
    private final LinkedList<XMLElement> children;

    public XMLNode(String namespaceURI, String sName, String qName, Attribute2[] attrs, XMLNode parent) {
        this.namespaceURI = namespaceURI;
        this.sName = sName;
        this.qName = qName;
        this.attrs = attrs;
        this.parent = parent;
        this.children = new LinkedList();
    }

    public void addChild(XMLElement x) {
        this.children.addLast(x);
    }

    public void printTree(PrintStream pw) {
        this._printTree(pw, 0);
    }

    protected void _printTree(PrintStream pw, int level) {
        for (int i = 0; i < level; ++i) {
            pw.print(" ");
        }
        pw.print("<");
        pw.print(this.qName);
        for (Attribute2 a : this.attrs) {
            pw.print(" " + a.qName + "=" + a.value);
        }
        pw.println(">");
        for (XMLElement xe : this.children) {
            xe._printTree(pw, level + 1);
        }
        for (int i = 0; i < level; ++i) {
            pw.print(" ");
        }
        pw.println("</" + this.qName + ">");
    }

    public XMLElement[] getChildren() {
        return this.children.toArray(new XMLElement[this.children.size()]);
    }
}

