/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.plist;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.catacombae.dmgextractor.io.ConcatenatedReader;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.plist.PlistNode;
import org.catacombae.util.Util;
import org.catacombae.xml.XMLElement;
import org.catacombae.xml.XMLNode;
import org.catacombae.xml.XMLText;

public class XmlPlistNode
extends PlistNode {
    private final XMLNode xmlNode;

    public XmlPlistNode(XMLNode xmlNode) {
        this.xmlNode = xmlNode;
    }

    private XMLNode getXMLNode() {
        return this.xmlNode;
    }

    private String[] getKeys() throws RuntimeIOException {
        LinkedList<String> keyList = new LinkedList<String>();
        for (XMLElement xe : this.xmlNode.getChildren()) {
            if (!(xe instanceof XMLNode)) continue;
            XMLNode xn = (XMLNode)xe;
            if (!xn.qName.equals("key")) continue;
            for (XMLElement xeChild : xn.getChildren()) {
                String key;
                if (!(xeChild instanceof XMLText)) continue;
                XMLText xtChild = (XMLText)xeChild;
                try {
                    key = Util.readFully((Reader)xtChild.getText());
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
                keyList.addLast(key);
            }
        }
        return keyList.toArray(new String[keyList.size()]);
    }

    public PlistNode[] getChildren() {
        LinkedList<PlistNode> children = new LinkedList<PlistNode>();
        for (String key : this.getKeys()) {
            children.add(this.cdkey(key));
        }
        return children.toArray(new PlistNode[children.size()]);
    }

    public PlistNode cd(String type) {
        for (XMLElement xn : this.xmlNode.getChildren()) {
            if (!(xn instanceof XMLNode) || !((XMLNode)xn).qName.equals(type)) continue;
            return new XmlPlistNode((XMLNode)xn);
        }
        return null;
    }

    public PlistNode cdkey(String key) {
        return this.cdkeyXml(key);
    }

    private XmlPlistNode cdkeyXml(String key) {
        boolean keyFound = false;
        for (XMLElement xn : this.xmlNode.getChildren()) {
            if (!(xn instanceof XMLNode)) continue;
            if (keyFound) {
                return new XmlPlistNode((XMLNode)xn);
            }
            if (!((XMLNode)xn).qName.equals("key")) continue;
            for (XMLElement xn2 : ((XMLNode)xn).getChildren()) {
                try {
                    String s;
                    if (!(xn2 instanceof XMLText) || !(s = Util.readFully((Reader)((XMLText)xn2).getText())).equals(key)) continue;
                    keyFound = true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public Reader getKeyValue(String key) {
        XmlPlistNode keyNode = this.cdkeyXml(key);
        if (keyNode == null) {
            return null;
        }
        XMLElement[] nodeChildren = keyNode.getXMLNode().getChildren();
        if (nodeChildren.length != 1) {
            LinkedList<Reader> collectedReaders = new LinkedList<Reader>();
            for (XMLElement xe : keyNode.getXMLNode().getChildren()) {
                if (!(xe instanceof XMLText)) continue;
                try {
                    Reader xt = ((XMLText)xe).getText();
                    collectedReaders.addLast(xt);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ConcatenatedReader result = collectedReaders.size() == 0 ? null : new ConcatenatedReader(collectedReaders.toArray(new Reader[collectedReaders.size()]));
            return result;
        }
        if (nodeChildren[0] instanceof XMLText) {
            try {
                return ((XMLText)nodeChildren[0]).getText();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

