/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.plist;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.catacombae.dmgextractor.io.RandomAccessInputStream;
import org.catacombae.dmgextractor.io.SynchronizedRandomAccessStream;
import org.catacombae.io.ReadableByteArrayStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.plist.PlistNode;
import org.catacombae.plist.XmlPlistNode;
import org.catacombae.xml.NodeBuilder;
import org.catacombae.xml.NodeBuilderContentHandler;
import org.catacombae.xml.NullXMLContentHandler;
import org.catacombae.xml.XMLNode;
import org.catacombae.xml.apx.APXParser;
import org.catacombae.xml.apx.ParseException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlPlist {
    private final XMLNode rootNode;

    public XmlPlist(byte[] data) {
        this(data, 0, data.length);
    }

    public XmlPlist(byte[] data, boolean useSAXParser) {
        this(data, 0, data.length, useSAXParser);
    }

    public XmlPlist(byte[] data, int offset, int length) {
        this(data, offset, length, false);
    }

    public XmlPlist(byte[] data, int offset, int length, boolean useSAXParser) {
        this.rootNode = this.parseXMLData(data, useSAXParser);
    }

    public PlistNode getRootNode() {
        return new XmlPlistNode(this.rootNode);
    }

    private XMLNode parseXMLData(byte[] plistData, boolean defaultToSAX) {
        NodeBuilder handler = new NodeBuilder();
        if (defaultToSAX) {
            this.parseXMLDataSAX(plistData, handler);
        } else {
            try {
                this.parseXMLDataAPX(plistData, handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("APX parser threw exception... falling back to SAX parser. Report this error!");
                handler = new NodeBuilder();
                this.parseXMLDataSAX(plistData, handler);
            }
        }
        XMLNode[] rootNodes = handler.getRoots();
        if (rootNodes.length != 1) {
            throw new RuntimeException("Could not parse DMG-file!");
        }
        return rootNodes[0];
    }

    private void parseXMLDataAPX(byte[] buffer, NodeBuilder handler) {
        try {
            ReadableByteArrayStream ya = new ReadableByteArrayStream(buffer);
            SynchronizedRandomAccessStream bufferStream = new SynchronizedRandomAccessStream((ReadableRandomAccessStream)ya);
            RandomAccessInputStream is = new RandomAccessInputStream(bufferStream);
            APXParser encodingParser = APXParser.create(new InputStreamReader((InputStream)is, "US-ASCII"), new NullXMLContentHandler(Charset.forName("US-ASCII")));
            String encodingName = encodingParser.xmlDecl();
            if (encodingName == null) {
                encodingName = "US-ASCII";
            }
            Charset encoding = Charset.forName(encodingName);
            is = new RandomAccessInputStream(bufferStream);
            BufferedReader usedReader = new BufferedReader(new InputStreamReader((InputStream)is, encoding));
            APXParser documentParser = APXParser.create(usedReader, new NodeBuilderContentHandler(handler, bufferStream, encoding));
            documentParser.xmlDocument();
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private void parseXMLDataSAX(byte[] buffer, NodeBuilder handler) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse((InputStream)is, (DefaultHandler)handler);
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new RuntimeException(se);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

