/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.udif;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.catacombae.dmg.udif.Plist;
import org.catacombae.dmg.udif.PlistPartition;
import org.catacombae.dmg.udif.UDIFBlock;
import org.catacombae.dmg.udif.UDIFBlockInputStream;
import org.catacombae.dmg.udif.UDIFFile;
import org.catacombae.io.BasicReadableRandomAccessStream;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class UDIFRandomAccessStream
extends BasicReadableRandomAccessStream {
    private UDIFFile dmgFile;
    private UDIFBlock[] allBlocks;
    private UDIFBlock currentBlock;
    private UDIFBlockInputStream currentBlockStream;
    private long length;
    private long logicalFilePointer = 0L;
    private boolean seekCalled = false;

    private static void dbg(String s) {
        System.err.println(s);
    }

    public UDIFRandomAccessStream(RandomAccessFile raf) throws RuntimeIOException {
        this((ReadableRandomAccessStream)new ReadableFileStream(raf));
    }

    public UDIFRandomAccessStream(ReadableRandomAccessStream stream) throws RuntimeIOException {
        this(new UDIFFile(stream));
    }

    public UDIFRandomAccessStream(UDIFFile dmgFile) throws RuntimeIOException {
        this.dmgFile = dmgFile;
        Plist plist = dmgFile.getView().getPlist();
        try {
            PlistPartition[] partitions = plist.getPartitions();
            int totalBlockCount = 0;
            for (PlistPartition pp : partitions) {
                totalBlockCount += pp.getBlockCount();
            }
            this.allBlocks = new UDIFBlock[totalBlockCount];
            int pos = 0;
            for (PlistPartition pp : partitions) {
                UDIFBlock[] blocks = pp.getBlocks();
                System.arraycopy(blocks, 0, this.allBlocks, pos, blocks.length);
                pos += blocks.length;
                this.length += pp.getPartitionSize();
            }
            if (totalBlockCount <= 0) {
                throw new RuntimeException("Could not find any blocks in the DMG file...");
            }
            this.currentBlock = this.allBlocks[0];
            this.repositionStream();
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public void close() throws RuntimeIOException {
    }

    public long getFilePointer() throws RuntimeIOException {
        return this.logicalFilePointer;
    }

    public long length() throws RuntimeIOException {
        return this.length;
    }

    public int read() throws RuntimeIOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) != 1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b) throws RuntimeIOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws RuntimeIOException {
        try {
            if (this.seekCalled) {
                this.seekCalled = false;
                try {
                    this.repositionStream();
                }
                catch (RuntimeException re) {
                    return -1;
                }
            }
            int bytesRead = 0;
            while (bytesRead < len) {
                int curBytesRead = this.currentBlockStream.read(b, off + bytesRead, len - bytesRead);
                if (curBytesRead < 0) {
                    try {
                        this.repositionStream();
                    }
                    catch (RuntimeException re) {
                        if (bytesRead != 0) break;
                        bytesRead = -1;
                        break;
                    }
                    curBytesRead = this.currentBlockStream.read(b, off + bytesRead, len - bytesRead);
                    if (curBytesRead < 0) {
                        throw new RuntimeException("No bytes could be read, and no exception was thrown! Program error...");
                    }
                }
                bytesRead += curBytesRead;
                this.logicalFilePointer += (long)curBytesRead;
            }
            return bytesRead;
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public void seek(long pos) throws RuntimeIOException {
        if (this.logicalFilePointer != pos) {
            this.seekCalled = true;
            this.logicalFilePointer = pos;
        }
    }

    private void repositionStream() throws RuntimeIOException {
        try {
            if (this.currentBlock.getTrueOutOffset() > this.logicalFilePointer || this.currentBlock.getTrueOutOffset() + this.currentBlock.getOutSize() <= this.logicalFilePointer) {
                UDIFBlock soughtBlock = null;
                for (UDIFBlock dblk : this.allBlocks) {
                    long startPos = dblk.getTrueOutOffset();
                    long endPos = startPos + dblk.getOutSize();
                    if (startPos > this.logicalFilePointer || endPos <= this.logicalFilePointer) continue;
                    soughtBlock = dblk;
                    break;
                }
                if (soughtBlock != null) {
                    this.currentBlock = soughtBlock;
                } else {
                    throw new RuntimeException("Trying to seek outside bounds.");
                }
            }
            this.currentBlockStream = UDIFBlockInputStream.getStream(this.dmgFile.getStream(), this.currentBlock);
            long bytesToSkip = this.logicalFilePointer - this.currentBlock.getTrueOutOffset();
            this.currentBlockStream.skip(bytesToSkip);
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("UDIFRandomAccessStream simple test program");
        System.out.println("(Simply extracts the contents of a DMG file to a designated output file)");
        if (args.length != 2) {
            System.out.println("  ERROR: You must supply exactly two arguments: 1. the DMG, 2. the output file");
        } else {
            byte[] buffer = new byte[4096];
            UDIFRandomAccessStream dras = new UDIFRandomAccessStream(new UDIFFile((ReadableRandomAccessStream)new ReadableFileStream(new RandomAccessFile(args[0], "r"))));
            FileOutputStream fos = new FileOutputStream(args[1]);
            long totalBytesRead = 0L;
            int bytesRead = dras.read(buffer);
            while (bytesRead > 0) {
                totalBytesRead += (long)bytesRead;
                fos.write(buffer, 0, bytesRead);
                bytesRead = dras.read(buffer);
            }
            System.out.println("Done! Extracted " + totalBytesRead + " bytes.");
            System.out.println("Length: " + dras.length() + " bytes");
        }
    }
}

