/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.udif;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.catacombae.dmg.udif.UDIFRandomAccessStream;

public class UDIFInputStream
extends InputStream {
    private UDIFRandomAccessStream wrapped;
    private long filePointer;

    public UDIFInputStream(RandomAccessFile raf) throws IOException {
        this(new UDIFRandomAccessStream(raf));
    }

    public UDIFInputStream(UDIFRandomAccessStream dras) throws IOException {
        this.wrapped = dras;
    }

    public int available() throws IOException {
        long len = this.wrapped.length() - this.filePointer;
        if (len > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (len < 0L) {
            throw new IOException("Internal error! filePointer > wrapped.length! filePointer:" + this.filePointer + " wrapped.length():" + this.wrapped.length());
        }
        return (int)len;
    }

    public void close() throws IOException {
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) != 1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (this.wrapped.getFilePointer() != this.filePointer) {
            this.wrapped.seek(this.filePointer);
        }
        if ((bytesRead = this.wrapped.read(b, off, len)) > 0) {
            this.filePointer += (long)bytesRead;
        }
        return bytesRead;
    }

    public void reset() throws IOException {
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        long newPos = this.filePointer + n;
        if (newPos > this.wrapped.length()) {
            newPos = this.wrapped.length();
        }
        this.wrapped.seek(newPos);
        long result = newPos - this.filePointer;
        this.filePointer = newPos;
        return result;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("usage: java org.catacombae.udif.UDIFInputStream <infile> <outfile>");
        }
        File inFile = new File(args[0]);
        File outFile = new File(args[1]);
        RandomAccessFile inRaf = null;
        FileOutputStream outFos = null;
        if (inFile.canRead()) {
            inRaf = new RandomAccessFile(inFile, "r");
        } else {
            System.out.println("Can't read from input file!");
            System.exit(0);
        }
        if (!outFile.exists()) {
            outFos = new FileOutputStream(outFile);
        } else {
            System.out.println("Output file already exists!");
            System.exit(0);
        }
        UDIFInputStream dis = new UDIFInputStream(inRaf);
        byte[] buffer = new byte[8192];
        long bytesExtracted = 0L;
        int bytesRead = dis.read(buffer);
        while (bytesRead > 0) {
            bytesExtracted += (long)bytesRead;
            outFos.write(buffer, 0, bytesRead);
            bytesRead = dis.read(buffer);
        }
        dis.close();
        inRaf.close();
        outFos.close();
        System.out.println("Extracted " + bytesExtracted + " bytes to \"" + outFile + "\".");
    }
}

