/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.udif;

import java.io.RandomAccessFile;
import org.catacombae.dmg.udif.Koly;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class UDIFDetector {
    public static boolean isUDIFEncoded(RandomAccessFile raf) throws RuntimeIOException {
        return UDIFDetector.isUDIFEncoded((ReadableRandomAccessStream)new ReadableFileStream(raf));
    }

    public static boolean isUDIFEncoded(ReadableRandomAccessStream ras) throws RuntimeIOException {
        if (ras.length() < 512L) {
            return false;
        }
        byte[] kolyData = new byte[Koly.length()];
        ras.seek(ras.length() - 512L);
        if (ras.read(kolyData) != kolyData.length) {
            throw new RuntimeException("Could not read all koly data...");
        }
        Koly koly = new Koly(kolyData, 0);
        return koly.isValid() && koly.getPlistBegin1() >= 0L && koly.getPlistSize() > 0L && koly.getPlistBegin1() + koly.getPlistSize() <= ras.length() - 512L;
    }
}

