/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.udif;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import net.iharder.base64.Base64;
import org.catacombae.dmg.udif.PlistPartition;
import org.catacombae.dmgextractor.Util;
import org.catacombae.dmgextractor.io.ReaderInputStream;
import org.catacombae.plist.PlistNode;
import org.catacombae.plist.XmlPlist;

public class Plist
extends XmlPlist {
    public Plist(byte[] data) {
        this(data, 0, data.length);
    }

    public Plist(byte[] data, boolean useSAXParser) {
        this(data, 0, data.length, useSAXParser);
    }

    public Plist(byte[] data, int offset, int length) {
        this(data, offset, length, false);
    }

    public Plist(byte[] data, int offset, int length, boolean useSAXParser) {
        super(data, offset, length, useSAXParser);
    }

    public PlistPartition[] getPartitions() throws IOException {
        LinkedList<PlistPartition> partitionList = new LinkedList<PlistPartition>();
        PlistNode current = this.getRootNode();
        current = current.cd("dict");
        current = current.cdkey("resource-fork");
        current = current.cdkey("blkx");
        long previousOutOffset = 0L;
        long previousInOffset = 0L;
        for (PlistNode pn : current.getChildren()) {
            String partitionName = Util.readFully((Reader)pn.getKeyValue("Name"));
            String partitionID = Util.readFully((Reader)pn.getKeyValue("ID"));
            String partitionAttributes = Util.readFully((Reader)pn.getKeyValue("Attributes"));
            Reader base64Data = pn.getKeyValue("Data");
            Base64.InputStream base64DataInputStream = new Base64.InputStream((InputStream)new ReaderInputStream(base64Data, Charset.forName("US-ASCII")));
            PlistPartition dpp = new PlistPartition(partitionName, partitionID, partitionAttributes, (InputStream)base64DataInputStream, previousOutOffset, previousInOffset);
            previousOutOffset = dpp.getFinalOutOffset();
            previousInOffset = dpp.getFinalInOffset();
            partitionList.addLast(dpp);
        }
        return partitionList.toArray(new PlistPartition[partitionList.size()]);
    }
}

