/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.udif;

import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.catacombae.dmgextractor.Util;

public class Koly {
    private static final int KOLY_FOURCC = 1802464377;
    private final byte[] fourCC = new byte[4];
    private final byte[] unknown1 = new byte[28];
    private final byte[] plistBegin1 = new byte[8];
    private final byte[] plistEndSometimes = new byte[8];
    private final byte[] unknown2 = new byte[8];
    private final byte[] unknown3 = new byte[8];
    private final byte[] unknown4 = new byte[8];
    private final byte[] unknown5 = new byte[8];
    private final byte[] possibleChecksumType = new byte[8];
    private final byte[] unknown6 = new byte[4];
    private final byte[] possibleUnitSize = new byte[4];
    private final byte[] unknown7 = new byte[120];
    private final byte[] plistBegin2 = new byte[8];
    private final byte[] plistSize = new byte[8];
    private final byte[] unknown8 = new byte[120];
    private final byte[] checksumAlgorithm = new byte[4];
    private final byte[] checksumSize = new byte[4];
    private final byte[] checksumData = new byte[152];

    public Koly(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.fourCC, 0, 4);
        System.arraycopy(data, offset + 4, this.unknown1, 0, 28);
        System.arraycopy(data, offset + 32, this.plistBegin1, 0, 8);
        System.arraycopy(data, offset + 40, this.plistEndSometimes, 0, 8);
        System.arraycopy(data, offset + 48, this.unknown2, 0, 8);
        System.arraycopy(data, offset + 56, this.unknown3, 0, 8);
        System.arraycopy(data, offset + 64, this.unknown4, 0, 8);
        System.arraycopy(data, offset + 72, this.unknown5, 0, 8);
        System.arraycopy(data, offset + 80, this.possibleChecksumType, 0, 8);
        System.arraycopy(data, offset + 88, this.unknown6, 0, 4);
        System.arraycopy(data, offset + 92, this.possibleUnitSize, 0, 4);
        System.arraycopy(data, offset + 96, this.unknown7, 0, 120);
        System.arraycopy(data, offset + 216, this.plistBegin2, 0, 8);
        System.arraycopy(data, offset + 224, this.plistSize, 0, 8);
        System.arraycopy(data, offset + 232, this.unknown8, 0, 120);
        System.arraycopy(data, offset + 352, this.checksumAlgorithm, 0, 4);
        System.arraycopy(data, offset + 356, this.checksumSize, 0, 4);
        System.arraycopy(data, offset + 360, this.checksumData, 0, 152);
    }

    public static int length() {
        return 512;
    }

    public int getFourCC() {
        return Util.readIntBE((byte[])this.fourCC);
    }

    public byte[] getUnknown1() {
        return Util.createCopy((byte[])this.unknown1);
    }

    public long getPlistBegin1() {
        return Util.readLongBE((byte[])this.plistBegin1);
    }

    public long getPlistEndSometimes() {
        return Util.readLongBE((byte[])this.plistEndSometimes);
    }

    public long getUnknown2() {
        return Util.readLongBE((byte[])this.unknown2);
    }

    public long getUnknown3() {
        return Util.readLongBE((byte[])this.unknown3);
    }

    public long getUnknown4() {
        return Util.readLongBE((byte[])this.unknown4);
    }

    public long getUnknown5() {
        return Util.readLongBE((byte[])this.unknown5);
    }

    public long getPossibleChecksumType() {
        return Util.readLongBE((byte[])this.possibleChecksumType);
    }

    public int getUnknown6() {
        return Util.readIntBE((byte[])this.unknown6);
    }

    public int getPossibleUnitSize() {
        return Util.readIntBE((byte[])this.possibleUnitSize);
    }

    public byte[] getUnknown7() {
        return Util.createCopy((byte[])this.unknown7);
    }

    public long getPlistBegin2() {
        return Util.readLongBE((byte[])this.plistBegin2);
    }

    public long getPlistSize() {
        return Util.readLongBE((byte[])this.plistSize);
    }

    public byte[] getUnknown8() {
        return Util.createCopy((byte[])this.unknown8);
    }

    public int getChecksumAlgorithm() {
        return Util.readIntBE((byte[])this.checksumAlgorithm);
    }

    public int getChecksumSize() {
        return Util.readIntBE((byte[])this.checksumSize);
    }

    public byte[] getChecksumData() {
        return Util.createCopy((byte[])this.checksumData);
    }

    public boolean isValid() {
        return this.getFourCC() == 1802464377;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " fourCC: \"" + Util.toASCIIString((int)this.getFourCC()) + "\"");
        ps.println(prefix + " unknown1: 0x" + Util.byteArrayToHexString((byte[])this.getUnknown1()));
        ps.println(prefix + " plistBegin1: " + this.getPlistBegin1());
        ps.println(prefix + " plistEndSometimes: " + this.getPlistEndSometimes());
        ps.println(prefix + " unknown2: " + this.getUnknown2());
        ps.println(prefix + " unknown3: " + this.getUnknown3());
        ps.println(prefix + " unknown4: " + this.getUnknown4());
        ps.println(prefix + " unknown5: " + this.getUnknown5());
        ps.println(prefix + " possibleChecksumType: " + this.getPossibleChecksumType());
        ps.println(prefix + " unknown6: " + this.getUnknown6());
        ps.println(prefix + " possibleUnitSize: " + this.getPossibleUnitSize());
        ps.println(prefix + " unknown7: 0x" + Util.byteArrayToHexString((byte[])this.getUnknown7()));
        ps.println(prefix + " plistBegin2: " + this.getPlistBegin2());
        ps.println(prefix + " plistSize: " + this.getPlistSize());
        ps.println(prefix + " unknown8: 0x" + Util.byteArrayToHexString((byte[])this.getUnknown8()));
        ps.println(prefix + " checksumAlgorithm: " + this.getChecksumAlgorithm());
        int checksumSize = this.getChecksumSize() / 8;
        byte[] checksumData = this.getChecksumData();
        ps.println(prefix + " checksumSize: " + checksumSize);
        ps.println(prefix + " checksumData: 0x" + Util.byteArrayToHexString((byte[])checksumData, (int)0, (int)checksumSize));
        int i = 0;
        while (i + 4 <= checksumData.length - checksumSize) {
            ps.println(prefix + " trailing data[" + i + "]: 0x " + Util.byteArrayToHexString((byte[])checksumData, (int)(checksumSize + i), (int)4));
            i += 4;
        }
        int bytesLeft = i + 4 - (checksumData.length - checksumSize);
        if (bytesLeft > 0 && bytesLeft < 4) {
            System.err.println("bytes left: " + bytesLeft);
            ps.println(prefix + " trailing data[" + i + "]: 0x " + Util.byteArrayToHexString((byte[])checksumData, (int)(checksumSize + i), (int)(i + 4 - (checksumData.length - checksumSize))));
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "Koly:");
        this.printFields(ps, prefix);
    }

    public static void main(String[] args) throws IOException {
        byte[] kolyData = new byte[512];
        RandomAccessFile raf = new RandomAccessFile(args[0], "r");
        raf.seek(raf.length() - 512L);
        if (raf.read(kolyData) != kolyData.length) {
            throw new RuntimeException("Could not read entire koly...");
        }
        raf.close();
        Koly k = new Koly(kolyData, 0);
        k.print(System.out, "");
    }
}

