/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.sparsebundle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.catacombae.dmg.sparsebundle.Band;
import org.catacombae.dmg.sparsebundle.Info;
import org.catacombae.dmg.sparsebundle.Token;
import org.catacombae.io.RuntimeIOException;

class SparseBundle {
    private static final String mainInfoFilename = "Info.plist";
    private static final String backupInfoFilename = "Info.bckup";
    private static final String tokenFilename = "token";
    private static final String bandsDirname = "bands";
    private final Info mainInfo;
    private final Info backupInfo;
    private final Token token;
    private final File bandsDir;
    private long size;
    private long bandSize;
    private long bandCount;

    public SparseBundle(File sparseBundleDir) throws RuntimeIOException {
        FileLock tokenLock;
        FileLock backupInfoLock;
        FileLock mainInfoLock;
        RandomAccessFile tokenRaf;
        RandomAccessFile backupInfoRaf;
        RandomAccessFile mainInfoRaf;
        File[] files = sparseBundleDir.listFiles();
        File mainInfoFile = null;
        File backupInfoFile = null;
        File tokenFile = null;
        File bandsDir = null;
        for (File f : files) {
            if (f.getName().equals(mainInfoFilename)) {
                mainInfoFile = f;
                continue;
            }
            if (f.getName().equals(backupInfoFilename)) {
                backupInfoFile = f;
                continue;
            }
            if (f.getName().equals(tokenFilename)) {
                tokenFile = f;
                continue;
            }
            if (f.getName().equals(bandsDirname)) {
                bandsDir = f;
                continue;
            }
            System.err.println("Warning: Encountered unknown file \"" + f.getName() + " in sparse bundle base dir (\"" + sparseBundleDir.getAbsolutePath() + "\").");
        }
        if (mainInfoFile == null || backupInfoFile == null || tokenFile == null || bandsDir == null) {
            throw new RuntimeIOException("Some files are missing from the sparse bundle directory (\"" + sparseBundleDir.getAbsolutePath() + "\".");
        }
        if (!bandsDir.exists() || !bandsDir.isDirectory()) {
            throw new RuntimeIOException("Invalid 'bands' directory.");
        }
        try {
            mainInfoRaf = new RandomAccessFile(mainInfoFile, "r");
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeIOException("Failed to open 'Info.plist' for reading.", (IOException)ex);
        }
        try {
            backupInfoRaf = new RandomAccessFile(backupInfoFile, "r");
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeIOException("Failed to open 'Info.bckup' for reading.", (IOException)ex);
        }
        try {
            tokenRaf = new RandomAccessFile(tokenFile, "r");
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeIOException("Failed to open 'token' for reading.", (IOException)ex);
        }
        try {
            mainInfoLock = mainInfoRaf.getChannel().lock(0L, Long.MAX_VALUE, true);
        }
        catch (IOException ex) {
            throw new RuntimeIOException("Failed to aquire a shared lock on 'Info.plist'.", ex);
        }
        try {
            backupInfoLock = backupInfoRaf.getChannel().lock(0L, Long.MAX_VALUE, true);
        }
        catch (IOException ex) {
            throw new RuntimeIOException("Failed to aquire a shared lock on 'Info.bckup'.", ex);
        }
        try {
            tokenLock = tokenRaf.getChannel().lock(0L, Long.MAX_VALUE, true);
        }
        catch (IOException ex) {
            throw new RuntimeIOException("Failed to aquire a shared lock on 'token'.", ex);
        }
        try {
            this.mainInfo = new Info(mainInfoRaf, mainInfoLock);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Exception while parsing 'Info.plist'.", ioe);
        }
        try {
            this.backupInfo = new Info(backupInfoRaf, backupInfoLock);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Exception while parsing 'Info.bckup'.", ioe);
        }
        this.token = new Token(tokenRaf, tokenLock);
        this.bandsDir = bandsDir;
        this.size = this.mainInfo.getSize();
        this.bandSize = this.mainInfo.getBandSize();
        this.bandCount = (this.mainInfo.getSize() + this.mainInfo.getBandSize() - 1L) / this.mainInfo.getBandSize();
        this.checkBandsDir();
    }

    private void checkBandsDir() throws RuntimeIOException {
        for (File f : this.bandsDir.listFiles()) {
            long bandNumber;
            if (!f.isFile()) {
                throw new RuntimeIOException("Encountered non-file content inside bands directory.");
            }
            String curName = f.getName();
            try {
                bandNumber = Long.parseLong(curName, 16);
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeIOException("Encountered non-parseable filename in bands directory: \"" + curName + "\"");
            }
            if (bandNumber >= 0L && bandNumber <= this.bandCount - 1L) continue;
            throw new RuntimeException("Invalid band number: " + bandNumber);
        }
    }

    public long getSize() {
        return this.size;
    }

    public long getBandSize() {
        return this.bandSize;
    }

    public long getBandCount() {
        return this.bandCount;
    }

    Token getToken() {
        return this.token;
    }

    Band lookupBand(long bandNumber) throws RuntimeIOException {
        long curBandSize;
        FileLock bandLock;
        RandomAccessFile bandRaf;
        String bandFilename = Long.toHexString(bandNumber);
        File bandFile = new File(this.bandsDir, bandFilename);
        if (!bandFile.exists()) {
            return null;
        }
        try {
            bandRaf = new RandomAccessFile(bandFile, "r");
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeIOException("Failed to open '" + bandFilename + "' for reading.", (IOException)ex);
        }
        try {
            bandLock = bandRaf.getChannel().lock(0L, Long.MAX_VALUE, true);
        }
        catch (IOException ex) {
            throw new RuntimeIOException("Failed to aquire a shared lock on '" + bandFilename + "'.", ex);
        }
        try {
            curBandSize = bandRaf.length();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Exception while querying band file length.", ioe);
        }
        if (curBandSize > this.bandSize) {
            throw new RuntimeIOException("Invalid band: Size (" + curBandSize + ") is larger than bandSize (" + this.bandSize + ").");
        }
        try {
            return new Band(bandRaf, bandLock, this.bandSize);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Exception while creating Band instance.", ioe);
        }
    }

    void close() {
        this.mainInfo.close();
        this.backupInfo.close();
        this.token.close();
    }
}

