/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.sparsebundle;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.catacombae.dmg.sparsebundle.Band;
import org.catacombae.dmg.sparsebundle.SparseBundle;
import org.catacombae.dmg.sparsebundle.Token;
import org.catacombae.io.BasicReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableSparseBundleStream
extends BasicReadableRandomAccessStream {
    private final SparseBundle bundle;
    private long pos = 0L;
    private long bandNumber = 0L;
    private Band band = null;

    public ReadableSparseBundleStream(File sparseBundleDir) {
        this(new SparseBundle(sparseBundleDir));
    }

    ReadableSparseBundleStream(SparseBundle bundle) {
        this.bundle = bundle;
    }

    public long getBandSize() {
        return this.bundle.getBandSize();
    }

    public void close() throws RuntimeIOException {
        if (this.band != null) {
            this.band.close();
        }
        this.bundle.close();
    }

    public void seek(long pos) throws RuntimeIOException {
        this.pos = pos;
    }

    public long length() throws RuntimeIOException {
        return this.bundle.getToken().getSize() + this.bundle.getSize();
    }

    public long getFilePointer() throws RuntimeIOException {
        return this.pos;
    }

    public int read(byte[] data, int off, int len) throws RuntimeIOException {
        return this.read(data, off, len, null);
    }

    public int read(byte[] data, LinkedList<Util.Pair<Long, Long>> holeList) {
        return this.read(data, 0, data.length, holeList);
    }

    public int read(byte[] data, int off, int len, LinkedList<Util.Pair<Long, Long>> holeList) throws RuntimeIOException {
        int remainingSize;
        int bytesRead;
        if (data == null) {
            throw new IllegalArgumentException("data is null.");
        }
        if (off < 0 || off > data.length) {
            throw new IllegalArgumentException("pos out of range.");
        }
        if (len < 0 || len > data.length - off) {
            throw new IllegalArgumentException("len out of range.");
        }
        Token token = this.bundle.getToken();
        long tokenSize = token.getSize();
        if (tokenSize < 0L) {
            throw new RuntimeException("Internal error: token size (" + tokenSize + ") < 0");
        }
        long bundleSize = tokenSize + this.bundle.getSize();
        if (this.pos >= bundleSize) {
            return -1;
        }
        long bytesRemainingInStream = bundleSize - this.pos;
        int readSize = (long)len > bytesRemainingInStream ? (int)bytesRemainingInStream : len;
        long bandSize = this.bundle.getBandSize();
        long curHoleStart = 0L;
        long curHoleLength = 0L;
        int curOff = off;
        for (remainingSize = readSize; remainingSize > 0; remainingSize -= bytesRead) {
            long bandHoleLength;
            long bandHoleStart;
            int bytesToRead;
            if (this.pos < tokenSize) {
                bytesToRead = tokenSize < (long)len ? (int)tokenSize : len;
                try {
                    bytesRead = token.read(this.pos, data, curOff, len);
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Exception while reading from token.", e);
                }
            }
            long posInData = this.pos - tokenSize;
            long curBandNumber = posInData / bandSize;
            long posInBand = posInData % bandSize;
            if (this.band == null) {
                this.band = this.bundle.lookupBand(curBandNumber);
            } else if (curBandNumber != this.bandNumber) {
                this.band.close();
                this.band = this.bundle.lookupBand(curBandNumber);
            }
            this.bandNumber = curBandNumber;
            long remainingInBand = bandSize - posInBand;
            bytesToRead = (long)remainingSize > remainingInBand ? (int)remainingInBand : remainingSize;
            if (this.band == null) {
                Arrays.fill(data, curOff, curOff + bytesToRead, (byte)0);
                bytesRead = bytesToRead;
                bandHoleStart = curOff;
                bandHoleLength = bytesRead;
            } else {
                try {
                    bytesRead = this.band.read(posInBand, data, curOff, bytesToRead);
                }
                catch (IOException ex) {
                    throw new RuntimeIOException("Exception while reading from band " + this.bandNumber + ".", ex);
                }
                if (bytesRead < 0) {
                    if (bytesRead == -1) break;
                    throw new RuntimeException("Unexpected return value from Band.read: " + bytesRead);
                }
                bandHoleStart = 0L;
                bandHoleLength = 0L;
            }
            if (holeList != null) {
                if (curHoleLength != 0L) {
                    if (bandHoleLength != 0L && curHoleStart + curHoleLength == bandHoleStart) {
                        curHoleLength += bandHoleLength;
                    } else {
                        holeList.add((Util.Pair<Long, Long>)new Util.Pair((Object)curHoleStart, (Object)curHoleLength));
                        if (bandHoleLength != 0L) {
                            curHoleStart = bandHoleStart;
                            curHoleLength = bandHoleLength;
                        }
                    }
                } else if (bandHoleLength != 0L) {
                    curHoleStart = bandHoleStart;
                    curHoleLength = bandHoleLength;
                }
            }
            curOff += bytesRead;
            this.pos += (long)bytesRead;
            if (bytesRead == bytesToRead) continue;
            break;
        }
        if (holeList != null && curHoleLength != 0L) {
            holeList.add((Util.Pair<Long, Long>)new Util.Pair((Object)curHoleStart, (Object)curHoleLength));
        }
        return readSize - remainingSize;
    }
}

