/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.sparsebundle;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileLock;
import org.catacombae.dmg.sparsebundle.BundleMember;
import org.catacombae.plist.PlistNode;
import org.catacombae.plist.XmlPlist;
import org.catacombae.util.Util;

class Info
extends BundleMember {
    private long bandSize;
    private long size;

    public Info(RandomAccessFile plistFile, FileLock plistFileLock) throws IOException {
        super(plistFile, plistFileLock);
        this.refresh();
    }

    public long getBandSize() {
        return this.bandSize;
    }

    public long getSize() {
        return this.size;
    }

    protected void refresh() throws IOException {
        long sizeLong;
        long bandSizeLong;
        long fileLength = this.file.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("Info.plist is unreasonably large and doesn't fit in memory.");
        }
        byte[] plistData = new byte[(int)fileLength];
        int bytesRead = this.file.read(plistData);
        if ((long)bytesRead != fileLength) {
            throw new IOException("Failed to read entire file. Read " + bytesRead + "/" + fileLength + " bytes.");
        }
        XmlPlist plist = new XmlPlist(plistData, true);
        PlistNode dictNode = plist.getRootNode().cd("dict");
        if (dictNode == null) {
            throw new IOException("Malformed Info.plist file: No 'dict' element at root.");
        }
        String cfBundleInfoDictionaryVersionKey = "CFBundleInfoDictionaryVersion";
        String bandSizeKey = "band-size";
        String bundleBackingstoreVersionKey = "bundle-backingstore-version";
        String diskImageBundleTypeKey = "diskimage-bundle-type";
        String sizeKey = "size";
        Reader cfBundleInfoDictionaryVersionReader = dictNode.getKeyValue("CFBundleInfoDictionaryVersion");
        Reader bandSizeReader = dictNode.getKeyValue("band-size");
        Reader bundleBackingstoreVersionReader = dictNode.getKeyValue("bundle-backingstore-version");
        Reader diskImageBundleTypeReader = dictNode.getKeyValue("diskimage-bundle-type");
        Reader sizeReader = dictNode.getKeyValue("size");
        if (cfBundleInfoDictionaryVersionReader == null) {
            throw new IOException("Could not find 'CFBundleInfoDictionaryVersion' key in Info.plist file.");
        }
        if (bandSizeReader == null) {
            throw new IOException("Could not find 'band-size' key in Info.plist file.");
        }
        if (bundleBackingstoreVersionReader == null) {
            throw new IOException("Could not find 'bundle-backingstore-version' key in Info.plist file.");
        }
        if (diskImageBundleTypeReader == null) {
            throw new IOException("Could not find 'diskimage-bundle-type' key in Info.plist file.");
        }
        if (sizeReader == null) {
            throw new IOException("Could not find 'size' key in Info.plist file.");
        }
        String bandSizeString = Util.readFully((Reader)bandSizeReader);
        String bundleBackingstoreVersionString = Util.readFully((Reader)bundleBackingstoreVersionReader);
        String diskImageBundleTypeString = Util.readFully((Reader)diskImageBundleTypeReader);
        String sizeString = Util.readFully((Reader)sizeReader);
        if (!diskImageBundleTypeString.equals("com.apple.diskimage.sparsebundle")) {
            throw new IOException("Unexpected value for 'diskimage-bundle-type': " + diskImageBundleTypeString);
        }
        if (!bundleBackingstoreVersionString.equals("1")) {
            throw new IOException("Unknown backing store version: " + bundleBackingstoreVersionString);
        }
        try {
            bandSizeLong = Long.parseLong(bandSizeString);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Illegal numeric value for band-size: " + bandSizeString);
        }
        try {
            sizeLong = Long.parseLong(sizeString);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Illegal numeric value for size: " + sizeString);
        }
        this.bandSize = bandSizeLong;
        this.size = sizeLong;
    }
}

