/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.sparsebundle;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Arrays;
import org.catacombae.dmg.sparsebundle.BundleMember;

class Band
extends BundleMember {
    private final long bandActualSize;
    private final long bandVirtualSize;

    public Band(RandomAccessFile tokenFile, FileLock tokenFileLock, long bandSize) throws IOException {
        super(tokenFile, tokenFileLock);
        this.bandVirtualSize = bandSize;
        try {
            this.bandActualSize = tokenFile.length();
        }
        catch (IOException ex) {
            super.close();
            throw ex;
        }
    }

    public int read(long offset, byte[] dest, int destOffset, int destLength) throws IOException {
        long remainingActualBytes;
        if (offset < 0L) {
            throw new IllegalArgumentException("negative offset.");
        }
        if (dest == null) {
            throw new IllegalArgumentException("dest is null.");
        }
        if (destOffset < 0 || destOffset > dest.length) {
            throw new IllegalArgumentException("destOffset out of range.");
        }
        if (destLength < 0 || destLength > dest.length - destOffset) {
            throw new IllegalArgumentException("destLength out of range.");
        }
        if (offset >= this.bandVirtualSize) {
            return -1;
        }
        int readLength = (long)destLength > this.bandVirtualSize - offset ? (int)(this.bandVirtualSize - offset) : destLength;
        int actualLength = offset >= this.bandActualSize ? 0 : ((long)readLength > (remainingActualBytes = this.bandActualSize - offset) ? (int)remainingActualBytes : readLength);
        this.file.seek(offset);
        int bytesRead = this.file.read(dest, destOffset, actualLength);
        if (bytesRead != actualLength) {
            return bytesRead;
        }
        if (actualLength != readLength) {
            Arrays.fill(dest, destOffset + actualLength, destOffset + readLength, (byte)0);
        }
        return readLength;
    }
}

