/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.util;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class IOUtil {
    public static byte[] readFully(ReadableRandomAccessStream s) throws RuntimeIOException {
        if (s.length() < 0L || s.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length of s is out of range: " + s.length());
        }
        return IOUtil.readFully(s, null, (int)s.length());
    }

    public static byte[] readFully(ReadableRandomAccessStream s, long offset, int length) throws RuntimeIOException {
        return IOUtil.readFully(s, (Long)offset, length);
    }

    private static byte[] readFully(ReadableRandomAccessStream s, Long offset, int length) throws RuntimeIOException {
        long trueOffset = offset == null ? s.getFilePointer() : offset.longValue();
        if ((long)length > s.length()) {
            throw new IllegalArgumentException("'length' is unreasonably large: " + length);
        }
        if (s.length() - (long)length < trueOffset) {
            throw new IllegalArgumentException("Offset out of range: " + trueOffset + "(length: " + s.length() + ")");
        }
        byte[] res = new byte[length];
        if (offset != null) {
            s.seek(trueOffset);
        }
        s.readFully(res);
        return res;
    }
}

