/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

import java.util.HashMap;
import org.catacombae.io.BasicSynchronizedReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.io.SynchronizedReadableRandomAccess;
import org.catacombae.util.Util;

public class SynchronizedReadableRandomAccessStream
extends BasicSynchronizedReadableRandomAccessStream
implements SynchronizedReadableRandomAccess {
    private static final boolean DEBUG = Util.booleanEnabledByProperties(false, "org.catacombae.debug", "org.catacombae.io.debug", "org.catacombae.io." + SynchronizedReadableRandomAccessStream.class.getSimpleName() + ".debug");
    private static final boolean REFERENCES_DEBUG = Util.booleanEnabledByProperties(DEBUG, "org.catacombae.io." + SynchronizedReadableRandomAccessStream.class.getSimpleName() + ".references_debug");
    private ReadableRandomAccessStream ras;
    private long refCount;
    private boolean closed = false;
    private HashMap<Object, Reference> references = REFERENCES_DEBUG ? new HashMap() : null;

    public SynchronizedReadableRandomAccessStream(ReadableRandomAccessStream sourceStream) {
        this.ras = sourceStream;
        this.refCount = 1L;
        if (REFERENCES_DEBUG) {
            this.references.put(this, new Reference(this, new Exception().getStackTrace()));
        }
    }

    public ReadableRandomAccessStream getSourceStream() {
        return this.ras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int readFrom(long pos, byte[] b, int off, int len) throws RuntimeIOException {
        int res;
        if (DEBUG) {
            System.err.println("SynchronizedReadableRandomAccessStream.readFrom(" + pos + ", byte[" + b.length + "], " + off + ", " + len + ");");
        }
        long oldFP = this.getFilePointer();
        if (DEBUG) {
            System.err.println("  oldFP=" + oldFP);
        }
        if (oldFP != pos) {
            if (DEBUG) {
                System.err.println("  seeking to " + pos + "...");
            }
            this.seek(pos);
        }
        try {
            if (DEBUG) {
                System.err.println("  Reading " + len + " bytes...");
            }
            res = this.read(b, off, len);
            if (DEBUG) {
                System.err.println("    read " + res + " bytes.");
            }
        }
        finally {
            if (DEBUG) {
                System.err.println("  seeking to " + oldFP + "...");
            }
            this.seek(oldFP);
        }
        if (DEBUG) {
            System.err.println("  returning " + res + ".");
        }
        return res;
    }

    public synchronized long skipFrom(long pos, long length) throws RuntimeIOException {
        long newPos = pos + length;
        long streamLength = this.length();
        long res = newPos > streamLength ? streamLength - pos : length;
        return res;
    }

    public synchronized long remainingLength() throws RuntimeIOException {
        return this.length() - this.getFilePointer();
    }

    public synchronized void close() throws RuntimeIOException {
        if (DEBUG) {
            System.err.println(SynchronizedReadableRandomAccessStream.class.getName() + "@" + Util.toHexStringBE(this.hashCode()) + ".close(): Called " + "from " + new Exception().getStackTrace()[1] + ".");
        }
        if (this.closed) {
            throw new RuntimeException("Already closed.");
        }
        if (REFERENCES_DEBUG && this.references.remove(this) == null) {
            throw new RuntimeException("Own reference not found!");
        }
        --this.refCount;
        this.tryCloseSource();
        this.closed = true;
    }

    private void tryCloseSource() {
        if (this.refCount == 0L) {
            this.ras.close();
        }
    }

    public synchronized long getFilePointer() throws RuntimeIOException {
        return this.ras.getFilePointer();
    }

    public synchronized long length() throws RuntimeIOException {
        return this.ras.length();
    }

    public synchronized int read() throws RuntimeIOException {
        return this.ras.read();
    }

    public synchronized int read(byte[] b) throws RuntimeIOException {
        return this.ras.read(b);
    }

    public synchronized int read(byte[] b, int off, int len) throws RuntimeIOException {
        if (DEBUG) {
            System.err.println("SynchronizedReadableRandomAccessStream.read(byte[" + b.length + "], " + off + ", " + len + ");");
            System.err.println("  ras=" + this.ras);
        }
        return this.ras.read(b, off, len);
    }

    public synchronized void seek(long pos) throws RuntimeIOException {
        this.ras.seek(pos);
    }

    public synchronized void addReference(Object referrer) {
        if (DEBUG) {
            System.err.println(this + ": Reference added (" + this.refCount + " " + "-> " + (this.refCount + 1L) + ") by " + referrer + ".");
        }
        if (!this.closed) {
            if (REFERENCES_DEBUG) {
                if (this.references.get(referrer) != null) {
                    throw new RuntimeException("Only one reference per referrer is allowed.");
                }
                this.references.put(referrer, new Reference(referrer, new Exception().getStackTrace()));
            }
            ++this.refCount;
        } else {
            throw new RuntimeIOException("Stream is closed!");
        }
    }

    public synchronized void removeReference(Object referrer) {
        if (this.closed && this.refCount == 0L || !this.closed && this.refCount == 1L) {
            throw new RuntimeException("No references!");
        }
        if (DEBUG) {
            System.err.println(this + ": Reference removed (" + this.refCount + " " + "-> " + (this.refCount - 1L) + ") by " + referrer + ".");
        }
        if (REFERENCES_DEBUG && this.references.remove(referrer) == null) {
            throw new RuntimeException("Reference not found!");
        }
        --this.refCount;
        this.tryCloseSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalize() throws Throwable {
        try {
            if (this.refCount != 0L) {
                System.err.println("[WARNING] " + this + " is garbage " + "collected with " + this.refCount + " remaining references" + (REFERENCES_DEBUG ? ":" : "."));
                if (REFERENCES_DEBUG) {
                    for (Reference r : this.references.values()) {
                        System.err.println(r.referrer);
                        for (StackTraceElement ste : r.stackTrace) {
                            System.err.println("\t" + ste);
                        }
                    }
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    private class Reference {
        final Object referrer;
        final StackTraceElement[] stackTrace;

        public Reference(Object referrer, StackTraceElement[] stackTrace) {
            this.referrer = referrer;
            this.stackTrace = stackTrace;
        }
    }
}

