/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

import org.catacombae.io.BasicReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.io.SynchronizedReadableRandomAccess;
import org.catacombae.util.Util;

public class ReadableRandomAccessSubstream
extends BasicReadableRandomAccessStream {
    private static final boolean DEBUG = Util.booleanEnabledByProperties(false, "org.catacombae.debug", "org.catacombae.io.debug", "org.catacombae.io." + ReadableRandomAccessSubstream.class.getSimpleName() + ".debug");
    private SynchronizedReadableRandomAccess sourceStream;
    private long internalFP;
    private boolean closed = false;

    public ReadableRandomAccessSubstream(SynchronizedReadableRandomAccess iSourceStream) {
        this.sourceStream = iSourceStream;
        this.internalFP = 0L;
        this.sourceStream.addReference(this);
    }

    public synchronized void close() throws RuntimeIOException {
        if (this.closed) {
            throw new RuntimeException(this + " already closed!");
        }
        this.sourceStream.removeReference(this);
        this.closed = true;
    }

    public void seek(long pos) throws RuntimeIOException {
        this.internalFP = pos;
    }

    public long length() throws RuntimeIOException {
        return this.sourceStream.length();
    }

    public long getFilePointer() throws RuntimeIOException {
        return this.internalFP;
    }

    public int read(byte[] b, int pos, int len) throws RuntimeIOException {
        int bytesRead;
        if (DEBUG) {
            System.err.println("ReadableRandomAccessSubstream.read(byte[" + b.length + "], " + pos + ", " + len + ");");
            System.err.println("  readFrom: " + this.internalFP);
        }
        if ((bytesRead = this.sourceStream.readFrom(this.internalFP, b, pos, len)) > 0) {
            this.internalFP += (long)bytesRead;
            if (DEBUG) {
                System.err.println("  returning: " + bytesRead);
            }
            return bytesRead;
        }
        if (DEBUG) {
            System.err.println("  returning: -1");
        }
        return -1;
    }
}

