/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.catacombae.io.IOLog;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.util.Util;

public class ReadableFileStream
implements ReadableRandomAccessStream {
    private static final IOLog log = IOLog.getInstance();
    protected final RandomAccessFile raf;

    public ReadableFileStream(String filename) {
        this(new File(filename));
    }

    public ReadableFileStream(File file) {
        this(file, "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadableFileStream(RandomAccessFile raf) {
        if (ReadableFileStream.log.trace) {
            log.traceEnter(raf);
        }
        try {
            if (raf == null) {
                throw new IllegalArgumentException("raf may NOT be null");
            }
            this.raf = raf;
            if (!ReadableFileStream.log.trace) return;
        }
        catch (Throwable throwable) {
            if (!ReadableFileStream.log.trace) throw throwable;
            log.traceLeave(raf);
            throw throwable;
        }
        log.traceLeave(raf);
    }

    protected ReadableFileStream(String filename, String mode) {
        this(new File(filename), mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ReadableFileStream(File file, String mode) {
        if (ReadableFileStream.log.trace) {
            log.traceEnter(file, mode);
        }
        try {
            this.raf = new RandomAccessFile(file, mode);
            if (!ReadableFileStream.log.trace) return;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeIOException(ex);
            }
            catch (Throwable throwable) {
                if (!ReadableFileStream.log.trace) throw throwable;
                log.traceLeave(file, mode);
                throw throwable;
            }
        }
        log.traceLeave(file, mode);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void seek(long pos) {
        if (ReadableFileStream.log.trace) {
            log.traceEnter(pos);
        }
        try {
            this.raf.seek(pos);
            if (!ReadableFileStream.log.trace) return;
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeIOException("pos=" + pos + "," + ioe.toString(), ioe);
            }
            catch (Throwable throwable) {
                if (!ReadableFileStream.log.trace) throw throwable;
                log.traceLeave(pos);
                throw throwable;
            }
        }
        log.traceLeave(pos);
        return;
    }

    public int read() {
        if (ReadableFileStream.log.trace) {
            log.traceEnter(new Object[0]);
        }
        try {
            int res = this.raf.read();
            if (ReadableFileStream.log.trace) {
                log.traceReturn(res);
            }
            int n = res;
            return n;
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
        finally {
            if (ReadableFileStream.log.trace) {
                log.traceLeave(new Object[0]);
            }
        }
    }

    public int read(byte[] data) {
        int n;
        block7: {
            if (ReadableFileStream.log.trace) {
                log.traceEnter(new Object[]{data});
            }
            try {
                int res = this.raf.read(data);
                if (ReadableFileStream.log.trace) {
                    log.traceReturn(res);
                }
                n = res;
                if (!ReadableFileStream.log.trace) break block7;
            }
            catch (IOException ex) {
                try {
                    throw new RuntimeIOException(ex);
                }
                catch (Throwable throwable) {
                    if (ReadableFileStream.log.trace) {
                        log.traceLeave(new Object[]{data});
                    }
                    throw throwable;
                }
            }
            log.traceLeave(new Object[]{data});
        }
        return n;
    }

    public int read(byte[] data, int pos, int len) {
        int n;
        block7: {
            if (ReadableFileStream.log.trace) {
                log.traceEnter(data, pos, len);
            }
            try {
                int res = this.raf.read(data, pos, len);
                if (ReadableFileStream.log.trace) {
                    log.traceReturn(res);
                }
                n = res;
                if (!ReadableFileStream.log.trace) break block7;
            }
            catch (IOException ex) {
                try {
                    throw new RuntimeIOException(ex);
                }
                catch (Throwable throwable) {
                    if (ReadableFileStream.log.trace) {
                        log.traceLeave(data, pos, len);
                    }
                    throw throwable;
                }
            }
            log.traceLeave(data, pos, len);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFully(byte[] data) {
        if (ReadableFileStream.log.trace) {
            log.traceEnter(new Object[]{data});
        }
        try {
            this.raf.readFully(data);
            if (!ReadableFileStream.log.trace) return;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeIOException(ex);
            }
            catch (Throwable throwable) {
                if (!ReadableFileStream.log.trace) throw throwable;
                log.traceLeave(new Object[]{data});
                throw throwable;
            }
        }
        log.traceLeave(new Object[]{data});
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFully(byte[] data, int offset, int length) {
        if (ReadableFileStream.log.trace) {
            log.traceEnter(data, offset, length);
        }
        try {
            this.raf.readFully(data, offset, length);
            if (!ReadableFileStream.log.trace) return;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeIOException(ex);
            }
            catch (Throwable throwable) {
                if (!ReadableFileStream.log.trace) throw throwable;
                log.traceLeave(data, offset, length);
                throw throwable;
            }
        }
        log.traceLeave(data, offset, length);
        return;
    }

    public long length() {
        if (ReadableFileStream.log.trace) {
            log.traceEnter(new Object[0]);
        }
        try {
            long l = this.raf.length();
            return l;
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
        finally {
            if (ReadableFileStream.log.trace) {
                log.traceLeave(new Object[0]);
            }
        }
    }

    public long getFilePointer() {
        if (ReadableFileStream.log.trace) {
            log.traceEnter(new Object[0]);
        }
        try {
            long res = this.raf.getFilePointer();
            if (ReadableFileStream.log.trace) {
                log.traceReturn(res);
            }
            long l = res;
            return l;
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
        finally {
            if (ReadableFileStream.log.trace) {
                log.traceLeave(new Object[0]);
            }
        }
    }

    public void close() {
        if (ReadableFileStream.log.trace) {
            log.traceEnter(new Object[0]);
        }
        try {
            this.raf.close();
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
        finally {
            if (ReadableFileStream.log.trace) {
                log.traceLeave(new Object[0]);
            }
        }
    }

    static {
        ReadableFileStream.log.debug = Util.booleanEnabledByProperties(ReadableFileStream.log.debug, "org.catacombae.debug", "org.catacombae.io.debug", "org.catacombae.io." + ReadableFileStream.class.getSimpleName() + ".debug");
        ReadableFileStream.log.trace = Util.booleanEnabledByProperties(ReadableFileStream.log.trace, "org.catacombae.debug", "org.catacombae.io.debug", "org.catacombae.io." + ReadableFileStream.class.getSimpleName() + ".trace");
    }
}

