/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

class IOLog {
    public static boolean defaultTrace = false;
    public static boolean defaultDebug = false;
    public boolean trace = defaultTrace;
    public boolean debug = defaultDebug;

    private IOLog() {
    }

    public void debug(String message) {
        if (this.debug) {
            System.err.println("DEBUG: " + message);
        }
    }

    public void trace(String msg) {
        if (this.trace) {
            System.err.println("TRACE: " + msg);
        }
    }

    public void traceEnter(Object ... args) {
        if (this.trace) {
            StackTraceElement ste = Thread.currentThread().getStackTrace()[2];
            String className = ste.getClass().getSimpleName();
            String methodName = ste.getMethodName();
            StringBuilder sb = new StringBuilder("ENTER: ");
            sb.append(className);
            if (methodName != null) {
                sb.append(".").append(methodName);
            }
            sb.append("(");
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(args[i]);
            }
            sb.append(")");
            System.err.println(sb.toString());
        }
    }

    public void traceLeave(Object ... args) {
        if (this.trace) {
            StackTraceElement ste = Thread.currentThread().getStackTrace()[2];
            String className = ste.getClass().getSimpleName();
            String methodName = ste.getMethodName();
            StringBuilder sb = new StringBuilder("LEAVE: ");
            sb.append(className);
            if (methodName != null) {
                sb.append(".").append(methodName);
            }
            sb.append("(");
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(args[i]);
            }
            sb.append(")");
            System.err.println(sb.toString());
        }
    }

    public void traceReturn(Object retval) {
        if (this.trace) {
            System.err.println("RETURN: " + retval);
        }
    }

    public static IOLog getInstance() {
        return new IOLog();
    }
}

