/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

import org.catacombae.io.BasicConcatenatedStream;
import org.catacombae.io.BasicWritable;
import org.catacombae.io.RandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatenatedStream
extends BasicConcatenatedStream<RandomAccessStream>
implements RandomAccessStream {
    public ConcatenatedStream(RandomAccessStream firstPart, long startOffset, long length) {
        super(firstPart, startOffset, length);
    }

    @Override
    public void write(byte[] data) throws RuntimeIOException {
        BasicWritable.defaultWrite((Writable)this, data);
    }

    @Override
    public void write(byte[] data, int off, int len) throws RuntimeIOException {
        int bytesWritten = 0;
        long bytesToSkip = this.virtualFP;
        int requestedPartIndex = -1;
        for (BasicConcatenatedStream.Part p : this.parts) {
            ++requestedPartIndex;
            if (bytesToSkip <= p.length) break;
            bytesToSkip -= p.length;
        }
        if (requestedPartIndex == -1) {
            throw new RuntimeIOException("Tried to write beyond end of file.");
        }
        while (bytesWritten < len && requestedPartIndex < this.parts.size()) {
            BasicConcatenatedStream.Part requestedPart = (BasicConcatenatedStream.Part)this.parts.get(requestedPartIndex++);
            long bytesToSkipInPart = bytesToSkip;
            bytesToSkip = 0L;
            int bytesLeftToWrite = len - bytesWritten;
            int bytesToWrite = (int)((long)bytesLeftToWrite < requestedPart.length ? (long)bytesLeftToWrite : requestedPart.length);
            ((RandomAccessStream)requestedPart.file).seek(bytesToSkipInPart);
            ((RandomAccessStream)requestedPart.file).write(data, off + bytesWritten, bytesToWrite);
            bytesWritten += bytesToWrite;
        }
        if (bytesWritten < len) {
            throw new RuntimeIOException("Could not write all data requested (wrote: " + bytesWritten + " requested:" + len + ".");
        }
        if (bytesWritten > len) {
            throw new RuntimeException("Wrote more than I was supposed to (" + bytesWritten + " / " + len + " bytes)! This can't happen.");
        }
    }

    @Override
    public void write(int data) throws RuntimeIOException {
        BasicWritable.defaultWrite((Writable)this, data);
    }
}

