/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.mbr.types;

import java.io.PrintStream;
import java.util.LinkedList;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.io.ReadableByteArrayStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.ebr.types.DOSExtendedPartitionSystem;
import org.catacombae.storage.ps.legacy.PartitionSystem;
import org.catacombae.storage.ps.mbr.MBRPartitionType;
import org.catacombae.storage.ps.mbr.types.MBRPartition;
import org.catacombae.storage.ps.mbr.types.MasterBootRecord;

public class MBRPartitionTable
implements PartitionSystem,
PrintableStruct {
    public static final int DEFAULT_SECTOR_SIZE = 512;
    private final MasterBootRecord masterBootRecord;
    private final PartitionSystem[] embeddedPartitionSystems;

    public MBRPartitionTable(byte[] data, int offset) {
        this((ReadableRandomAccessStream)new ReadableByteArrayStream(data), offset, false);
    }

    public MBRPartitionTable(byte[] data, int offset, int sectorSize) {
        this(new ReadableByteArrayStream(data), offset, sectorSize, false);
    }

    public MBRPartitionTable(ReadableRandomAccessStream raf, int offset) {
        this(raf, offset, true);
    }

    public MBRPartitionTable(ReadableRandomAccessStream raf, int offset, boolean parseEmbeddedPartitionSystems) {
        this(raf, offset, 512, parseEmbeddedPartitionSystems);
    }

    public MBRPartitionTable(ReadableRandomAccessStream raf, int offset, int sectorSize) {
        this(raf, offset, sectorSize, true);
    }

    public MBRPartitionTable(ReadableRandomAccessStream raf, int offset, int sectorSize, boolean parseEmbeddedPartitionSystems) {
        byte[] block = new byte[sectorSize];
        raf.seek(offset);
        raf.readFully(block);
        this.masterBootRecord = new MasterBootRecord(block, 0, sectorSize);
        MBRPartition[] mbrPartitions = this.masterBootRecord.getPartitions();
        this.embeddedPartitionSystems = new PartitionSystem[mbrPartitions.length];
        for (int i = 0; i < mbrPartitions.length; ++i) {
            MBRPartition p = mbrPartitions[i];
            DOSExtendedPartitionSystem embeddedPS = null;
            if (parseEmbeddedPartitionSystems && (p.getPartitionTypeAsEnum() == MBRPartitionType.DOS_EXTENDED || p.getPartitionTypeAsEnum() == MBRPartitionType.DOS_EXTENDED_INT13HX)) {
                try {
                    embeddedPS = new DOSExtendedPartitionSystem(raf, p.getStartOffset(), p.getLength(), sectorSize);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.embeddedPartitionSystems[i] = embeddedPS;
        }
    }

    public MasterBootRecord getMasterBootRecord() {
        return this.masterBootRecord;
    }

    public PartitionSystem[] getEmbeddedPartitionSystems() {
        PartitionSystem[] result = new PartitionSystem[this.embeddedPartitionSystems.length];
        System.arraycopy(this.embeddedPartitionSystems, 0, result, 0, result.length);
        return result;
    }

    public PartitionSystem getEmbeddedPartitionSystem(int index) {
        return this.embeddedPartitionSystems[index];
    }

    public boolean isValid() {
        if (this.masterBootRecord.isValid()) {
            for (PartitionSystem ebr : this.embeddedPartitionSystems) {
                if (ebr == null || ebr.isValid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getPartitionCount() {
        int num = this.masterBootRecord.getPartitionCount();
        for (PartitionSystem ps : this.embeddedPartitionSystems) {
            if (ps == null) continue;
            num += ps.getPartitionCount();
        }
        return num;
    }

    public int getUsedPartitionCount() {
        int num = this.masterBootRecord.getUsedPartitionCount();
        for (PartitionSystem ps : this.embeddedPartitionSystems) {
            if (ps == null) continue;
            num += ps.getUsedPartitionCount();
        }
        return num;
    }

    public Partition[] getUsedPartitionEntries() {
        LinkedList<Partition> tempList = new LinkedList<Partition>();
        for (MBRPartition p : this.masterBootRecord.getUsedPartitionEntries()) {
            tempList.addLast(p);
        }
        for (PartitionSystem ps : this.embeddedPartitionSystems) {
            if (ps == null) continue;
            for (Partition p : ps.getUsedPartitionEntries()) {
                tempList.addLast(p);
            }
        }
        return tempList.toArray(new Partition[tempList.size()]);
    }

    public Partition getPartitionEntry(int index) {
        if (index >= 0 && index < 4) {
            return this.masterBootRecord.getPartitionEntry(index);
        }
        if (index >= 4) {
            int curIndex = 4;
            for (PartitionSystem ps : this.embeddedPartitionSystems) {
                int psPartitions = ps.getPartitionCount();
                if (index < curIndex + psPartitions) {
                    return ps.getPartitionEntry(index - curIndex);
                }
                curIndex += psPartitions;
            }
        }
        throw new IllegalArgumentException("index out of bounds (index=" + index + ")");
    }

    public Partition[] getPartitionEntries() {
        LinkedList<Partition> tempList = new LinkedList<Partition>();
        for (MBRPartition p : this.masterBootRecord.getPartitionEntries()) {
            tempList.addLast(p);
        }
        for (PartitionSystem ps : this.embeddedPartitionSystems) {
            if (ps == null) continue;
            for (Partition p : ps.getPartitionEntries()) {
                tempList.addLast(p);
            }
        }
        return tempList.toArray(new Partition[tempList.size()]);
    }

    public String getLongName() {
        return "Master Boot Record";
    }

    public String getShortName() {
        return "MBR";
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " masterBootRecord:");
        this.masterBootRecord.print(ps, prefix + "  ");
        ps.println(prefix + " embeddedPartitionSystems:");
        for (int i = 0; i < this.embeddedPartitionSystems.length; ++i) {
            PartitionSystem partSys = this.embeddedPartitionSystems[i];
            ps.print(prefix + "  [" + i + "]:");
            if (partSys == null) {
                ps.println(" null");
                continue;
            }
            ps.println();
            partSys.print(ps, prefix + "   ");
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix);
    }
}

