/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.mbr;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.io.DataLocator;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.PartitionSystemHandler;
import org.catacombae.storage.ps.mbr.types.MBRPartitionTable;

public class MBRHandler
extends PartitionSystemHandler {
    private DataLocator partitionData;

    public MBRHandler(DataLocator partitionData) {
        this.partitionData = partitionData;
    }

    public long getPartitionCount() {
        MBRPartitionTable apm = this.readPartitionTable();
        return apm.getUsedPartitionCount();
    }

    public Partition[] getPartitions() {
        MBRPartitionTable partitionTable = this.readPartitionTable();
        return partitionTable.getUsedPartitionEntries();
    }

    public void close() {
        this.partitionData.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBRPartitionTable readPartitionTable() {
        ReadableRandomAccessStream llf = null;
        try {
            llf = this.partitionData.createReadOnlyFile();
            byte[] firstBlock = new byte[512];
            llf.readFully(firstBlock);
            MBRPartitionTable mbt = new MBRPartitionTable(firstBlock, 0);
            if (mbt.isValid()) {
                MBRPartitionTable mBRPartitionTable = mbt;
                return mBRPartitionTable;
            }
            MBRPartitionTable mBRPartitionTable = null;
            return mBRPartitionTable;
        }
        finally {
            if (llf != null) {
                llf.close();
            }
        }
    }
}

