/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.gpt.types;

import java.io.PrintStream;
import org.catacombae.storage.ps.gpt.types.GPTEntry;
import org.catacombae.storage.ps.gpt.types.MutableGUID;
import org.catacombae.util.Util;

public class MutableGPTEntry
extends GPTEntry {
    private final MutableGUID mutablePartitionTypeGUID;
    private final MutableGUID mutableUniquePartitionGUID;

    public MutableGPTEntry(int blockSize) {
        super(blockSize, new MutableGUID(), new MutableGUID());
        this.mutablePartitionTypeGUID = (MutableGUID)this.partitionTypeGUID;
        this.mutableUniquePartitionGUID = (MutableGUID)this.uniquePartitionGUID;
    }

    public MutableGPTEntry(GPTEntry source) {
        super(source.blockSize, new MutableGUID(source.partitionTypeGUID), new MutableGUID(source.uniquePartitionGUID));
        this.mutablePartitionTypeGUID = (MutableGUID)this.partitionTypeGUID;
        this.mutableUniquePartitionGUID = (MutableGUID)this.uniquePartitionGUID;
    }

    public MutableGUID getMutablePartitionTypeGUID() {
        return this.mutablePartitionTypeGUID;
    }

    public MutableGUID getMutableUniquePartitionGUID() {
        return this.mutableUniquePartitionGUID;
    }

    public void setStartingLBA(long i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.startingLBA);
    }

    public void setEndingLBA(long i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.endingLBA);
    }

    public void setAttributeBits(long i) {
        Util.arrayCopy(Util.toByteArrayBE(i), this.attributeBits);
    }

    public void setPartitionName(byte[] data, int off) {
        MutableGPTEntry.copyData(data, off, this.partitionName);
    }

    public void setFields(GPTEntry gptEntry) {
        super.copyFields(gptEntry);
    }

    private static void copyData(byte[] data, int off, byte[] dest) {
        MutableGPTEntry.copyData(data, off, dest, dest.length);
    }

    private static void copyData(byte[] data, int off, byte[] dest, int len) {
        if (off + len > data.length) {
            throw new IllegalArgumentException("Length of input data must be " + len + ".");
        }
        System.arraycopy(data, off, dest, 0, len);
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "MutableGPTEntry:");
        this.printFields(ps, prefix);
    }
}

