/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.gpt.types;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.zip.CRC32;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.ArrayBuilder;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.gpt.types.GPTEntry;
import org.catacombae.storage.ps.gpt.types.GPTHeader;
import org.catacombae.storage.ps.legacy.PartitionSystem;
import org.catacombae.util.Util;

public class GUIDPartitionTable
implements PartitionSystem,
StructElements {
    protected final int blockSize;
    protected GPTHeader header;
    protected GPTEntry[] entries;
    protected GPTEntry[] backupEntries;
    protected GPTHeader backupHeader;

    public GUIDPartitionTable(ReadableRandomAccessStream llf, int offset) {
        byte[] blockBuffer;
        RuntimeIOException mostRecentException = null;
        int curBlockSize = 512;
        do {
            blockBuffer = new byte[curBlockSize];
            try {
                llf.seek(offset + curBlockSize);
                llf.readFully(blockBuffer);
                this.header = new GPTHeader(blockBuffer, 0, curBlockSize);
            }
            catch (RuntimeIOException ex) {
                mostRecentException = ex;
                this.header = null;
            }
        } while ((this.header == null || this.header.getSignature() != 4991757640121012820L) && (curBlockSize *= 2) <= 4096);
        if (this.header == null) {
            throw mostRecentException;
        }
        if (this.header.isValid()) {
            GPTEntry[] tBackupEntries;
            GPTHeader tBackupHeader;
            this.blockSize = curBlockSize;
            llf.seek((long)offset + this.header.getPartitionEntryLBA() * (long)this.blockSize);
            this.entries = new GPTEntry[this.header.getNumberOfPartitionEntries()];
            int i = 0;
            while (i < this.entries.length) {
                llf.readFully(blockBuffer);
                for (int offsetInBuffer = 0; i < this.entries.length && offsetInBuffer < blockBuffer.length; offsetInBuffer += 128, ++i) {
                    this.entries[i] = new GPTEntry(blockBuffer, offsetInBuffer, this.blockSize);
                }
            }
            try {
                llf.seek((long)offset + (long)this.blockSize * this.header.getBackupLBA());
                llf.readFully(blockBuffer);
                tBackupHeader = new GPTHeader(blockBuffer, 0, this.blockSize);
                if (tBackupHeader.isValid()) {
                    llf.seek((long)offset + tBackupHeader.getPartitionEntryLBA() * (long)this.blockSize);
                    tBackupEntries = new GPTEntry[tBackupHeader.getNumberOfPartitionEntries()];
                    int i2 = 0;
                    while (i2 < tBackupEntries.length) {
                        llf.readFully(blockBuffer);
                        for (int offsetInBuffer = 0; i2 < tBackupEntries.length && offsetInBuffer < blockBuffer.length; offsetInBuffer += 128, ++i2) {
                            tBackupEntries[i2] = new GPTEntry(blockBuffer, offsetInBuffer, this.blockSize);
                        }
                    }
                } else {
                    tBackupEntries = new GPTEntry[]{};
                }
            }
            catch (Exception e) {
                tBackupHeader = new GPTHeader(new byte[this.blockSize], 0, this.blockSize);
                tBackupEntries = new GPTEntry[]{};
            }
            this.backupHeader = tBackupHeader;
            this.backupEntries = tBackupEntries;
        } else {
            this.blockSize = 512;
            this.entries = new GPTEntry[0];
            this.backupHeader = new GPTHeader(new byte[this.blockSize], 0, this.blockSize);
            this.backupEntries = new GPTEntry[0];
        }
    }

    protected GUIDPartitionTable(GUIDPartitionTable source) {
        int i;
        this.blockSize = source.blockSize;
        this.header = new GPTHeader(source.header);
        this.entries = new GPTEntry[source.entries.length];
        for (i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new GPTEntry(source.entries[i]);
        }
        this.backupHeader = new GPTHeader(source.backupHeader);
        this.backupEntries = new GPTEntry[source.backupEntries.length];
        for (i = 0; i < this.backupEntries.length; ++i) {
            this.backupEntries[i] = new GPTEntry(source.backupEntries[i]);
        }
    }

    protected GUIDPartitionTable(int blockSize, GPTHeader header, GPTHeader backupHeader, int numberOfPrimaryEntries, int numberOfBackupEntries) {
        this.blockSize = blockSize;
        this.header = header;
        this.backupHeader = backupHeader;
        this.entries = new GPTEntry[numberOfPrimaryEntries];
        this.backupEntries = new GPTEntry[numberOfBackupEntries];
    }

    public GPTHeader getHeader() {
        return this.header;
    }

    public GPTHeader getBackupHeader() {
        return this.backupHeader;
    }

    public GPTEntry getEntry(int index) {
        return this.entries[index];
    }

    public GPTEntry[] getEntries() {
        return Util.arrayCopy(this.entries, new GPTEntry[this.entries.length]);
    }

    public GPTEntry getBackupEntry(int index) {
        return this.backupEntries[index];
    }

    public GPTEntry[] getBackupEntries() {
        return Util.arrayCopy(this.backupEntries, new GPTEntry[this.backupEntries.length]);
    }

    public int getPartitionCount() {
        return this.entries.length;
    }

    public GPTEntry[] getUsedEntries() {
        LinkedList<GPTEntry> tempList = new LinkedList<GPTEntry>();
        for (GPTEntry ge : this.entries) {
            if (!ge.isUsed()) continue;
            tempList.addLast(ge);
        }
        return tempList.toArray(new GPTEntry[tempList.size()]);
    }

    public int getUsedPartitionCount() {
        int count = 0;
        for (GPTEntry ge : this.entries) {
            if (!ge.isUsed()) continue;
            ++count;
        }
        return count;
    }

    public Partition getPartitionEntry(int index) {
        return this.getEntry(index);
    }

    public Partition[] getPartitionEntries() {
        return this.getEntries();
    }

    public Partition[] getUsedPartitionEntries() {
        return this.getUsedEntries();
    }

    public boolean isValid() {
        boolean primaryTableValid = this.header.isValid() && this.header.getCRC32Checksum() == this.calculatePrimaryHeaderChecksum() && this.header.getPartitionEntryArrayCRC32() == this.calculatePrimaryEntriesChecksum();
        boolean backupTableValid = this.backupHeader.isValid() && this.backupHeader.getCRC32Checksum() == this.calculateBackupHeaderChecksum() && this.backupHeader.getPartitionEntryArrayCRC32() == this.calculateBackupEntriesChecksum();
        boolean entryTablesEqual = true;
        if (this.backupEntries.length != this.entries.length) {
            entryTablesEqual = false;
        } else {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].equals(this.backupEntries[i])) continue;
                entryTablesEqual = false;
                break;
            }
        }
        boolean validBackupHeader = this.header.isValidBackup(this.backupHeader) && this.backupHeader.isValidBackup(this.header);
        return primaryTableValid && backupTableValid && entryTablesEqual && validBackupHeader;
    }

    public int calculatePrimaryHeaderChecksum() {
        return this.header.calculateCRC32();
    }

    public int calculatePrimaryEntriesChecksum() {
        CRC32 checksum = new CRC32();
        for (GPTEntry entry : this.entries) {
            checksum.update(entry.getBytes());
        }
        return (int)(checksum.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    public int calculateBackupHeaderChecksum() {
        return this.backupHeader.calculateCRC32();
    }

    public int calculateBackupEntriesChecksum() {
        CRC32 checksum = new CRC32();
        for (GPTEntry entry : this.backupEntries) {
            checksum.update(entry.getBytes());
        }
        return (int)(checksum.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    public String getLongName() {
        return "GUID Partition Table";
    }

    public String getShortName() {
        return "GPT";
    }

    public void printFields(PrintStream ps, String prefix) {
        this.printPrimaryFields(ps, prefix);
        this.printBackupFields(ps, prefix);
    }

    public void printPrimaryFields(PrintStream ps, String prefix) {
        ps.println(prefix + " header:");
        this.header.print(ps, prefix + "  ");
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.entries[i].isUsed()) continue;
            ps.println(prefix + " entries[" + i + "]:");
            this.entries[i].print(ps, prefix + "  ");
        }
    }

    public void printBackupFields(PrintStream ps, String prefix) {
        for (int i = 0; i < this.backupEntries.length; ++i) {
            if (!this.backupEntries[i].isUsed()) continue;
            ps.println(prefix + " backupEntries[" + i + "]:");
            this.backupEntries[i].print(ps, prefix + "  ");
        }
        ps.println(prefix + " backupHeader:");
        this.backupHeader.print(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "GUIDPartitionTable:");
        this.printFields(ps, prefix);
    }

    public long getPrimaryTableBytesOffset() {
        return this.blockSize;
    }

    public long getBackupTableBytesOffset() {
        return this.backupHeader.getPartitionEntryLBA() * (long)this.blockSize;
    }

    public byte[] getPrimaryTableBytes() {
        int offset = 0;
        byte[] result = new byte[this.header.occupiedSize() + GPTEntry.getSize() * this.entries.length];
        byte[] headerData = this.header.getBytes();
        System.arraycopy(headerData, 0, result, offset, this.header.occupiedSize());
        offset += this.header.occupiedSize();
        for (GPTEntry ge : this.entries) {
            byte[] entryData = ge.getBytes();
            System.arraycopy(entryData, 0, result, offset, entryData.length);
            offset += GPTEntry.getSize();
        }
        return result;
    }

    public byte[] getBackupTableBytes() {
        int offset = 0;
        byte[] result = new byte[GPTEntry.getSize() * this.entries.length + this.blockSize];
        for (GPTEntry ge : this.backupEntries) {
            byte[] entryData = ge.getBytes();
            System.arraycopy(entryData, 0, result, offset, entryData.length);
            offset += GPTEntry.getSize();
        }
        byte[] headerData = this.backupHeader.getBytes();
        System.arraycopy(headerData, 0, result, offset, this.blockSize);
        offset += this.blockSize;
        return result;
    }

    public Dictionary getStructElements() {
        GPTEntry ge;
        int i;
        StructElements.DictionaryBuilder dbStruct = new StructElements.DictionaryBuilder(this.getClass().getSimpleName());
        dbStruct.add("header", this.header.getStructElements());
        ArrayBuilder ab = new ArrayBuilder(GPTEntry.class.getSimpleName());
        for (i = 0; i < this.entries.length; ++i) {
            ge = this.entries[i];
            ab.add(ge.getStructElements());
        }
        dbStruct.add("entries", ab.getResult());
        dbStruct.add("backupHeader", this.backupHeader.getStructElements());
        ab = new ArrayBuilder(GPTEntry.class.getSimpleName());
        for (i = 0; i < this.backupEntries.length; ++i) {
            ge = this.backupEntries[i];
            ab.add(ge.getStructElements());
        }
        dbStruct.add("backupEntries", ab.getResult());
        return dbStruct.getResult();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GUIDPartitionTable) {
            GUIDPartitionTable gpt = (GUIDPartitionTable)obj;
            return Util.arraysEqual(this.getPrimaryTableBytes(), gpt.getPrimaryTableBytes()) && Util.arraysEqual(this.getBackupTableBytes(), gpt.getBackupTableBytes());
        }
        return false;
    }
}

