/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.gpt.types;

import java.lang.reflect.Field;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.storage.ps.gpt.types.GPTEntry;
import org.catacombae.util.Util;

public class GUID
implements StaticStruct,
StructElements {
    private int part1;
    private short part2;
    private short part3;
    private long part4;

    public GUID(byte[] data, int offset) {
        if (data.length - offset < 16) {
            throw new IllegalArgumentException("Not enough bytes for a GUID (need 16, got " + (data.length - offset) + ").");
        }
        this.copyBytesInternal(data, offset);
    }

    public GUID(GUID source) {
        this.copyFieldsInternal(source);
    }

    public GUID(byte[] data) {
        this(data, 0);
    }

    protected GUID() {
        this.part1 = 0;
        this.part2 = 0;
        this.part3 = 0;
        this.part4 = 0L;
    }

    private void copyFieldsInternal(GUID source) {
        this.part1 = source.part1;
        this.part2 = source.part2;
        this.part3 = source.part3;
        this.part4 = source.part4;
    }

    private void copyBytesInternal(byte[] data, int offset) {
        this.part1 = Util.readIntLE(data, offset + 0);
        this.part2 = Util.readShortLE(data, offset + 4);
        this.part3 = Util.readShortLE(data, offset + 6);
        this.part4 = Util.readLongBE(data, offset + 8);
    }

    protected void copyFields(GUID source) {
        this.copyFieldsInternal(source);
    }

    protected void copyBytes(byte[] data, int offset) {
        this.copyBytesInternal(data, offset);
    }

    public byte[] getBytes() {
        byte[] data = new byte[16];
        this.getBytes(data, 0);
        return data;
    }

    public void getBytes(byte[] data, int offset) {
        Util.arrayCopy(Util.toByteArrayLE(this.part1), data, offset + 0);
        Util.arrayCopy(Util.toByteArrayLE(this.part2), data, offset + 4);
        Util.arrayCopy(Util.toByteArrayLE(this.part3), data, offset + 6);
        Util.arrayCopy(Util.toByteArrayBE(this.part4), data, offset + 8);
    }

    public String toString() {
        return GPTEntry.getGUIDAsString(this.getBytes());
    }

    private Field getPrivateField(String name) throws NoSuchFieldException {
        Field f = this.getClass().getDeclaredField(name);
        f.setAccessible(true);
        return f;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(GPTEntry.class.getSimpleName());
        try {
            db.addUIntLE("part1", this.getPrivateField("part1"), this, null, null, IntegerFieldRepresentation.HEXADECIMAL);
            db.addUIntLE("part2", this.getPrivateField("part2"), this, null, null, IntegerFieldRepresentation.HEXADECIMAL);
            db.addUIntLE("part3", this.getPrivateField("part3"), this, null, null, IntegerFieldRepresentation.HEXADECIMAL);
            db.addUIntLE("part4", this.getPrivateField("part4"), this, null, null, IntegerFieldRepresentation.HEXADECIMAL);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return db.getResult();
    }

    public int size() {
        return GUID.length();
    }

    public static int length() {
        return 16;
    }
}

