/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.gpt.types;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.EncodedStringField;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.PartitionType;
import org.catacombae.storage.ps.gpt.GPTPartitionType;
import org.catacombae.storage.ps.gpt.types.GUID;
import org.catacombae.util.Util;

public class GPTEntry
implements Partition,
StructElements {
    protected final GUID partitionTypeGUID;
    protected final GUID uniquePartitionGUID;
    protected final byte[] startingLBA = new byte[8];
    protected final byte[] endingLBA = new byte[8];
    protected final byte[] attributeBits = new byte[8];
    protected final byte[] partitionName = new byte[72];
    protected final int blockSize;

    public GPTEntry(byte[] data, int offset, int blockSize) {
        this(blockSize, new GUID(data, offset + 0), new GUID(data, offset + 16));
        System.arraycopy(data, offset + 32, this.startingLBA, 0, 8);
        System.arraycopy(data, offset + 40, this.endingLBA, 0, 8);
        System.arraycopy(data, offset + 48, this.attributeBits, 0, 8);
        System.arraycopy(data, offset + 56, this.partitionName, 0, 72);
    }

    protected GPTEntry(int blockSize, GUID partitionTypeGUID, GUID uniquePartitionGUID) {
        this.blockSize = blockSize;
        this.partitionTypeGUID = partitionTypeGUID;
        this.uniquePartitionGUID = uniquePartitionGUID;
    }

    public GPTEntry(GPTEntry source) {
        this(source.blockSize, new GUID(source.partitionTypeGUID), new GUID(source.uniquePartitionGUID));
        this.copyFields(source);
    }

    protected void copyFields(GPTEntry source) {
        this.partitionTypeGUID.copyFields(source.partitionTypeGUID);
        this.uniquePartitionGUID.copyFields(source.uniquePartitionGUID);
        System.arraycopy(source.startingLBA, 0, this.startingLBA, 0, this.startingLBA.length);
        System.arraycopy(source.endingLBA, 0, this.endingLBA, 0, this.endingLBA.length);
        System.arraycopy(source.attributeBits, 0, this.attributeBits, 0, this.attributeBits.length);
        System.arraycopy(source.partitionName, 0, this.partitionName, 0, this.partitionName.length);
    }

    public long getStartOffset() {
        return this.getStartingLBA() * (long)this.blockSize;
    }

    public long getLength() {
        return (this.getEndingLBA() + 1L) * (long)this.blockSize - this.getStartOffset();
    }

    public PartitionType getType() {
        return GPTEntry.convertPartitionType(this.getPartitionTypeGUIDAsEnum());
    }

    public static int getSize() {
        return 128;
    }

    public GUID getPartitionTypeGUID() {
        return this.partitionTypeGUID;
    }

    public GUID getUniquePartitionGUID() {
        return this.uniquePartitionGUID;
    }

    public long getStartingLBA() {
        return Util.readLongLE(this.startingLBA);
    }

    public long getEndingLBA() {
        return Util.readLongLE(this.endingLBA);
    }

    public long getAttributeBits() {
        return Util.readLongBE(this.attributeBits);
    }

    public byte[] getPartitionName() {
        return Util.createCopy(this.partitionName);
    }

    public GPTPartitionType getPartitionTypeGUIDAsEnum() {
        byte[] guidBytes = this.partitionTypeGUID.getBytes();
        return GPTPartitionType.getType(Util.readLongBE(guidBytes, 0), Util.readLongBE(guidBytes, 8));
    }

    public String getPartitionNameAsString() {
        return GPTEntry.getPartitionNameAsString(this.partitionName);
    }

    public static String getPartitionNameAsString(byte[] partitionName) {
        int stringLength = 0;
        for (int i = 0; i < partitionName.length && (partitionName[i] != 0 || partitionName[i + 1] != 0); i += 2) {
            stringLength += 2;
        }
        return Util.readString(partitionName, 0, stringLength, "UTF-16LE");
    }

    public boolean isUsed() {
        return this.getPartitionTypeGUIDAsEnum() != GPTPartitionType.PARTITION_TYPE_UNUSED_ENTRY;
    }

    public String toString() {
        return "\"" + this.getPartitionNameAsString() + "\" (" + (Object)((Object)this.getPartitionTypeGUIDAsEnum()) + ")";
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " partitionTypeGUID: " + this.getPartitionTypeGUID().toString() + " (" + (Object)((Object)this.getPartitionTypeGUIDAsEnum()) + ")");
        ps.println(prefix + " uniquePartitionGUID: " + this.getUniquePartitionGUID().toString());
        ps.println(prefix + " startingLBA: " + this.getStartingLBA());
        ps.println(prefix + " endingLBA: " + this.getEndingLBA());
        ps.println(prefix + " attributeBits: " + this.getAttributeBits());
        ps.println(prefix + " partitionName: " + this.getPartitionNameAsString());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "GPTEntry:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[128];
        int offset = 0;
        this.partitionTypeGUID.getBytes(result, offset);
        this.uniquePartitionGUID.getBytes(result, offset += GUID.length());
        System.arraycopy(this.startingLBA, 0, result, offset += GUID.length(), this.startingLBA.length);
        System.arraycopy(this.endingLBA, 0, result, offset += 8, this.endingLBA.length);
        System.arraycopy(this.attributeBits, 0, result, offset += 8, this.attributeBits.length);
        System.arraycopy(this.partitionName, 0, result, offset += 8, this.partitionName.length);
        offset += 72;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GPTEntry) {
            GPTEntry gpte = (GPTEntry)obj;
            return Util.arraysEqual(this.getBytes(), gpte.getBytes());
        }
        return false;
    }

    public static String getGUIDAsString(byte[] guid) {
        String res = "{";
        res = res + Util.toHexStringLE(Util.readIntBE(guid, 0)) + "-";
        res = res + Util.toHexStringLE(Util.readShortBE(guid, 4)) + "-";
        res = res + Util.toHexStringLE(Util.readShortBE(guid, 6)) + "-";
        res = res + Util.byteArrayToHexString(guid, 8, 2) + "-";
        res = res + Util.byteArrayToHexString(guid, 10, 6) + "}";
        return res.toUpperCase();
    }

    public static PartitionType convertPartitionType(GPTPartitionType gpt) {
        switch (gpt) {
            case PARTITION_TYPE_APPLE_HFS: {
                return PartitionType.APPLE_HFS_CONTAINER;
            }
            case PARTITION_TYPE_PRIMARY_PARTITION: {
                return PartitionType.NT_OS2_IFS;
            }
        }
        return PartitionType.UNKNOWN;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(GPTEntry.class.getSimpleName());
        db.add("partitionTypeGUID", this.partitionTypeGUID.getStructElements());
        db.add("uniquePartitionGUID", this.uniquePartitionGUID.getStructElements());
        db.addUIntLE("startingLBA", this.startingLBA);
        db.addUIntLE("endingLBA", this.endingLBA);
        db.add("partitionName", new EncodedStringField(this.partitionName, "UTF-16LE"));
        return db.getResult();
    }
}

