/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.gpt;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.io.DataLocator;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.PartitionSystemHandler;
import org.catacombae.storage.ps.gpt.types.GUIDPartitionTable;

public class GPTHandler
extends PartitionSystemHandler {
    private DataLocator partitionData;

    public GPTHandler(DataLocator partitionData) {
        this.partitionData = partitionData;
    }

    public long getPartitionCount() {
        GUIDPartitionTable gpt = this.readPartitionTable();
        return gpt.getUsedPartitionCount();
    }

    public Partition[] getPartitions() {
        GUIDPartitionTable partitionTable = this.readPartitionTable();
        return partitionTable.getUsedPartitionEntries();
    }

    public void close() {
        this.partitionData.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUIDPartitionTable readPartitionTable() {
        ReadableRandomAccessStream llf = null;
        try {
            llf = this.partitionData.createReadOnlyFile();
            GUIDPartitionTable gpt = new GUIDPartitionTable(llf, 0);
            if (gpt.isValid()) {
                GUIDPartitionTable gUIDPartitionTable = gpt;
                return gUIDPartitionTable;
            }
            GUIDPartitionTable gUIDPartitionTable = null;
            return gUIDPartitionTable;
        }
        finally {
            if (llf != null) {
                llf.close();
            }
        }
    }
}

