/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.ebr;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.Stream;
import org.catacombae.storage.io.DataLocator;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.PartitionSystemHandler;
import org.catacombae.storage.ps.ebr.EBRPartitionSystem;

public class EBRHandler
extends PartitionSystemHandler {
    private DataLocator partitionData;

    public EBRHandler(DataLocator partitionData) {
        this.partitionData = partitionData;
    }

    public long getPartitionCount() {
        EBRPartitionSystem ps = this.readPartitionTable();
        return ps.getUsedPartitionCount();
    }

    public Partition[] getPartitions() {
        EBRPartitionSystem partitionTable = this.readPartitionTable();
        return partitionTable.getUsedPartitionEntries();
    }

    public void close() {
        this.partitionData.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EBRPartitionSystem readPartitionTable() {
        Stream llf = null;
        try {
            this.partitionData.createReadOnlyFile();
            byte[] firstBlock = new byte[512];
            llf.readFully(firstBlock);
            EBRPartitionSystem ebs = new EBRPartitionSystem((ReadableRandomAccessStream)llf, 0L, 512);
            if (ebs.isValid()) {
                EBRPartitionSystem eBRPartitionSystem = ebs;
                return eBRPartitionSystem;
            }
        }
        finally {
            if (llf != null) {
                llf.close();
            }
        }
        return null;
    }
}

