/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.container.hfs;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.fs.FileSystemMajorType;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemRecognizer;
import org.catacombae.storage.io.DataLocator;
import org.catacombae.storage.ps.PartitionSystemType;
import org.catacombae.storage.ps.container.ContainerHandler;
import org.catacombae.storage.ps.container.ContainerType;

public class HFSContainerHandler
extends ContainerHandler {
    private static final short SIGNATURE_HFS = 16964;
    private static final short SIGNATURE_HFS_PLUS = 18475;
    private static final short SIGNATURE_HFSX = 18520;
    private DataLocator partitionData;

    public HFSContainerHandler(DataLocator partitionData) {
        this.partitionData = partitionData;
    }

    public boolean containsFileSystem() {
        return true;
    }

    public boolean containsPartitionSystem() {
        return false;
    }

    public boolean containsContainer() {
        return false;
    }

    public FileSystemMajorType detectFileSystemType() {
        ReadableRandomAccessStream bitstream = this.partitionData.createReadOnlyFile();
        switch (HFSCommonFileSystemRecognizer.detectFileSystem(bitstream, 0L)) {
            case HFS: {
                return FileSystemMajorType.APPLE_HFS;
            }
            case HFS_PLUS: 
            case HFS_WRAPPED_HFS_PLUS: {
                return FileSystemMajorType.APPLE_HFS_PLUS;
            }
            case HFSX: {
                return FileSystemMajorType.APPLE_HFSX;
            }
        }
        return FileSystemMajorType.UNKNOWN;
    }

    public PartitionSystemType detectPartitionSystemType() {
        throw new UnsupportedOperationException("An HFS container does not contain partition systems.");
    }

    public ContainerType detectContainerType() {
        throw new UnsupportedOperationException("An HFS container does not contain other containers.");
    }
}

