/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.apm.types;

import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.storage.ps.apm.types.DriverDescriptorEntry;
import org.catacombae.util.Util;

public class DriverDescriptorRecord {
    public static final short DDR_SIGNATURE = 17746;
    private final byte[] sbSig = new byte[2];
    private final byte[] sbBlkSize = new byte[2];
    private final byte[] sbBlkCount = new byte[4];
    private final byte[] sbDevType = new byte[2];
    private final byte[] sbDevId = new byte[2];
    private final byte[] sbData = new byte[4];
    private final byte[] sbDrvrCount = new byte[2];
    private final DriverDescriptorEntry[] entries;
    private final byte[] ddPad;

    public DriverDescriptorRecord(ReadableRandomAccessStream llf, long offset) {
        this(DriverDescriptorRecord.readData(llf, offset), 0);
    }

    public DriverDescriptorRecord(byte[] data, int offset) {
        int padLength;
        int i;
        if (data.length - offset < 18) {
            throw new RuntimeException("Insufficient remaining data in buffer for a " + this.getClass().getName() + " " + "(remaining: " + (data.length - offset) + " bytes, " + "required: 18 bytes).");
        }
        System.arraycopy(data, offset + 0, this.sbSig, 0, 2);
        System.arraycopy(data, offset + 2, this.sbBlkSize, 0, 2);
        System.arraycopy(data, offset + 4, this.sbBlkCount, 0, 4);
        System.arraycopy(data, offset + 8, this.sbDevType, 0, 2);
        System.arraycopy(data, offset + 10, this.sbDevId, 0, 2);
        System.arraycopy(data, offset + 12, this.sbData, 0, 4);
        System.arraycopy(data, offset + 16, this.sbDrvrCount, 0, 2);
        int numEntries = this.getSbDrvrCount();
        if (numEntries * DriverDescriptorEntry.length() > data.length - offset - 18) {
            numEntries = (data.length - offset - 18) / DriverDescriptorEntry.length();
        }
        this.entries = new DriverDescriptorEntry[numEntries];
        for (i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new DriverDescriptorEntry(data, offset + 18 + DriverDescriptorEntry.length() * i);
        }
        int padOffset = offset + 18 + DriverDescriptorEntry.length() * i;
        if (data.length - offset - padOffset < (padLength = this.getSbBlkSize() - padOffset)) {
            padLength = data.length - offset - padOffset;
        }
        this.ddPad = new byte[padLength];
        System.arraycopy(data, offset + padOffset, this.ddPad, 0, this.ddPad.length);
    }

    public DriverDescriptorRecord(int blockSize, long blockCount) {
        if (blockSize < 0 || blockSize > 65535) {
            throw new IllegalArgumentException("Invalid value for 'blockSize': " + blockSize);
        }
        if (blockCount < 0L || blockCount > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid value for 'blockCount': " + blockCount);
        }
        Util.arrayPutBE(this.sbSig, 0, (short)17746);
        Util.arrayPutBE(this.sbBlkSize, 0, (short)blockSize);
        Util.arrayPutBE(this.sbBlkCount, 0, (int)blockCount);
        Util.arrayPutBE(this.sbDevType, 0, (short)0);
        Util.arrayPutBE(this.sbDevId, 0, (short)0);
        Util.arrayPutBE(this.sbData, 0, 0);
        Util.arrayPutBE(this.sbDrvrCount, 0, (short)0);
        this.entries = new DriverDescriptorEntry[0];
        this.ddPad = new byte[blockSize - 18];
        Arrays.fill(this.ddPad, (byte)0);
    }

    private static byte[] readData(ReadableRandomAccessStream llf, long offset) {
        byte[] data = null;
        int curBlockSize = 512;
        RuntimeIOException mostRecentException = null;
        do {
            data = new byte[curBlockSize];
            try {
                llf.seek(offset);
                llf.readFully(data);
            }
            catch (RuntimeIOException ex) {
                mostRecentException = ex;
                data = null;
            }
        } while (data == null && (curBlockSize *= 2) <= 4096);
        if (data == null) {
            throw mostRecentException;
        }
        DriverDescriptorRecord ddrTmp = new DriverDescriptorRecord(data, 0);
        if (ddrTmp.isValid() && ddrTmp.getSbBlkSize() > data.length) {
            data = new byte[ddrTmp.getSbBlkSize()];
            llf.seek(offset);
            llf.readFully(data);
        }
        return data;
    }

    public int length() {
        return 18 + this.entries.length * DriverDescriptorEntry.length() + this.ddPad.length;
    }

    public int getSbSig() {
        return Util.unsign(this.getRawSbSig());
    }

    public int getSbBlkSize() {
        return Util.unsign(this.getRawSbBlkSize());
    }

    public long getSbBlkCount() {
        return Util.unsign(this.getRawSbBlkCount());
    }

    public int getSbDevType() {
        return Util.unsign(this.getRawSbDevType());
    }

    public int getSbDevId() {
        return Util.unsign(this.getRawSbDevId());
    }

    public long getSbData() {
        return Util.unsign(this.getRawSbData());
    }

    public int getSbDrvrCount() {
        return Util.unsign(this.getRawSbDrvrCount());
    }

    public DriverDescriptorEntry[] getDriverDecriptorEntries() {
        DriverDescriptorEntry[] result = new DriverDescriptorEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    public byte[] getDdPad() {
        return Util.createCopy(this.ddPad);
    }

    public String getSbSigAsString() {
        return Util.toASCIIString(this.sbSig);
    }

    public short getRawSbSig() {
        return Util.readShortBE(this.sbSig);
    }

    public short getRawSbBlkSize() {
        return Util.readShortBE(this.sbBlkSize);
    }

    public int getRawSbBlkCount() {
        return Util.readIntBE(this.sbBlkCount);
    }

    public short getRawSbDevType() {
        return Util.readShortBE(this.sbDevType);
    }

    public short getRawSbDevId() {
        return Util.readShortBE(this.sbDevId);
    }

    public int getRawSbData() {
        return Util.readIntBE(this.sbData);
    }

    public short getRawSbDrvrCount() {
        return Util.readShortBE(this.sbDrvrCount);
    }

    public boolean isValid() {
        int driverCount = this.getSbDrvrCount();
        return this.getSbSig() == 17746 && driverCount <= 31 && this.entries.length == driverCount;
    }

    public byte[] getData() {
        byte[] result = new byte[this.length()];
        int offset = 0;
        System.arraycopy(this.sbSig, 0, result, offset, this.sbSig.length);
        System.arraycopy(this.sbBlkSize, 0, result, offset += this.sbSig.length, this.sbBlkSize.length);
        System.arraycopy(this.sbBlkCount, 0, result, offset += this.sbBlkSize.length, this.sbBlkCount.length);
        System.arraycopy(this.sbDevType, 0, result, offset += this.sbBlkCount.length, this.sbDevType.length);
        System.arraycopy(this.sbDevId, 0, result, offset += this.sbDevType.length, this.sbDevId.length);
        System.arraycopy(this.sbData, 0, result, offset += this.sbDevId.length, this.sbData.length);
        System.arraycopy(this.sbDrvrCount, 0, result, offset += this.sbData.length, this.sbDrvrCount.length);
        offset += this.sbDrvrCount.length;
        for (DriverDescriptorEntry dde : this.entries) {
            byte[] tmp = dde.getData();
            System.arraycopy(tmp, 0, result, offset, tmp.length);
            offset += tmp.length;
        }
        System.arraycopy(this.ddPad, 0, result, offset, this.ddPad.length);
        if ((offset += this.ddPad.length) != this.length()) {
            throw new RuntimeException("Internal miscalculation...");
        }
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        int i;
        ps.println(prefix + " sbSig: \"" + this.getSbSigAsString() + "\"");
        ps.println(prefix + " sbBlkSize: " + this.getSbBlkSize());
        ps.println(prefix + " sbBlkCount: " + this.getSbBlkCount());
        ps.println(prefix + " sbDevType: " + this.getSbDevType());
        ps.println(prefix + " sbDevId: " + this.getSbDevId());
        ps.println(prefix + " sbData: " + this.getSbData());
        ps.println(prefix + " sbDrvrCount: " + this.getSbDrvrCount());
        ps.println(prefix + " entries (" + this.entries.length + " elements):");
        for (i = 0; i < this.entries.length; ++i) {
            ps.println(prefix + "  entries[" + i + "]: ");
            this.entries[i].print(ps, prefix + "   ");
        }
        if (this.entries.length == 0) {
            ps.println(prefix + "  <empty>");
        }
        ps.println(prefix + " ddPad:");
        ps.print(prefix + "  byte[" + this.ddPad.length + "] {");
        for (i = 0; i < this.ddPad.length; ++i) {
            if (i % 16 == 0) {
                ps.println();
                ps.print(prefix + "  ");
            }
            ps.print(" " + Util.toHexStringBE(this.ddPad[i]));
        }
        ps.println();
        ps.println(prefix + "  }");
        try {
            byte[] md5sum = MessageDigest.getInstance("MD5").digest(this.ddPad);
            ps.println(prefix + "  MD5: " + Util.byteArrayToHexString(md5sum));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "DriverDescriptorRecord:");
        this.printFields(ps, prefix);
    }
}

