/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.apm.types;

import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.PartitionType;
import org.catacombae.util.Util;

public class APMPartition
implements Partition {
    public static final short APM_PARTITION_SIGNATURE = 20557;
    public static final short APM_PARTITION_OLD_SIGNATURE = 21587;
    private final byte[] pmSig = new byte[2];
    private final byte[] pmSigPad = new byte[2];
    private final byte[] pmMapBlkCnt = new byte[4];
    private final byte[] pmPyPartStart = new byte[4];
    private final byte[] pmPartBlkCnt = new byte[4];
    private final byte[] pmPartName = new byte[32];
    private final byte[] pmParType = new byte[32];
    private final byte[] pmLgDataStart = new byte[4];
    private final byte[] pmDataCnt = new byte[4];
    private final byte[] pmPartStatus = new byte[4];
    private final byte[] pmLgBootStart = new byte[4];
    private final byte[] pmBootSize = new byte[4];
    private final byte[] pmBootAddr = new byte[4];
    private final byte[] pmBootAddr2 = new byte[4];
    private final byte[] pmBootEntry = new byte[4];
    private final byte[] pmBootEntry2 = new byte[4];
    private final byte[] pmBootCksum = new byte[4];
    private final byte[] pmProcessor = new byte[16];
    private final byte[] pmPad = new byte[376];
    private final int blockSize;

    public APMPartition(byte[] data, int offset, int blockSize) {
        System.arraycopy(data, offset + 0, this.pmSig, 0, 2);
        System.arraycopy(data, offset + 2, this.pmSigPad, 0, 2);
        System.arraycopy(data, offset + 4, this.pmMapBlkCnt, 0, 4);
        System.arraycopy(data, offset + 8, this.pmPyPartStart, 0, 4);
        System.arraycopy(data, offset + 12, this.pmPartBlkCnt, 0, 4);
        System.arraycopy(data, offset + 16, this.pmPartName, 0, 32);
        System.arraycopy(data, offset + 48, this.pmParType, 0, 32);
        System.arraycopy(data, offset + 80, this.pmLgDataStart, 0, 4);
        System.arraycopy(data, offset + 84, this.pmDataCnt, 0, 4);
        System.arraycopy(data, offset + 88, this.pmPartStatus, 0, 4);
        System.arraycopy(data, offset + 92, this.pmLgBootStart, 0, 4);
        System.arraycopy(data, offset + 96, this.pmBootSize, 0, 4);
        System.arraycopy(data, offset + 100, this.pmBootAddr, 0, 4);
        System.arraycopy(data, offset + 104, this.pmBootAddr2, 0, 4);
        System.arraycopy(data, offset + 108, this.pmBootEntry, 0, 4);
        System.arraycopy(data, offset + 112, this.pmBootEntry2, 0, 4);
        System.arraycopy(data, offset + 116, this.pmBootCksum, 0, 4);
        System.arraycopy(data, offset + 120, this.pmProcessor, 0, 16);
        System.arraycopy(data, offset + 136, this.pmPad, 0, 376);
        this.blockSize = blockSize;
    }

    public APMPartition(long partitionMapBlockCount, long partitionStartBlock, long partitionBlockCount, String partitionName, String partitionType, int partitionStatus, int blockSize) {
        if (partitionMapBlockCount < 0L || partitionMapBlockCount >= 0xFFFFFFFFL) {
            throw new IllegalArgumentException("'partitionMapBlockCount' out of range: " + partitionMapBlockCount);
        }
        if (partitionStartBlock < 0L || partitionStartBlock >= 0xFFFFFFFFL) {
            throw new IllegalArgumentException("'partitionStartBlock' out of range: " + partitionStartBlock);
        }
        if (partitionBlockCount < 0L || partitionBlockCount >= 0xFFFFFFFFL) {
            throw new IllegalArgumentException("'partitionBlockCount' out of range: " + partitionBlockCount);
        }
        int partitionNameEncodedLength = partitionName.codePointCount(0, partitionName.length());
        if (partitionNameEncodedLength < 0 || partitionNameEncodedLength > this.pmPartName.length) {
            throw new IllegalArgumentException("'partitionName' string too long: " + partitionName.length());
        }
        int partitionTypeEncodedLength = partitionType.codePointCount(0, partitionType.length());
        if (partitionTypeEncodedLength < 0 || partitionTypeEncodedLength > this.pmParType.length) {
            throw new IllegalArgumentException("'partitionType' string too long: " + partitionType.length());
        }
        Util.arrayPutBE(this.pmSig, 0, (short)20557);
        Arrays.fill(this.pmSigPad, (byte)0);
        Util.arrayPutBE(this.pmMapBlkCnt, 0, (int)partitionMapBlockCount);
        Util.arrayPutBE(this.pmPyPartStart, 0, (int)partitionStartBlock);
        Util.arrayPutBE(this.pmPartBlkCnt, 0, (int)partitionBlockCount);
        try {
            Util.encodeASCIIString(partitionName, 0, this.pmPartName, 0, partitionNameEncodedLength);
            if (partitionNameEncodedLength < this.pmPartName.length) {
                Arrays.fill(this.pmPartName, partitionNameEncodedLength, this.pmPartName.length, (byte)0);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("'partitionName' has illegal (non-ASCII) characters.");
        }
        try {
            Util.encodeASCIIString(partitionType, 0, this.pmParType, 0, partitionTypeEncodedLength);
            if (partitionTypeEncodedLength < this.pmParType.length) {
                Arrays.fill(this.pmParType, partitionTypeEncodedLength, this.pmParType.length, (byte)0);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("'partitionType' has illegal (non-ASCII) characters.");
        }
        Util.arrayPutBE(this.pmLgDataStart, 0, 0);
        Util.arrayPutBE(this.pmDataCnt, 0, (int)partitionBlockCount);
        Util.arrayPutBE(this.pmPartStatus, 0, partitionStatus);
        Util.arrayPutBE(this.pmLgBootStart, 0, 0);
        Util.arrayPutBE(this.pmBootSize, 0, 0);
        Util.arrayPutBE(this.pmBootAddr, 0, 0);
        Util.arrayPutBE(this.pmBootAddr2, 0, 0);
        Util.arrayPutBE(this.pmBootEntry, 0, 0);
        Util.arrayPutBE(this.pmBootEntry2, 0, 0);
        Util.arrayPutBE(this.pmBootCksum, 0, 0);
        Arrays.fill(this.pmProcessor, (byte)0);
        Arrays.fill(this.pmPad, (byte)0);
        this.blockSize = blockSize;
    }

    public static int structSize() {
        return 512;
    }

    public long getStartOffset() {
        return (Util.unsign(this.getPmPyPartStart()) + Util.unsign(this.getPmLgDataStart())) * (long)this.blockSize;
    }

    public long getLength() {
        return Util.unsign(this.getPmDataCnt()) * (long)this.blockSize;
    }

    public PartitionType getType() {
        return this.convertPartitionType(this.getPmParType());
    }

    public short getPmSig() {
        return Util.readShortBE(this.pmSig);
    }

    public short getPmSigPad() {
        return Util.readShortBE(this.pmSigPad);
    }

    public int getPmMapBlkCnt() {
        return Util.readIntBE(this.pmMapBlkCnt);
    }

    public int getPmPyPartStart() {
        return Util.readIntBE(this.pmPyPartStart);
    }

    public int getPmPartBlkCnt() {
        return Util.readIntBE(this.pmPartBlkCnt);
    }

    public byte[] getPmPartName() {
        return Util.createCopy(this.pmPartName);
    }

    public byte[] getPmParType() {
        return Util.createCopy(this.pmParType);
    }

    public int getPmLgDataStart() {
        return Util.readIntBE(this.pmLgDataStart);
    }

    public int getPmDataCnt() {
        return Util.readIntBE(this.pmDataCnt);
    }

    public int getPmPartStatus() {
        return Util.readIntBE(this.pmPartStatus);
    }

    public int getPmLgBootStart() {
        return Util.readIntBE(this.pmLgBootStart);
    }

    public int getPmBootSize() {
        return Util.readIntBE(this.pmBootSize);
    }

    public int getPmBootAddr() {
        return Util.readIntBE(this.pmBootAddr);
    }

    public int getPmBootAddr2() {
        return Util.readIntBE(this.pmBootAddr2);
    }

    public int getPmBootEntry() {
        return Util.readIntBE(this.pmBootEntry);
    }

    public int getPmBootEntry2() {
        return Util.readIntBE(this.pmBootEntry2);
    }

    public int getPmBootCksum() {
        return Util.readIntBE(this.pmBootCksum);
    }

    public byte[] getPmProcessor() {
        return Util.createCopy(this.pmProcessor);
    }

    public short[] getPmPad() {
        return Util.readShortArrayBE(this.pmPad);
    }

    private static boolean getBit(byte[] array, int bit) {
        long bitLength = (long)array.length << 3;
        if (bit < 0 || (long)bit >= bitLength) {
            throw new IllegalArgumentException("'bit' out of range: " + bit);
        }
        int arrayIndex = (int)(bitLength - 1L - (long)bit >>> 3);
        int bitIndex = bit & 7;
        return (array[arrayIndex] & 1 << bitIndex) != 0;
    }

    public boolean getPmPartStatusValid() {
        return APMPartition.getBit(this.pmPartStatus, 0);
    }

    public boolean getPmPartStatusAllocated() {
        return APMPartition.getBit(this.pmPartStatus, 1);
    }

    public boolean getPmPartStatusInUse() {
        return APMPartition.getBit(this.pmPartStatus, 2);
    }

    public boolean getPmPartStatusBootable() {
        return APMPartition.getBit(this.pmPartStatus, 3);
    }

    public boolean getPmPartStatusReadable() {
        return APMPartition.getBit(this.pmPartStatus, 4);
    }

    public boolean getPmPartStatusWritable() {
        return APMPartition.getBit(this.pmPartStatus, 5);
    }

    public boolean getPmPartStatusOSPicCode() {
        return APMPartition.getBit(this.pmPartStatus, 6);
    }

    public boolean getPmPartStatusOSSpecific1() {
        return APMPartition.getBit(this.pmPartStatus, 7);
    }

    public boolean getPmPartStatusOSSpecific2() {
        return APMPartition.getBit(this.pmPartStatus, 8);
    }

    public String getPmSigAsString() {
        return Util.toASCIIString(this.pmSig);
    }

    public String getPmPartNameAsString() {
        return Util.readNullTerminatedASCIIString(this.pmPartName);
    }

    public String getPmParTypeAsString() {
        return Util.readNullTerminatedASCIIString(this.pmParType);
    }

    public String getPmProcessorAsString() {
        return Util.readNullTerminatedASCIIString(this.pmProcessor);
    }

    public byte[] getPmPadRaw() {
        return Util.createCopy(this.pmPad);
    }

    public boolean isValid() {
        int pmSigInt = this.getPmSig() & 0xFFFF;
        return pmSigInt == 20557 || pmSigInt == 21587;
    }

    public void printPartitionInfo(PrintStream ps) {
        this.printPartitionInfo(ps, "");
    }

    public void printPartitionInfo(PrintStream ps, String prefix) {
        ps.println(prefix + "pmSig: \"" + this.getPmSigAsString() + "\"");
        ps.println(prefix + "pmSigPad: " + this.getPmSigPad());
        ps.println(prefix + "pmMapBlkCnt: " + this.getPmMapBlkCnt());
        ps.println(prefix + "pmPyPartStart: " + this.getPmPyPartStart());
        ps.println(prefix + "pmPartBlkCnt: " + this.getPmPartBlkCnt());
        ps.println(prefix + "pmPartName: \"" + this.getPmPartNameAsString() + "\"");
        ps.println(prefix + "pmParType: \"" + this.getPmParTypeAsString() + "\"");
        ps.println(prefix + "pmLgDataStart: " + this.getPmLgDataStart());
        ps.println(prefix + "pmDataCnt: " + this.getPmDataCnt());
        ps.println(prefix + "pmPartStatus: 0x" + Util.toHexStringBE(this.getPmPartStatus()));
        ps.println(prefix + "  valid: " + this.getPmPartStatusValid());
        ps.println(prefix + "  allocated: " + this.getPmPartStatusAllocated());
        ps.println(prefix + "  in use: " + this.getPmPartStatusInUse());
        ps.println(prefix + "  bootable: " + this.getPmPartStatusBootable());
        ps.println(prefix + "  readable: " + this.getPmPartStatusReadable());
        ps.println(prefix + "  writable: " + this.getPmPartStatusWritable());
        ps.println(prefix + "  OS pic code: " + this.getPmPartStatusOSPicCode());
        ps.println(prefix + "  OS specific 1: " + this.getPmPartStatusOSSpecific1());
        ps.println(prefix + "  OS specific 2: " + this.getPmPartStatusOSSpecific2());
        ps.println(prefix + "pmLgBootStart: " + this.getPmLgBootStart());
        ps.println(prefix + "pmBootSize: " + this.getPmBootSize());
        ps.println(prefix + "pmBootAddr: " + this.getPmBootAddr());
        ps.println(prefix + "pmBootAddr2: " + this.getPmBootAddr2());
        ps.println(prefix + "pmBootEntry: " + this.getPmBootEntry());
        ps.println(prefix + "pmBootEntry2: " + this.getPmBootEntry2());
        ps.println(prefix + "pmBootCksum: " + this.getPmBootCksum());
        ps.println(prefix + "pmProcessor: \"" + this.getPmProcessorAsString() + "\"");
        ps.println(prefix + "pmPad:");
        ps.print(prefix + " byte[" + this.pmPad.length + "] {");
        for (int i = 0; i < this.pmPad.length; ++i) {
            if (i % 16 == 0) {
                ps.println();
                ps.print(prefix + " ");
            }
            ps.print(" " + Util.toHexStringBE(this.pmPad[i]));
        }
        ps.println();
        ps.println(prefix + " }");
        try {
            byte[] md5sum = MessageDigest.getInstance("MD5").digest(this.pmPad);
            ps.println(prefix + " MD5: " + Util.byteArrayToHexString(md5sum));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public byte[] getData() {
        byte[] result = new byte[APMPartition.structSize()];
        int offset = 0;
        System.arraycopy(this.pmSig, 0, result, offset, this.pmSig.length);
        System.arraycopy(this.pmSigPad, 0, result, offset += this.pmSig.length, this.pmSigPad.length);
        System.arraycopy(this.pmMapBlkCnt, 0, result, offset += this.pmSigPad.length, this.pmMapBlkCnt.length);
        System.arraycopy(this.pmPyPartStart, 0, result, offset += this.pmMapBlkCnt.length, this.pmPyPartStart.length);
        System.arraycopy(this.pmPartBlkCnt, 0, result, offset += this.pmPyPartStart.length, this.pmPartBlkCnt.length);
        System.arraycopy(this.pmPartName, 0, result, offset += this.pmPartBlkCnt.length, this.pmPartName.length);
        System.arraycopy(this.pmParType, 0, result, offset += this.pmPartName.length, this.pmParType.length);
        System.arraycopy(this.pmLgDataStart, 0, result, offset += this.pmParType.length, this.pmLgDataStart.length);
        System.arraycopy(this.pmDataCnt, 0, result, offset += this.pmLgDataStart.length, this.pmDataCnt.length);
        System.arraycopy(this.pmPartStatus, 0, result, offset += this.pmDataCnt.length, this.pmPartStatus.length);
        System.arraycopy(this.pmLgBootStart, 0, result, offset += this.pmPartStatus.length, this.pmLgBootStart.length);
        System.arraycopy(this.pmBootSize, 0, result, offset += this.pmLgBootStart.length, this.pmBootSize.length);
        System.arraycopy(this.pmBootAddr, 0, result, offset += this.pmBootSize.length, this.pmBootAddr.length);
        System.arraycopy(this.pmBootAddr2, 0, result, offset += this.pmBootAddr.length, this.pmBootAddr2.length);
        System.arraycopy(this.pmBootEntry, 0, result, offset += this.pmBootAddr2.length, this.pmBootEntry.length);
        System.arraycopy(this.pmBootEntry2, 0, result, offset += this.pmBootEntry.length, this.pmBootEntry2.length);
        System.arraycopy(this.pmBootCksum, 0, result, offset += this.pmBootEntry2.length, this.pmBootCksum.length);
        System.arraycopy(this.pmProcessor, 0, result, offset += this.pmBootCksum.length, this.pmProcessor.length);
        System.arraycopy(this.pmPad, 0, result, offset += this.pmProcessor.length, this.pmPad.length);
        if ((offset += this.pmPad.length) != result.length) {
            throw new RuntimeException("Internal miscalculation...");
        }
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        this.printPartitionInfo(ps, prefix + " ");
        ps.println(prefix + " Partition methods: ");
        ps.println(prefix + "  getStartOffset(): " + this.getStartOffset());
        ps.println(prefix + "  getLength(): " + this.getLength());
        ps.println(prefix + "  getType(): " + (Object)((Object)this.getType()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "APMPartition:");
        this.printFields(ps, prefix);
    }

    public String toString() {
        return "\"" + this.getPmPartNameAsString() + "\" (" + this.getPmParTypeAsString() + ")";
    }

    public PartitionType convertPartitionType(byte[] parTypeData) {
        String typeString = Util.readNullTerminatedASCIIString(parTypeData);
        if (typeString.equals("Apple_partition_map")) {
            return PartitionType.APPLE_PARTITION_MAP;
        }
        if (typeString.equals("Apple_Driver")) {
            return PartitionType.APPLE_DRIVER;
        }
        if (typeString.equals("Apple_Driver43")) {
            return PartitionType.APPLE_DRIVER43;
        }
        if (typeString.equals("Apple_MFS")) {
            return PartitionType.APPLE_MFS;
        }
        if (typeString.equals("Apple_HFS")) {
            return PartitionType.APPLE_HFS_CONTAINER;
        }
        if (typeString.equals("Apple_HFSX")) {
            return PartitionType.APPLE_HFSX;
        }
        if (typeString.equals("Apple_Unix_SVR2")) {
            return PartitionType.APPLE_UNIX_SVR2;
        }
        if (typeString.equals("Apple_PRODOS")) {
            return PartitionType.APPLE_PRODOS;
        }
        if (typeString.equals("Apple_Free")) {
            return PartitionType.EMPTY;
        }
        if (typeString.equals("Apple_Scratch")) {
            return PartitionType.EMPTY;
        }
        return PartitionType.UNKNOWN;
    }
}

