/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.apm;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.ps.PartitionSystemRecognizer;
import org.catacombae.storage.ps.apm.types.ApplePartitionMap;
import org.catacombae.storage.ps.apm.types.DriverDescriptorRecord;

public class APMRecognizer
implements PartitionSystemRecognizer {
    public boolean detect(ReadableRandomAccessStream fsStream, long offset, long length) {
        try {
            int blockSize;
            ApplePartitionMap apm;
            byte[] firstBlock = new byte[512];
            fsStream.seek(0L);
            fsStream.readFully(firstBlock);
            DriverDescriptorRecord ddr = new DriverDescriptorRecord(firstBlock, 0);
            if (ddr.isValid() && (apm = new ApplePartitionMap(fsStream, (long)((blockSize = ddr.getSbBlkSize()) * 1), blockSize)).getUsedPartitionCount() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }
}

