/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps.apm;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.io.DataLocator;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.PartitionSystemHandler;
import org.catacombae.storage.ps.apm.types.ApplePartitionMap;
import org.catacombae.storage.ps.apm.types.DriverDescriptorRecord;

public class APMHandler
extends PartitionSystemHandler {
    private DataLocator partitionData;

    public APMHandler(DataLocator partitionData) {
        this.partitionData = partitionData;
    }

    public long getPartitionCount() {
        ApplePartitionMap apm = this.readPartitionMap();
        return apm.getUsedPartitionCount();
    }

    public Partition[] getPartitions() {
        ApplePartitionMap apm = this.readPartitionMap();
        return apm.getUsedPartitionEntries();
    }

    public void close() {
        this.partitionData.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriverDescriptorRecord readDriverDescriptorRecord() {
        ReadableRandomAccessStream llf = null;
        try {
            DriverDescriptorRecord ddr;
            llf = this.partitionData.createReadOnlyFile();
            byte[] firstBlock = new byte[512];
            llf.readFully(firstBlock);
            DriverDescriptorRecord driverDescriptorRecord = ddr = new DriverDescriptorRecord(firstBlock, 0);
            return driverDescriptorRecord;
        }
        finally {
            if (llf != null) {
                llf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplePartitionMap readPartitionMap() {
        ReadableRandomAccessStream llf = null;
        try {
            llf = this.partitionData.createReadOnlyFile();
            DriverDescriptorRecord ddr = this.readDriverDescriptorRecord();
            if (ddr.isValid()) {
                int blockSize = ddr.getSbBlkSize();
                ApplePartitionMap apm = new ApplePartitionMap(llf, (long)(blockSize * 1), blockSize);
                if (apm.getPartitionCount() > 0) {
                    ApplePartitionMap applePartitionMap = apm;
                    return applePartitionMap;
                }
                ApplePartitionMap applePartitionMap = null;
                return applePartitionMap;
            }
            ApplePartitionMap applePartitionMap = null;
            return applePartitionMap;
        }
        finally {
            if (llf != null) {
                llf.close();
            }
        }
    }
}

