/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps;

import org.catacombae.storage.fs.FileSystemMajorType;
import org.catacombae.storage.ps.PartitionSystemType;
import org.catacombae.storage.ps.container.ContainerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PartitionType {
    EMPTY(ContentType.OTHER),
    FAT12(ContentType.FILE_SYSTEM, FileSystemMajorType.FAT12),
    FAT16(ContentType.FILE_SYSTEM, FileSystemMajorType.FAT16),
    FAT32(ContentType.FILE_SYSTEM, FileSystemMajorType.FAT32),
    DOS_EXTENDED(ContentType.PARTITION_SYSTEM, PartitionSystemType.DOS_EXTENDED),
    NT_OS2_IFS(ContentType.CONTAINER, ContainerType.NT_OS2_IFS),
    APPLE_PARTITION_MAP(ContentType.OTHER),
    APPLE_DRIVER(ContentType.OTHER),
    APPLE_DRIVER43(ContentType.OTHER),
    APPLE_MFS(ContentType.FILE_SYSTEM, FileSystemMajorType.APPLE_MFS),
    APPLE_HFS_CONTAINER(ContentType.CONTAINER, ContainerType.APPLE_HFS),
    APPLE_HFSX(ContentType.FILE_SYSTEM, FileSystemMajorType.APPLE_HFSX),
    APPLE_UNIX_SVR2(ContentType.CONTAINER, ContainerType.APPLE_UNIX_SVR2),
    APPLE_UFS(ContentType.FILE_SYSTEM, FileSystemMajorType.APPLE_UFS),
    APPLE_PRODOS(ContentType.FILE_SYSTEM, FileSystemMajorType.APPLE_PRODOS),
    LINUX_LVM(ContentType.PARTITION_SYSTEM),
    LINUX_SWAP(ContentType.OTHER),
    LINUX_NATIVE(ContentType.CONTAINER, ContainerType.LINUX_NATIVE),
    GPT_PROTECTIVE(ContentType.PARTITION_SYSTEM),
    EFI_SYSTEM(ContentType.FILE_SYSTEM),
    SPECIAL(ContentType.OTHER),
    UNKNOWN(ContentType.OTHER);

    private final ContentType contentType;
    private FileSystemMajorType fsType = null;
    private PartitionSystemType psType = null;
    private ContainerType containerType = null;

    private PartitionType(ContentType contentType) {
        this.contentType = contentType;
    }

    private PartitionType(ContentType contentType, FileSystemMajorType fsType) {
        this(contentType);
        if (contentType != ContentType.FILE_SYSTEM) {
            throw new RuntimeException("Wrong content type for constructor.");
        }
        this.fsType = fsType;
    }

    private PartitionType(ContentType contentType, PartitionSystemType psType) {
        this(contentType);
        if (contentType != ContentType.PARTITION_SYSTEM) {
            throw new RuntimeException("Wrong content type for constructor.");
        }
        this.psType = psType;
    }

    private PartitionType(ContentType contentType, ContainerType containerType) {
        this(contentType);
        if (contentType != ContentType.CONTAINER) {
            throw new RuntimeException("Wrong content type for constructor.");
        }
        this.containerType = containerType;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public FileSystemMajorType getAssociatedFileSystemType() {
        if (this.contentType != ContentType.FILE_SYSTEM) {
            throw new RuntimeException("Trying to get the file system type for non file system content!");
        }
        return this.fsType;
    }

    public PartitionSystemType getAssociatedPartitionSystemType() {
        if (this.contentType != ContentType.PARTITION_SYSTEM) {
            throw new RuntimeException("Trying to get the partition system type for non partition system content!");
        }
        return this.psType;
    }

    public ContainerType getAssociatedContainerType() {
        if (this.contentType != ContentType.CONTAINER) {
            throw new RuntimeException("Trying to get the container type for non container content!");
        }
        return this.containerType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        FILE_SYSTEM,
        PARTITION_SYSTEM,
        CONTAINER,
        OTHER;

    }
}

