/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.catacombae.storage.ps.PartitionSystemHandlerFactory;
import org.catacombae.storage.ps.apm.APMHandlerFactory;
import org.catacombae.storage.ps.ebr.EBRHandlerFactory;
import org.catacombae.storage.ps.gpt.GPTHandlerFactory;
import org.catacombae.storage.ps.mbr.MBRHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PartitionSystemType {
    MBR(true, MBRHandlerFactory.class, "Master Boot Record", new PartitionSystemType[0]),
    GPT(true, GPTHandlerFactory.class, "GUID Partition Table", MBR),
    APM(true, APMHandlerFactory.class, "Apple Partition Map", new PartitionSystemType[0]),
    DOS_EXTENDED(false, EBRHandlerFactory.class, "DOS Extended", new PartitionSystemType[0]);

    private final boolean isTopLevelCapable;
    private final String longName;
    private final PartitionSystemType[] overriddenPartitionSystems;
    private LinkedList<Class<? extends PartitionSystemHandlerFactory>> factoryClasses = new LinkedList();

    private PartitionSystemType(boolean pIsTopLevelCapable, String longName, PartitionSystemType ... overriddenPartitionSystems) {
        this.isTopLevelCapable = pIsTopLevelCapable;
        this.longName = longName;
        this.overriddenPartitionSystems = overriddenPartitionSystems;
    }

    private PartitionSystemType(boolean pIsTopLevelCapable, Class<? extends PartitionSystemHandlerFactory> pDefaultFactoryClass, String longName, PartitionSystemType ... overriddenPartitionSystems) {
        this(pIsTopLevelCapable, longName, overriddenPartitionSystems);
        this.factoryClasses.addLast(pDefaultFactoryClass);
    }

    public boolean isTopLevelCapable() {
        return this.isTopLevelCapable;
    }

    public String getLongName() {
        return this.longName;
    }

    public PartitionSystemType[] getOverriddenPartitionSystems() {
        return this.overriddenPartitionSystems;
    }

    public void addFactoryClass(Class<? extends PartitionSystemHandlerFactory> pFactoryClass) {
        this.factoryClasses.addLast(pFactoryClass);
    }

    public List<Class<? extends PartitionSystemHandlerFactory>> getFactoryClasses() {
        return new ArrayList<Class<? extends PartitionSystemHandlerFactory>>(this.factoryClasses);
    }

    public PartitionSystemHandlerFactory createDefaultHandlerFactory() {
        if (this.factoryClasses.size() == 0) {
            return null;
        }
        Class<? extends PartitionSystemHandlerFactory> factoryClass = this.factoryClasses.getFirst();
        return PartitionSystemType.createHandlerFactory(factoryClass);
    }

    public static PartitionSystemHandlerFactory createHandlerFactory(Class<? extends PartitionSystemHandlerFactory> factoryClass) {
        try {
            Constructor<? extends PartitionSystemHandlerFactory> c = factoryClass.getConstructor(new Class[0]);
            return c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

