/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.ps;

import java.util.LinkedList;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.storage.io.DataLocator;
import org.catacombae.storage.ps.PartitionSystemHandlerFactory;
import org.catacombae.storage.ps.PartitionSystemType;

public class PartitionSystemDetector {
    public static PartitionSystemType[] detectPartitionSystem(DataLocator inputDataLocator, boolean includeOverridden) {
        ReadableRandomAccessStream dlStream = inputDataLocator.createReadOnlyFile();
        PartitionSystemType[] result = PartitionSystemDetector.detectPartitionSystem(dlStream, includeOverridden);
        dlStream.close();
        return result;
    }

    public static PartitionSystemType[] detectPartitionSystem(ReadableRandomAccessStream psStream, boolean includeOverridden) {
        long len;
        try {
            len = psStream.length();
        }
        catch (RuntimeIOException e) {
            len = -1L;
        }
        return PartitionSystemDetector.detectPartitionSystem(psStream, 0L, len, includeOverridden);
    }

    public static PartitionSystemType[] detectPartitionSystem(ReadableRandomAccessStream psStream, long off, long len, boolean includeOverridden) {
        LinkedList<PartitionSystemType> result;
        LinkedList<PartitionSystemType> rawResult = new LinkedList<PartitionSystemType>();
        for (PartitionSystemType type : PartitionSystemType.values()) {
            PartitionSystemHandlerFactory fact;
            if (!type.isTopLevelCapable() || (fact = type.createDefaultHandlerFactory()) == null || !fact.getRecognizer().detect(psStream, off, len)) continue;
            rawResult.add(type);
        }
        if (includeOverridden) {
            result = rawResult;
        } else {
            result = new LinkedList();
            for (PartitionSystemType type : rawResult) {
                boolean isOverridden = false;
                for (PartitionSystemType type2 : rawResult) {
                    for (PartitionSystemType overriddenType : type2.getOverriddenPartitionSystems()) {
                        if (overriddenType != type) continue;
                        isOverridden = true;
                        break;
                    }
                    if (!isOverridden) continue;
                    break;
                }
                if (isOverridden) continue;
                result.add(type);
            }
        }
        return result.toArray(new PartitionSystemType[result.size()]);
    }
}

