/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.io.win32;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Random;
import org.catacombae.io.RandomAccessStream;
import org.catacombae.storage.io.win32.ReadableWin32FileStream;
import org.catacombae.util.Util;

public class Win32FileStream
extends ReadableWin32FileStream
implements RandomAccessStream {
    private byte[] sectorBuffer;
    private static BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
    private static Win32FileStream wwf;
    private static RandomAccessFile ref;
    private static long currentSeekPos;
    private static int currentBufferSize;

    public Win32FileStream(String filename) {
        super(filename);
        this.sectorBuffer = new byte[this.sectorSize];
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int pos, int len) {
        long endFP;
        if (this.fileHandle != null) {
            long fileLength = Win32FileStream.length(this.fileHandle);
            System.out.println("write(b, " + pos + ", " + len + ");");
            long startFP = this.filePointer;
            endFP = this.filePointer + (long)len;
            long startSectorFP = startFP / (long)this.sectorSize * (long)this.sectorSize;
            int startSectorFPOffset = (int)(startFP - startSectorFP);
            long endSectorFP = endFP / (long)this.sectorSize * (long)this.sectorSize;
            int endSectorFPLength = (int)(endFP - endSectorFP);
            int inputPos = pos;
            Win32FileStream.seek(startSectorFP, this.fileHandle);
            int bytesToRead = (int)((long)this.sectorBuffer.length > fileLength ? fileLength : (long)this.sectorBuffer.length);
            if (Win32FileStream.read(this.sectorBuffer, 0, bytesToRead, this.fileHandle) != bytesToRead) {
                throw new RuntimeException("Could not read contents of starting sector!");
            }
            System.out.println("Writing first bytes.");
            Win32FileStream.seek(startSectorFP, this.fileHandle);
            int remainingSpaceInBuffer = this.sectorBuffer.length - startSectorFPOffset;
            int bytesToReplace = len < remainingSpaceInBuffer ? len : remainingSpaceInBuffer;
            System.arraycopy(b, inputPos, this.sectorBuffer, startSectorFPOffset, bytesToReplace);
            inputPos += bytesToReplace;
            Win32FileStream.write(this.sectorBuffer, 0, startSectorFPOffset + bytesToReplace, this.fileHandle);
            for (long currentSectorFP = startSectorFP + (long)this.sectorSize; currentSectorFP < endSectorFP; currentSectorFP += (long)this.sectorSize) {
                System.out.println("Writing non-complicated sector " + (currentSectorFP - startSectorFP) / (long)this.sectorSize + "...");
                System.arraycopy(b, inputPos, this.sectorBuffer, 0, this.sectorBuffer.length);
                inputPos += this.sectorBuffer.length;
                Win32FileStream.write(this.sectorBuffer, 0, this.sectorBuffer.length, this.fileHandle);
            }
            if (startSectorFP != endSectorFP && endSectorFPLength > 0) {
                int finalWriteLength = this.sectorSize;
                if (fileLength < endSectorFP + (long)this.sectorSize) {
                    finalWriteLength = endSectorFPLength;
                }
                if (Win32FileStream.read(this.sectorBuffer, 0, finalWriteLength, this.fileHandle) != finalWriteLength) {
                    throw new RuntimeException("Could not read contents of end sector!");
                }
                System.arraycopy(b, inputPos, this.sectorBuffer, 0, endSectorFPLength);
                Win32FileStream.seek(endSectorFP, this.fileHandle);
                Win32FileStream.write(this.sectorBuffer, 0, finalWriteLength, this.fileHandle);
            }
        } else {
            throw new RuntimeException("File closed!");
        }
        this.seek(endFP);
    }

    public void write(int b) {
        this.write(new byte[]{(byte)(b & 0xFF)});
    }

    protected byte[] open(String filename) {
        return Win32FileStream.openNative(filename);
    }

    protected static native byte[] openNative(String var0);

    protected static native void write(byte[] var0, int var1, int var2, byte[] var3);

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("The program takes two different files with identical contents as arguments.");
            return;
        }
        try {
            wwf = new Win32FileStream(args[0]);
            ref = new RandomAccessFile(args[1], "rw");
            Random rnd = new Random();
            if (wwf.length() != ref.length()) {
                System.out.println("The two files must be equal in length! (" + wwf.length() + " != " + ref.length() + ")");
                return;
            }
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            int maxBufferSize = 100000;
            int constantBufferSize = 3912;
            byte[] constantBufferLeft = new byte[constantBufferSize];
            byte[] constantBufferRight = new byte[constantBufferSize];
            while (true) {
                wwf.seek(0L);
                long currentSeekPos = (long)((double)(wwf.length() - 1L) * rnd.nextDouble());
                int currentBufferSize = rnd.nextInt(maxBufferSize);
                if (currentSeekPos + (long)currentBufferSize > wwf.length()) {
                    currentBufferSize = (int)(wwf.length() - currentSeekPos);
                }
                byte[] currentBufferLeft = new byte[currentBufferSize];
                byte[] currentBufferRight = new byte[currentBufferSize];
                wwf.seek(currentSeekPos);
                ref.seek(currentSeekPos);
                wwf.readFully(currentBufferLeft);
                ref.readFully(currentBufferRight);
                Win32FileStream.testEquality(currentBufferLeft, currentBufferRight, "(1) Data not equal after reads!");
                if (currentSeekPos + (long)currentBufferSize + (long)constantBufferSize <= wwf.length()) {
                    wwf.readFully(constantBufferLeft);
                    ref.readFully(constantBufferRight);
                    Win32FileStream.testEquality(currentBufferLeft, currentBufferRight, "(2) Data following reads not equal!");
                }
                wwf.seek(0L);
                ref.seek(0L);
                wwf.seek(currentSeekPos);
                ref.seek(currentSeekPos);
                wwf.write(currentBufferLeft);
                ref.write(currentBufferRight);
                wwf.seek(currentSeekPos);
                ref.seek(currentSeekPos);
                wwf.readFully(currentBufferLeft);
                ref.readFully(currentBufferRight);
                Win32FileStream.testEquality(currentBufferLeft, currentBufferRight, "(3) Data not equal after writes!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static void testEquality(byte[] a, byte[] b, String idMessage) throws Exception {
        if (!Util.arraysEqual(a, b)) {
            System.out.println(idMessage);
            System.out.println("  currentSeekPos=" + currentSeekPos);
            System.out.println("  currentBufferSize=" + currentBufferSize);
            System.out.println("  wwf.length()=" + wwf.length());
            System.out.println("  ref.length()=" + ref.length());
            System.out.println("  wwf.getFilePointer()=" + wwf.getFilePointer());
            System.out.println("  ref.getFilePointer()=" + ref.getFilePointer());
            System.out.print("Press enter to continue: ");
            stdin.readLine();
        }
    }
}

