/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.io;

import org.catacombae.io.ConcatenatedStream;
import org.catacombae.io.RandomAccessStream;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.io.DataLocator;
import org.catacombae.storage.io.win32.ReadableWin32FileStream;
import org.catacombae.storage.io.win32.Win32FileStream;

public class WindowsDeviceDataLocator
extends DataLocator {
    private final String devicePath;
    private final Long pos;
    private final Long len;

    public WindowsDeviceDataLocator(String pDevicePath) {
        this.devicePath = pDevicePath;
        this.pos = null;
        this.len = null;
    }

    public WindowsDeviceDataLocator(String pDevicePath, long pPos, long pLen) {
        this.devicePath = pDevicePath;
        this.pos = pPos;
        this.len = pLen;
    }

    public ReadableRandomAccessStream createReadOnlyFile() {
        ReadableWin32FileStream llf = new ReadableWin32FileStream(this.devicePath);
        if (this.pos != null && this.len != null) {
            return new ReadableConcatenatedStream(llf, (long)this.pos, (long)this.len);
        }
        return llf;
    }

    public RandomAccessStream createReadWriteFile() {
        Win32FileStream wllf = new Win32FileStream(this.devicePath);
        if (this.pos != null && this.len != null) {
            return new ConcatenatedStream(wllf, (long)this.pos, (long)this.len);
        }
        return wllf;
    }

    public boolean isWritable() {
        return true;
    }

    public void releaseResources() {
    }
}

