/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.io;

import org.catacombae.io.RandomAccessStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessSubstream;
import org.catacombae.io.SynchronizedReadableRandomAccessStream;
import org.catacombae.storage.io.DataLocator;

public class ReadableStreamDataLocator
extends DataLocator {
    private SynchronizedReadableRandomAccessStream backingStream;
    private boolean closed = false;

    public ReadableStreamDataLocator(ReadableRandomAccessStream sourceStream) {
        this.backingStream = new SynchronizedReadableRandomAccessStream(sourceStream);
    }

    public ReadableRandomAccessStream createReadOnlyFile() {
        return new ReadableRandomAccessSubstream(this.backingStream);
    }

    public RandomAccessStream createReadWriteFile() {
        throw new UnsupportedOperationException("Not supported for this implementation.");
    }

    public boolean isWritable() {
        return false;
    }

    public SynchronizedReadableRandomAccessStream getBackingStream() {
        return this.backingStream;
    }

    public synchronized void releaseResources() {
        if (this.closed) {
            throw new RuntimeException("Stream is already closed.");
        }
        this.backingStream.close();
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

