/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.io;

import java.io.File;
import org.catacombae.io.ConcatenatedStream;
import org.catacombae.io.FileStream;
import org.catacombae.io.RandomAccessStream;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.io.DataLocator;

public class RandomAccessFileDataLocator
extends DataLocator {
    private final File file;
    private final Long pos;
    private final Long len;
    private final boolean writable;

    public RandomAccessFileDataLocator(String pPath) {
        this(new File(pPath));
    }

    public RandomAccessFileDataLocator(String pPath, boolean pWritable) {
        this(new File(pPath), pWritable);
    }

    public RandomAccessFileDataLocator(String pPath, long pPos, long pLen) {
        this(new File(pPath), pPos, pLen, true);
    }

    public RandomAccessFileDataLocator(String pPath, long pPos, long pLen, boolean pWritable) {
        this(new File(pPath), pPos, pLen, pWritable);
    }

    public RandomAccessFileDataLocator(File pFile) {
        this(pFile, null, null, true);
    }

    public RandomAccessFileDataLocator(File pFile, boolean pWritable) {
        this(pFile, null, null, pWritable);
    }

    public RandomAccessFileDataLocator(File pFile, long pPos, long pLen) {
        this(pFile, new Long(pPos), new Long(pLen), true);
    }

    public RandomAccessFileDataLocator(File pFile, long pPos, long pLen, boolean pWritable) {
        this(pFile, new Long(pPos), new Long(pLen), pWritable);
    }

    private RandomAccessFileDataLocator(File pFile, Long pPos, Long pLen, boolean writable) {
        if (!pFile.canRead()) {
            throw new RuntimeException("Can not read from file!");
        }
        if (writable && !pFile.canWrite()) {
            throw new RuntimeException("Requested write mode but file is not writable.");
        }
        this.file = pFile;
        this.pos = pPos;
        this.len = pLen;
        this.writable = writable;
    }

    public ReadableRandomAccessStream createReadOnlyFile() {
        ReadableFileStream llf = new ReadableFileStream(this.file);
        if (this.pos != null && this.len != null) {
            return new ReadableConcatenatedStream(llf, (long)this.pos, (long)this.len);
        }
        return llf;
    }

    public RandomAccessStream createReadWriteFile() {
        FileStream wllf = new FileStream(this.file);
        if (this.pos != null && this.len != null) {
            return new ConcatenatedStream(wllf, (long)this.pos, (long)this.len);
        }
        return wllf;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void releaseResources() {
    }
}

