/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.io;

import org.catacombae.io.RandomAccessStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.io.SubDataLocator;

public abstract class DataLocator {
    private boolean closed = false;
    private long references = 1L;

    public abstract ReadableRandomAccessStream createReadOnlyFile();

    public abstract boolean isWritable();

    public abstract RandomAccessStream createReadWriteFile() throws UnsupportedOperationException;

    public final synchronized void close() {
        if (this.closed) {
            throw new RuntimeException("Already closed.");
        }
        this.dereference(true);
        this.closed = true;
    }

    private synchronized void dereference(boolean closing) {
        if ((this.closed || closing) && this.references <= 0L || !this.closed && !closing && this.references <= 1L) {
            throw new RuntimeException("Too few references left!");
        }
        --this.references;
        if (this.references == 0L) {
            this.releaseResources();
        }
    }

    protected abstract void releaseResources();

    public final synchronized void addReference(SubDataLocator l) {
        ++this.references;
    }

    public final synchronized void removeReference(SubDataLocator l) {
        this.dereference(false);
    }
}

