/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfsplus;

import org.catacombae.hfs.types.hfs.ExtDescriptor;
import org.catacombae.hfs.types.hfs.HFSPlusWrapperMDB;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.fs.DefaultFileSystemHandlerInfo;
import org.catacombae.storage.fs.FileSystemHandler;
import org.catacombae.storage.fs.FileSystemHandlerFactory;
import org.catacombae.storage.fs.FileSystemHandlerInfo;
import org.catacombae.storage.fs.FileSystemRecognizer;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemHandlerFactory;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemRecognizer;
import org.catacombae.storage.fs.hfsplus.HFSPlusFileSystemHandler;
import org.catacombae.storage.fs.hfsplus.HFSPlusFileSystemRecognizer;
import org.catacombae.storage.io.DataLocator;
import org.catacombae.storage.io.SubDataLocator;
import org.catacombae.util.Util;

public class HFSPlusFileSystemHandlerFactory
extends HFSCommonFileSystemHandlerFactory {
    private static final FileSystemRecognizer recognizer = new HFSPlusFileSystemRecognizer();
    private static final FileSystemHandlerInfo handlerInfo = new DefaultFileSystemHandlerInfo("org.catacombae.hfs_plus_handler", "HFS+ file system handler", "1.0", 0L, "Erik Larsson, Catacombae Software");
    private static final FileSystemHandlerFactory.CustomAttribute compositionEnabledAttribute = HFSPlusFileSystemHandlerFactory.createCustomAttribute(FileSystemHandlerFactory.AttributeType.BOOLEAN, "COMPOSE_UNICODE_FILENAMES", "Decides whether Unicode filenames should be composed or left in their original decomposed form.", true);
    private static final FileSystemHandlerFactory.CustomAttribute hideProtectedAttribute = HFSPlusFileSystemHandlerFactory.createCustomAttribute(FileSystemHandlerFactory.AttributeType.BOOLEAN, "HIDE_PROTECTED_FILES", "Decides whether protected files like the inode directories and the journal files should show up in a directory listing.", true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemHandler createHandler(DataLocator data) {
        DataLocator dataToLoad;
        boolean useCaching = this.createAttributes.getBooleanAttribute(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED);
        boolean composeFilename = this.createAttributes.getBooleanAttribute(compositionEnabledAttribute);
        boolean hideProtected = this.createAttributes.getBooleanAttribute(hideProtectedAttribute);
        ReadableRandomAccessStream recognizerStream = data.createReadOnlyFile();
        try {
            HFSCommonFileSystemRecognizer.FileSystemType type = HFSCommonFileSystemRecognizer.detectFileSystem(recognizerStream, 0L);
            if (type == HFSCommonFileSystemRecognizer.FileSystemType.HFS_WRAPPED_HFS_PLUS) {
                dataToLoad = HFSPlusFileSystemHandlerFactory.hfsUnwrap(data);
            } else {
                if (type == HFSCommonFileSystemRecognizer.FileSystemType.UNKNOWN) {
                    throw new RuntimeException("No HFS file system found at 'data'.");
                }
                dataToLoad = data;
            }
        }
        finally {
            recognizerStream.close();
        }
        return this.createHandlerInternal(dataToLoad, useCaching, composeFilename, hideProtected);
    }

    protected FileSystemHandler createHandlerInternal(DataLocator data, boolean useCaching, boolean composeFilename, boolean hideProtected) {
        return new HFSPlusFileSystemHandler(data, useCaching, composeFilename, hideProtected);
    }

    public FileSystemHandlerInfo getHandlerInfo() {
        return handlerInfo;
    }

    public FileSystemHandlerFactory.StandardAttribute[] getSupportedStandardAttributes() {
        this.setStandardAttributeDefaultValue(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED, true);
        return new FileSystemHandlerFactory.StandardAttribute[]{FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED};
    }

    public FileSystemHandlerFactory.CustomAttribute[] getSupportedCustomAttributes() {
        return new FileSystemHandlerFactory.CustomAttribute[]{compositionEnabledAttribute, hideProtectedAttribute};
    }

    public FileSystemHandlerFactory newInstance() {
        return new HFSPlusFileSystemHandlerFactory();
    }

    public FileSystemRecognizer getRecognizer() {
        return recognizer;
    }

    private static DataLocator hfsUnwrap(DataLocator data) {
        ReadableRandomAccessStream fsStream = data.createReadOnlyFile();
        byte[] mdbData = new byte[170];
        fsStream.seek(1024L);
        fsStream.read(mdbData);
        HFSPlusWrapperMDB mdb = new HFSPlusWrapperMDB(mdbData, 0);
        ExtDescriptor xd = mdb.getDrEmbedExtent();
        int hfsBlockSize = mdb.getDrAlBlkSiz();
        long fsOffset = Util.unsign(mdb.getDrAlBlSt()) * 512 + Util.unsign(xd.getXdrStABN()) * hfsBlockSize;
        long fsLength = Util.unsign(xd.getXdrNumABlks() * hfsBlockSize);
        return new SubDataLocator(data, fsOffset, fsLength);
    }
}

