/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfscommon;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.util.Util;

public class HFSCommonFileSystemRecognizer {
    private static final short SIGNATURE_MFS = -11561;
    private static final short SIGNATURE_HFS = 16964;
    private static final short SIGNATURE_HFS_PLUS = 18475;
    private static final short SIGNATURE_HFSX = 18520;
    public static final FileSystemType[] supportedTypes = new FileSystemType[]{FileSystemType.HFS, FileSystemType.HFS_PLUS, FileSystemType.HFS_WRAPPED_HFS_PLUS, FileSystemType.HFSX};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileSystemType detectFileSystem(ReadableRandomAccessStream bitstream, long offset) {
        try {
            bitstream.seek(offset);
            byte[] signatureData = new byte[4096];
            bitstream.readFully(signatureData);
            short signature = Util.readShortBE(signatureData, 1024);
            switch (signature) {
                case -11561: {
                    return FileSystemType.MFS;
                }
                case 16964: {
                    try {
                        short embeddedSignature = Util.readShortBE(signatureData, 1148);
                        if (embeddedSignature == 18475) {
                            return FileSystemType.HFS_WRAPPED_HFS_PLUS;
                        }
                        return FileSystemType.HFS;
                    }
                    catch (Exception e) {
                        return FileSystemType.HFS;
                    }
                }
                case 18475: {
                    return FileSystemType.HFS_PLUS;
                }
                case 18520: {
                    return FileSystemType.HFSX;
                }
            }
            return FileSystemType.UNKNOWN;
        }
        catch (Exception e) {
            System.err.println("Exception while detecting file system:");
            e.printStackTrace();
            return FileSystemType.UNKNOWN;
        }
    }

    public static boolean isTypeSupported(FileSystemType fst) {
        for (FileSystemType cur : supportedTypes) {
            if (cur != fst) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileSystemType {
        MFS,
        HFS,
        HFS_PLUS,
        HFS_WRAPPED_HFS_PLUS,
        HFSX,
        UNKNOWN;

    }
}

