/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfscommon;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.UnicodeNormalizationToolkit;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileThreadRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderThread;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderThreadRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.fs.FSEntry;
import org.catacombae.storage.fs.FSFolder;
import org.catacombae.storage.fs.FSForkType;
import org.catacombae.storage.fs.FSLink;
import org.catacombae.storage.fs.FileSystemHandler;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSFile;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSFolder;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSLink;
import org.catacombae.util.IOUtil;
import org.catacombae.util.Util;

public class HFSCommonFileSystemHandler
extends FileSystemHandler {
    private static final String FILE_HARD_LINK_DIR = "\u0000\u0000\u0000\u0000HFS+ Private Data";
    private static final String FILE_HARD_LINK_PREFIX = "iNode";
    private static final String DIRECTORY_HARD_LINK_DIR = ".HFS+ Private Directory Data\r";
    private static final String DIRECTORY_HARD_LINK_PREFIX = "dir_";
    private static final String JOURNAL_INFO_BLOCK_FILE = ".journal_info_block";
    private static final String JOURNAL_FILE = ".journal";
    private static final boolean DEBUG = Util.booleanEnabledByProperties(false, "org.catacombae.debug", "org.catacombae.storage.debug", "org.catacombae.storage.fs.debug", "org.catacombae.storage.fs.hfscommon.debug", "org.catacombae.storage.fs.hfscommon." + HFSCommonFileSystemHandler.class.getSimpleName() + ".debug");
    private HFSVolume view;
    private boolean doUnicodeFileNameComposition;
    private boolean hideProtected;

    protected HFSCommonFileSystemHandler(HFSVolume iView, boolean iDoUnicodeFileNameComposition, boolean hideProtected) {
        this.view = iView;
        this.doUnicodeFileNameComposition = iDoUnicodeFileNameComposition;
        this.hideProtected = hideProtected;
    }

    public FSEntry[] list(String ... path) {
        CommonHFSCatalogFolderRecord curFolder = this.view.getCatalogFile().getRootFolder();
        for (String nextFolderName : path) {
            CommonHFSCatalogLeafRecord subRecord = this.getRecord(curFolder, nextFolderName);
            if (subRecord == null || !(subRecord instanceof CommonHFSCatalogFolderRecord)) {
                return null;
            }
            curFolder = (CommonHFSCatalogFolderRecord)subRecord;
        }
        return this.listFSEntries(curFolder);
    }

    public FSEntry getEntry(String ... path) {
        return this.getEntry(this.view.getCatalogFile().getRootFolder(), path);
    }

    FSEntry getEntry(CommonHFSCatalogFolderRecord rootRecord, String ... path) {
        CommonHFSCatalogLeafRecord rec = this.getRecord(rootRecord, path);
        if (rec == null) {
            return null;
        }
        if (rec instanceof CommonHFSCatalogFileRecord) {
            return this.entryFromRecord((CommonHFSCatalogFileRecord)rec);
        }
        if (rec instanceof CommonHFSCatalogFolderRecord) {
            return this.entryFromRecord((CommonHFSCatalogFolderRecord)rec);
        }
        throw new RuntimeException("Did not excpect a " + rec.getClass() + " here!");
    }

    CommonHFSCatalogLeafRecord getRecord(CommonHFSCatalogFolderRecord rootRecord, String ... path) {
        if (rootRecord == null) {
            throw new IllegalArgumentException("rootRecord == null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        LinkedList<Object[]> visitedList = null;
        CommonHFSCatalogLeafRecord currentRoot = rootRecord;
        for (int i = 0; i < path.length; ++i) {
            String curPathComponent = path[i];
            LinkedList<Object[]> curVisitedList = null;
            while (currentRoot instanceof CommonHFSCatalogFileRecord) {
                Object[] absPath;
                CommonHFSCatalogFileRecord fr = (CommonHFSCatalogFileRecord)currentRoot;
                if (fr.getData().isSymbolicLink()) {
                    String[] basePath;
                    byte[] data = IOUtil.readFully(this.getReadableDataForkStream(fr));
                    String posixPath = Util.readString(data, "UTF-8");
                    absPath = this.getTruePathFromPosixPath(posixPath, basePath = Util.arrayCopy(path, 0, new String[i - 1], 0, i - 1));
                    if (absPath == null) {
                        return null;
                    }
                } else if (fr.getData().isHardFileLink()) {
                    absPath = new String[]{FILE_HARD_LINK_DIR, FILE_HARD_LINK_PREFIX + Util.unsign(fr.getData().getHardLinkInode())};
                } else {
                    if (!fr.getData().isHardDirectoryLink()) break;
                    absPath = new String[]{DIRECTORY_HARD_LINK_DIR, DIRECTORY_HARD_LINK_PREFIX + Util.unsign(fr.getData().getHardLinkInode())};
                }
                if (curVisitedList == null) {
                    if (visitedList == null) {
                        visitedList = new LinkedList<Object[]>();
                    } else {
                        visitedList.clear();
                    }
                    curVisitedList = visitedList;
                }
                if (absPath == null) {
                    throw new RuntimeException("'assertion' failed. absPath shouldn't be null");
                }
                if (Util.contains(curVisitedList, absPath)) {
                    if (DEBUG) {
                        System.err.println("WARNING: Detected cyclic link structure when resolving link target.");
                        System.err.println("         Resolve stack:");
                        for (Object[] sa : curVisitedList) {
                            System.err.println("           " + Util.concatenateStrings(sa, "/"));
                        }
                        System.err.println("           " + Util.concatenateStrings(absPath, "/"));
                    }
                    return null;
                }
                curVisitedList.addLast(absPath);
                CommonHFSCatalogLeafRecord linkTarget = this.getRecord(this.view.getCatalogFile().getRootFolder(), (String[])absPath);
                if (linkTarget == null) continue;
                currentRoot = linkTarget;
            }
            if (!(currentRoot instanceof CommonHFSCatalogFolderRecord)) {
                return null;
            }
            CommonHFSCatalogFolderRecord currentRootFolder = currentRoot;
            CommonHFSCatalogLeafRecord newRoot = this.view.getCatalogFile().getRecord(currentRootFolder.getData().getFolderID(), this.view.encodeString(curPathComponent));
            if (newRoot == null) {
                return null;
            }
            currentRoot = newRoot;
        }
        return currentRoot;
    }

    private FSEntry entryFromRecord(CommonHFSCatalogFileRecord fileRecord) {
        if (fileRecord.getData().isSymbolicLink()) {
            return new HFSCommonFSLink(this, fileRecord);
        }
        if (fileRecord.getData().isHardFileLink()) {
            CommonHFSCatalogFileRecord iNode = this.lookupFileInode(fileRecord.getData().getHardLinkInode());
            if (iNode != null) {
                return new HFSCommonFSFile(this, fileRecord, iNode);
            }
            System.err.println("Looking up file iNode " + fileRecord.getData().getHardLinkInode() + " (" + fileRecord.getKey().getParentID().toLong() + ":\"" + this.getProperNodeName(fileRecord) + "\") FAILED!");
            return new HFSCommonFSFile(this, fileRecord);
        }
        if (fileRecord.getData().isHardDirectoryLink()) {
            CommonHFSCatalogFolderRecord iNode = this.lookupDirectoryInode(fileRecord.getData().getHardLinkInode());
            if (iNode != null) {
                return new HFSCommonFSFolder(this, fileRecord, iNode);
            }
            System.err.println("Looking up directory iNode " + fileRecord.getData().getHardLinkInode() + " (" + fileRecord.getKey().getParentID().toLong() + ":\"" + this.getProperNodeName(fileRecord) + "\") FAILED!");
            return new HFSCommonFSFile(this, fileRecord);
        }
        return new HFSCommonFSFile(this, fileRecord);
    }

    private FSEntry entryFromRecord(CommonHFSCatalogFolderRecord folderRecord) {
        return new HFSCommonFSFolder(this, folderRecord);
    }

    CommonHFSCatalogFileRecord lookupFileInode(int inodeNumber) {
        long trueInodeNumber = Util.unsign(inodeNumber);
        CommonHFSCatalogLeafRecord res = this.getRecord(this.view.getCatalogFile().getRootFolder(), FILE_HARD_LINK_DIR, FILE_HARD_LINK_PREFIX + trueInodeNumber);
        if (res == null) {
            return null;
        }
        if (res instanceof CommonHFSCatalogFileRecord) {
            return (CommonHFSCatalogFileRecord)res;
        }
        throw new RuntimeException("Error in HFS+ file system structure: Found a " + res.getClass() + " in file hard link dir for iNode" + trueInodeNumber);
    }

    CommonHFSCatalogFolderRecord lookupDirectoryInode(int inodeNumber) {
        long trueInodeNumber = Util.unsign(inodeNumber);
        CommonHFSCatalogLeafRecord res = this.getRecord(this.view.getCatalogFile().getRootFolder(), DIRECTORY_HARD_LINK_DIR, DIRECTORY_HARD_LINK_PREFIX + trueInodeNumber);
        if (res == null) {
            return null;
        }
        if (res instanceof CommonHFSCatalogFolderRecord) {
            return (CommonHFSCatalogFolderRecord)res;
        }
        throw new RuntimeException("Error in HFS+ file system structure: Found a " + res.getClass() + " in directory hard link dir for dir_" + trueInodeNumber);
    }

    public FSForkType[] getSupportedForkTypes() {
        return new FSForkType[]{FSForkType.DATA, FSForkType.MACOS_RESOURCE};
    }

    String getProperNodeName(CommonHFSCatalogLeafRecord record) {
        String nodeNameRaw = this.view.decodeString(record.getKey().getNodeName());
        if (this.doUnicodeFileNameComposition) {
            return UnicodeNormalizationToolkit.getDefaultInstance().compose(nodeNameRaw);
        }
        return nodeNameRaw;
    }

    public static String[] splitPOSIXUTF8Path(byte[] path) {
        return HFSCommonFileSystemHandler.splitPOSIXUTF8Path(path, 0, path.length);
    }

    public static String[] splitPOSIXUTF8Path(byte[] path, int offset, int length) {
        try {
            String s = new String(path, offset, length, "UTF-8");
            String[] res = s.split("/");
            for (int i = 0; i < res.length; ++i) {
                res[i] = res[i].replace(':', '/');
            }
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("REALLY UNEXPECTED: Could not decode UTF-8!", e);
        }
    }

    ReadableRandomAccessStream getReadableDataForkStream(CommonHFSCatalogFileRecord fileRecord) {
        return this.view.getReadableDataForkStream(fileRecord);
    }

    ReadableRandomAccessStream getReadableResourceForkStream(CommonHFSCatalogFileRecord fileRecord) {
        return this.view.getReadableResourceForkStream(fileRecord);
    }

    private boolean shouldHide(CommonHFSCatalogLeafRecord rec) {
        if (rec.getKey() instanceof CommonHFSCatalogKey.HFSImplementation) {
            return false;
        }
        CommonHFSCatalogNodeID parentID = rec.getKey().getParentID();
        if (!parentID.equals(parentID.getReservedID(CommonHFSCatalogNodeID.ReservedID.ROOT_FOLDER))) {
            return false;
        }
        String name = this.view.decodeString(rec.getKey().getNodeName());
        if (rec instanceof CommonHFSCatalogFileRecord) {
            if (name.equals(JOURNAL_INFO_BLOCK_FILE)) {
                return this.hideProtected;
            }
            if (name.equals(JOURNAL_FILE)) {
                return this.hideProtected;
            }
        } else if (rec instanceof CommonHFSCatalogFolderRecord) {
            if (name.equals(FILE_HARD_LINK_DIR)) {
                return this.hideProtected;
            }
            if (name.equals(DIRECTORY_HARD_LINK_DIR)) {
                return this.hideProtected;
            }
        }
        return false;
    }

    String[] listNames(CommonHFSCatalogFolderRecord folderRecord) {
        CommonHFSCatalogLeafRecord[] subRecords = this.view.getCatalogFile().listRecords(folderRecord);
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < subRecords.length; ++i) {
            CommonHFSCatalogLeafRecord curRecord = subRecords[i];
            if (this.shouldHide(curRecord)) continue;
            result.add(this.getProperNodeName(curRecord));
        }
        return result.toArray(new String[result.size()]);
    }

    FSEntry[] listFSEntries(CommonHFSCatalogFolderRecord folderRecord) {
        CommonHFSCatalogLeafRecord[] subRecords = this.view.getCatalogFile().listRecords(folderRecord);
        LinkedList<FSEntry> result = new LinkedList<FSEntry>();
        for (int i = 0; i < subRecords.length; ++i) {
            CommonHFSCatalogLeafRecord curRecord = subRecords[i];
            FSEntry curEntry = null;
            if (!this.shouldHide(curRecord)) {
                if (curRecord instanceof CommonHFSCatalogFileRecord) {
                    curEntry = this.entryFromRecord((CommonHFSCatalogFileRecord)curRecord);
                } else if (curRecord instanceof CommonHFSCatalogFolderRecord) {
                    curEntry = this.entryFromRecord((CommonHFSCatalogFolderRecord)curRecord);
                }
            }
            if (curEntry == null) continue;
            result.addLast(curEntry);
        }
        return result.toArray(new FSEntry[result.size()]);
    }

    HFSCommonFSFolder lookupParentFolder(CommonHFSCatalogLeafRecord childRecord) {
        CommonHFSCatalogFolderRecord folderRec = this.lookupParentFolderRecord(childRecord);
        if (folderRec != null) {
            return new HFSCommonFSFolder(this, folderRec);
        }
        return null;
    }

    private CommonHFSCatalogFolderRecord lookupParentFolderRecord(CommonHFSCatalogLeafRecord childRecord) {
        CommonHFSCatalogNodeID parentID = childRecord.getKey().getParentID();
        CommonHFSCatalogLeafRecord parent = this.view.getCatalogFile().getRecord(parentID, this.view.getEmptyString());
        if (parent == null) {
            if (parentID.toLong() == 1L) {
                return null;
            }
            throw new RuntimeException("INTERNAL ERROR: No folder thread found for ID " + parentID.toLong() + "!");
        }
        if (parent instanceof CommonHFSCatalogFolderThreadRecord) {
            CommonHFSCatalogFolderThread data = ((CommonHFSCatalogFolderThreadRecord)parent).getData();
            CommonHFSCatalogLeafRecord rec = this.view.getCatalogFile().getRecord(data.getParentID(), data.getNodeName());
            if (rec == null) {
                return null;
            }
            if (rec instanceof CommonHFSCatalogFolderRecord) {
                return (CommonHFSCatalogFolderRecord)rec;
            }
            throw new RuntimeException("Internal error: rec not instanceof CommonHFSCatalogFolderRecord, but instead:" + rec.getClass());
        }
        if (parent instanceof CommonHFSCatalogFileThreadRecord) {
            throw new RuntimeException("Tried to get folder thread record (" + parentID + ",\"\") but found a file thread record!");
        }
        throw new RuntimeException("Tried to get folder thread record (" + parentID + ",\"\") but found a " + parent.getClass() + "!");
    }

    public HFSVolume getFSView() {
        return this.view;
    }

    public void close() {
        this.view.close();
    }

    public FSFolder getRoot() {
        return new HFSCommonFSFolder(this, this.view.getCatalogFile().getRootFolder());
    }

    public String parsePosixPathnameComponent(String posixPathnameComponent) {
        return posixPathnameComponent.replace(':', '/');
    }

    public String generatePosixPathnameComponent(String fsPathnameComponent) {
        return fsPathnameComponent.replace("/", ":");
    }

    public String[] getTargetPath(FSLink link, String[] parentDir) {
        if (link instanceof HFSCommonFSLink) {
            HFSCommonFSLink hfsLink = (HFSCommonFSLink)link;
            return this.getTruePathFromPosixPath(hfsLink.getLinkTargetPosixPath(), parentDir);
        }
        throw new RuntimeException("Invalid type: " + link.getClass());
    }
}

